/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlParser;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetHtmlWriter
extends AbstractWriter {
    private boolean wasHead;
    private boolean needEncoding;
    private boolean needSpacesEncoding;
    private boolean wasSpace = true;
    private boolean inlineMode = false;
    private boolean writeHierachie = true;
    private boolean allowStyleSpan = true;
    private Element sharedParent;
    private boolean writeStyleSpanAfterBody = false;
    private Element styleSpanParent = null;
    private InetHtmlConfiguration currentConfig;
    private Map<String, String> imageReplaceMap = null;
    private Map<HTML.Tag, Boolean> tagWritingOptionsMap;
    private int endOffset = 0;
    private int sharedParentStart;
    private int sharedParentEnd;
    private static boolean sortAttributes = false;
    private Document document;
    private static final Set<CSS.Attribute> BORDER_STYLES = new HashSet<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.BORDER_BOTTOM_STYLE);
            this.add(CSS.Attribute.BORDER_TOP_STYLE);
            this.add(CSS.Attribute.BORDER_LEFT_STYLE);
            this.add(CSS.Attribute.BORDER_RIGHT_STYLE);
        }
    };
    private static final Set<CSS.Attribute> BORDER_WIDTH = new HashSet<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.BORDER_BOTTOM_WIDTH);
            this.add(CSS.Attribute.BORDER_TOP_WIDTH);
            this.add(CSS.Attribute.BORDER_LEFT_WIDTH);
            this.add(CSS.Attribute.BORDER_RIGHT_WIDTH);
        }
    };
    private static final List<CSS.Attribute> STYLE_SPAN_ATTS = new ArrayList<CSS.Attribute>(){
        {
            this.add(CSS.Attribute.COLOR);
            this.add(CSS.Attribute.DIRECTION);
            this.add(CSS.Attribute.FONT_FAMILY);
            this.add(CSS.Attribute.FONT_SIZE);
            this.add(CSS.Attribute.FONT_STYLE);
            this.add(CSS.Attribute.FONT_VARIANT);
            this.add(CSS.Attribute.FONT_WEIGHT);
            this.add(CSS.Attribute.LETTER_SPACING);
            this.add(CSS.Attribute.LINE_HEIGHT);
            this.add(CSS.Attribute.TEXT_DECORATION);
            this.add(CSS.Attribute.TEXT_INDENT);
            this.add(CSS.Attribute.TEXT_TRANSFORM);
            this.add(CSS.Attribute.VERTICAL_ALIGN);
            this.add(CSS.Attribute.WHITE_SPACE);
            this.add(CSS.Attribute.WORD_SPACING);
        }
    };

    public InetHtmlWriter(Writer writer, Element element) {
        super(writer, element.getDocument(), element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        this.init(element.getDocument(), element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), element);
    }

    public InetHtmlWriter(Writer writer, Document document, int n2, int n3) {
        super(writer, document, n2, n3);
        this.init(document, n2, n3, null);
    }

    private void init(Document document, int n2, int n3, Element element) {
        Object object;
        this.document = document;
        this.currentConfig = document instanceof InetHtmlDocument ? ((InetHtmlDocument)document).getConfiguration() : InetHtmlConfiguration.getBrowserConfig();
        this.setCanWrapLines(false);
        this.setCurrentLineLength(0);
        try {
            object = (Number)document.getProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE);
            if (object != null) {
                this.setIndentSpace(((Number)object).intValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.endOffset = n2 + n3;
        if (this.endOffset == document.getLength()) {
            ++this.endOffset;
        }
        if (n2 > 0 || n3 < document.getLength() || element != null) {
            this.inlineMode = true;
            this.writeHierachie = Boolean.TRUE.equals(document.getProperty(InetHtmlDocument.PROPERTY_WRITE_HIERARCHY));
            Element element2 = this.sharedParent = element != null ? element : ElementUtils.findSharedParagraph(n2, n3, document.getDefaultRootElement());
            block5: while (this.sharedParent != null && (object = this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag) {
                switch ((HTML.Tag)((Object)object)) {
                    case TR: 
                    case TBODY: 
                    case THEAD: 
                    case TFOOT: {
                        this.sharedParent = this.sharedParent.getParentElement();
                        continue block5;
                    }
                }
            }
            if (element == null) {
                boolean bl2;
                int n4 = this.sharedParent.getEndOffset();
                boolean bl3 = bl2 = this.endOffset == n4 || InetHtmlDocument.isParagraph(this.sharedParent) && this.endOffset == n4 - 1;
                while (this.sharedParent != null && this.sharedParent.getStartOffset() == n2 && bl2) {
                    this.sharedParent = this.sharedParent.getParentElement();
                    bl2 = this.endOffset == n4 || InetHtmlDocument.isParagraph(this.sharedParent) && this.endOffset == n4 + 1;
                }
            }
            this.sharedParentStart = this.sharedParent.getStartOffset();
            this.sharedParentEnd = this.sharedParent.getEndOffset();
            if (this.allowStyleSpan) {
                Object object2 = this.sharedParent.getAttributes().getAttribute(StyleConstants.NameAttribute);
                this.writeStyleSpanAfterBody = object2 == HTML.Tag.HTML || object2 == HTML.Tag.BODY || this.writeHierachie;
            }
        }
    }

    @Override
    public void write() throws BadLocationException, IOException {
        String string;
        Element element = this.getElementIterator().first();
        if (this.getStartOffset() + 1 <= this.getEndOffset() && this.isEmpty(element)) {
            return;
        }
        if (this.sharedParent == null && this.document instanceof InetHtmlDocument && (string = ((InetHtmlDocument)this.document).getDocType().getTypeString()) != null) {
            this.write(string);
            this.writeLineSeparator();
        }
        this.writeNode(element);
    }

    private boolean isEmpty(Element element) {
        if (element != null) {
            if (!this.inRange(element)) {
                return true;
            }
            if (element.isLeaf()) {
                AttributeSet attributeSet = element.getAttributes();
                Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                return object == HTML.Tag.CONTENT && attributeSet.getAttribute("CR") != null;
            }
            for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
                Element element2 = element.getElement(i2);
                if (this.isEmpty(element2)) continue;
                return false;
            }
        }
        return true;
    }

    private void writeNode(Element element) throws BadLocationException, IOException {
        if (element != null && (element.isLeaf() || element.getElementCount() > 0)) {
            if (!this.inRange(element)) {
                return;
            }
            if (element.isLeaf()) {
                this.emptyTag(element);
            } else {
                int n2;
                boolean bl2;
                boolean bl3 = this.isToWrite(element);
                boolean bl4 = bl2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HEAD;
                if (bl3) {
                    n2 = !this.wasHead ? 1 : 0;
                    boolean bl5 = bl3 = !this.startTag(element);
                    if (bl2 && n2 != 0) {
                        return;
                    }
                }
                this.sharedParentStart(element);
                for (n2 = 0; n2 < element.getElementCount(); ++n2) {
                    Element element2 = element.getElement(n2);
                    this.incrIndent();
                    this.writeNode(element2);
                    this.decrIndent();
                }
                if (element == this.styleSpanParent) {
                    this.write("</span>");
                }
                if (bl3) {
                    this.endTag(element);
                }
            }
        }
    }

    private void sharedParentStart(Element element) throws IOException {
        if (!this.inlineMode || this.sharedParent == null || this.styleSpanParent != null) {
            return;
        }
        if (this.writeStyleSpanAfterBody && this.allowStyleSpan && element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
            this.writeStyleSpan(element);
            this.styleSpanParent = element;
        } else if (element == this.sharedParent && this.allowStyleSpan) {
            this.writeStyleSpan(element);
            this.styleSpanParent = element;
        }
    }

    private void writeStyleSpan(Element element) throws IOException {
        this.write("<span ");
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        for (CSS.Attribute attribute : STYLE_SPAN_ATTS) {
            AttributeFinder<AttributeValue> attributeFinder = GenericFinder.getFinder(attribute);
            if (attributeFinder == null) continue;
            Object object = null;
            object = attribute != CSS.Attribute.FONT_SIZE ? StyleResolver.getAttributeValue(element, attributeFinder, attribute != CSS.Attribute.FONT_SIZE) : ((object = element.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) instanceof Float ? new FontSize(Math.round(LengthUnit.getPTforPX(((Float)object).floatValue()))) : null);
            if (object == null) continue;
            simpleAttributeSet.addAttribute((Object)attribute, object);
        }
        this.writeAttributes(simpleAttributeSet);
        this.write('>');
    }

    private boolean isToWrite(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TBODY) {
            MutableAttributeSet mutableAttributeSet = ElementUtils.removeNonessentialAttributes(element.getAttributes(), element.getParentElement());
            mutableAttributeSet.removeAttribute(InetHtmlDocument.FLAG_INIT);
            mutableAttributeSet.removeAttribute(StyleConstants.NameAttribute);
            if (mutableAttributeSet.getAttributeCount() == 0) {
                return false;
            }
        }
        if (this.tagWritingOptionsMap != null && this.tagWritingOptionsMap.get(object) != null) {
            return this.tagWritingOptionsMap.get(object);
        }
        if (this.writeHierachie) {
            return true;
        }
        if (object == HTML.Tag.STYLE) {
            return true;
        }
        if (!this.writeHierachie && this.sharedParent == element) {
            return false;
        }
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        if (n2 >= this.sharedParentStart && n3 <= this.sharedParentEnd) {
            if (n2 == this.sharedParentStart && n3 == this.sharedParentEnd && ElementUtils.isRelated(this.sharedParent, element)) {
                return false;
            }
            return n2 != n3 || n2 != this.sharedParentStart || ElementUtils.isRelated(element, this.sharedParent);
        }
        return false;
    }

    protected void emptyTag(Element element) throws BadLocationException, IOException {
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.CONTENT) {
            if (!attributeSet.isDefined("CR")) {
                this.needEncoding = true;
                if (this.isPreformatted(element)) {
                    String string = this.getLineSeparator();
                    this.setLineSeparator("\r\n");
                    this.text(element);
                    this.setLineSeparator(string);
                } else {
                    this.needSpacesEncoding = true;
                    this.text(element);
                }
                this.needSpacesEncoding = false;
                this.needEncoding = false;
            }
        } else {
            this.write('<');
            this.write(object.toString());
            this.writeAttributes(attributeSet);
            this.write('>');
            this.wasSpace = false;
        }
    }

    protected boolean isBlockTag(Element element) {
        return InetHtmlParser.breaksFlow(element);
    }

    protected boolean startTag(Element element) throws IOException {
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.HEAD && !this.wasHead) {
            this.writeHead(element);
            return true;
        }
        if (object == HTML.Tag.BODY && !this.wasHead) {
            this.writeHead(null);
        }
        if (this.wasSpace && !this.isLineEmpty()) {
            if (!this.isPreformatted(element)) {
                this.addFormatLine();
            }
        } else if (this.isBlockTag(element)) {
            this.wasSpace = true;
        }
        this.write('<');
        this.write(object.toString());
        this.writeAttributes(attributeSet);
        this.write('>');
        return false;
    }

    private boolean fillIfEmpy(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (InetHtmlParser.TABLE_STRUCT_TAGS.contains(object)) {
            return false;
        }
        if (object instanceof HTML.Tag) {
            switch ((HTML.Tag)((Object)object)) {
                case HTML: 
                case HEAD: 
                case META: 
                case SCRIPT: 
                case BODY: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void endTag(Element element) throws IOException {
        Element element2;
        Element element3;
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        boolean bl2 = this.isBlockTag(element);
        if (this.currentConfig.isTransformEmptyBlocks() && element.getElementCount() == 1 && (element3 = element.getElement(0)).getAttributes().isDefined("CR") && this.fillIfEmpy(element2 = ElementUtils.findNextHigherBlock(element3))) {
            this.write("&nbsp;");
        }
        if (this.wasSpace && bl2) {
            if (!this.isPreformatted(element)) {
                this.addFormatLine();
            }
        } else if (bl2) {
            this.wasSpace = true;
        }
        this.write("</");
        this.write(object.toString());
        this.write('>');
    }

    @Override
    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inlineMode && attributeSet instanceof Element) {
            StyleResolver styleResolver = ((CssDocument)this.document).getStyleResolver();
            Styles styles = styleResolver.getStyleSheet("DEFAULT");
            Element element = (Element)((Object)attributeSet);
            Element element2 = element.getParentElement();
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            MutableAttributeSet mutableAttributeSet = styles.getDefaultSet(object);
            boolean bl2 = false;
            for (CSS.Attribute attribute : CSS.Attribute.values()) {
                AttributeValue attributeValue;
                AttributeValue attributeValue2;
                AttributeFinder<AttributeValue> attributeFinder = GenericFinder.getFinder(attribute);
                if (attributeFinder == null || (attributeValue2 = StyleResolver.getAttributeValue(element, attributeFinder, attribute != CSS.Attribute.FONT_SIZE)) == null || attributeFinder.getHTMLAttribute() != null && attributeValue2 == element.getAttributes().getAttribute((Object)attributeFinder.getHTMLAttribute())) continue;
                Object object2 = mutableAttributeSet != null ? mutableAttributeSet.getAttribute((Object)TemporaryStyle.getAttribute(attribute)) : null;
                AttributeValue attributeValue3 = styles.getCssAttribute(element, attribute, false);
                Object object3 = object2 = attributeValue3 != null ? attributeValue3 : object2;
                if ((!attributeFinder.isInherited() || element2 == null) && attributeValue2.equals(object2)) {
                    if (!BORDER_WIDTH.contains((Object)attribute)) continue;
                    if (!bl2) {
                        bl2 = false;
                        continue;
                    }
                    bl2 = false;
                }
                if (attributeFinder.isInherited() && (attributeValue2.equals(object2) || object2 == null && element2 != null && attributeValue2.equals(attributeValue = StyleResolver.getAttributeValue(element2, attributeFinder)))) continue;
                if (BORDER_STYLES.contains((Object)attribute) && ((BorderStyleValue)attributeValue2).getStyle() != 0) {
                    bl2 = true;
                }
                if (BORDER_WIDTH.contains((Object)attribute)) {
                    bl2 = false;
                }
                this.writeStyleAttribute(stringBuilder, attribute, attributeValue2);
            }
            Object object4 = attributeSet.getAttributeNames();
            if (sortAttributes) {
                object4 = this.getSortedEnumeration((Enumeration<?>)object4);
            }
            while (object4.hasMoreElements()) {
                Object e2 = object4.nextElement();
                if (!(e2 instanceof HTML.Attribute) || e2 == HTML.Attribute.STYLE) continue;
                Object object5 = attributeSet.getAttribute(e2);
                this.writeAttribute(e2, object5);
            }
        } else {
            Enumeration<Object> enumeration = attributeSet.getAttributeNames();
            if (sortAttributes) {
                enumeration = this.getSortedEnumeration(enumeration);
            }
            while (enumeration.hasMoreElements()) {
                String string;
                Object object = enumeration.nextElement();
                if (object instanceof CSS.Attribute) {
                    this.writeStyleAttribute(stringBuilder, (CSS.Attribute)((Object)object), attributeSet.getAttribute(object));
                    continue;
                }
                if (object instanceof HTML.Tag || object instanceof StyleConstants || object instanceof TemporaryStyle.Attribute || object == HTML.Attribute.STYLE || "CR".equals(object) || "/".equals(object)) continue;
                Object object6 = attributeSet.getAttribute(object);
                if (object == HTML.Attribute.SRC && this.imageReplaceMap != null && (string = this.imageReplaceMap.get(object6.toString())) != null) {
                    object6 = string;
                }
                this.writeAttribute(object, object6);
            }
        }
        if (stringBuilder.length() > 0) {
            this.writeAttribute("style", stringBuilder);
        }
        if (attributeSet.getAttribute("/") == Boolean.TRUE) {
            this.write('/');
        }
    }

    private void writeStyleAttribute(StringBuilder stringBuilder, CSS.Attribute attribute, Object object) {
        stringBuilder.append((Object)attribute);
        stringBuilder.append(':');
        String string = object != null ? object.toString() : null;
        stringBuilder.append(string != null ? string.replace('\"', ' ').replace('\'', ' ') : "none");
        stringBuilder.append(';');
    }

    private void writeAttribute(Object object, Object object2) throws IOException {
        if (this.inlineMode && object == HTML.Attribute.CLASS) {
            return;
        }
        this.write(' ');
        this.write(object.toString());
        if (object2 instanceof EmptyValue) {
            return;
        }
        if (object2 instanceof AttributeValue && !((AttributeValue)object2).isWriteValue()) {
            return;
        }
        this.write("=\"");
        this.needEncoding = true;
        this.write(object2.toString());
        this.needEncoding = false;
        this.write('\"');
    }

    private void addFormatLine() throws IOException {
        if (this.getIndentSpace() > 0) {
            this.writeLineSeparator();
            this.indent();
        }
        this.wasSpace = true;
    }

    private void writeHead(Element element) throws IOException {
        Element element2;
        int n2;
        this.wasHead = true;
        this.addFormatLine();
        this.write("<head>");
        this.incrIndent();
        this.addFormatLine();
        Element element3 = null;
        Element element4 = this.getDocument().getDefaultRootElement();
        for (n2 = 0; n2 < element4.getElementCount(); ++n2) {
            element2 = element4.getElement(n2);
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HEAD) continue;
            element3 = element2;
            break;
        }
        if (element3 != null) {
            for (n2 = 0; n2 < element3.getElementCount(); ++n2) {
                element2 = element3.getElement(n2);
                try {
                    Object object = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object == HTML.Tag.STYLE || object == HTML.Tag.CONTENT) continue;
                    this.writeNode(element2);
                    this.addFormatLine();
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this.writeTitle();
        if (!this.inlineMode) {
            this.writeStyles();
        }
        this.decrIndent();
        this.addFormatLine();
        this.write("</head>");
    }

    private void writeTitle() throws IOException {
        Object object = this.document.getProperty("title");
        if (object != null && object.toString().length() > 0) {
            this.write("<title>");
            this.incrIndent();
            this.addFormatLine();
            this.needEncoding = true;
            this.write(object.toString());
            this.needEncoding = false;
            this.decrIndent();
            this.addFormatLine();
            this.write("</title>");
            this.addFormatLine();
        }
    }

    private void writeStyles() throws IOException {
        InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.getDocument();
        Styles styles = inetHtmlDocument.getStyleResolver().getStyles();
        int n2 = styles.getRuleCount();
        if (n2 == 0) {
            return;
        }
        for (Object object : styles.getSourceIdentifiers()) {
            if (!styles.isExternal(object)) continue;
            this.addFormatLine();
            this.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            this.write(object.toString());
            this.write("\">");
        }
        this.addFormatLine();
        this.write("<style>");
        this.incrIndent();
        for (Object object : styles.getSourceIdentifiers()) {
            List<Styles.StyleSheetEntry> list;
            if (styles.isExternal(object) || (list = styles.getEntries(object)) == null || list.size() == 0) continue;
            for (Styles.StyleSheetEntry styleSheetEntry : list) {
                this.addFormatLine();
                this.write(styleSheetEntry.getSelector());
                this.write('{');
                AttributeSet attributeSet = styleSheetEntry.getAttributess();
                Enumeration<Object> enumeration = attributeSet.getAttributeNames();
                if (sortAttributes) {
                    enumeration = this.getSortedEnumeration(enumeration);
                }
                while (enumeration.hasMoreElements()) {
                    Object object2 = enumeration.nextElement();
                    if (!(object2 instanceof CSS.Attribute)) continue;
                    this.write(object2.toString());
                    this.write(':');
                    Object object3 = attributeSet.getAttribute(object2);
                    this.write(object3.toString());
                    if (object3 instanceof AttributeValue && ((AttributeValue)object3).isImportant()) {
                        this.write(" !important");
                    }
                    this.write(';');
                }
                this.write('}');
            }
        }
        this.decrIndent();
        this.addFormatLine();
        this.write("</style>");
    }

    private Enumeration<? extends Object> getSortedEnumeration(Enumeration<?> enumeration) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = object2.toString();
            while (hashMap.containsKey(object)) {
                object = (String)object + "_";
            }
            hashMap.put((String)object, object2);
        }
        object2 = new TreeSet(hashMap.keySet());
        object = new Vector(hashMap.size());
        Iterator iterator = ((TreeSet)object2).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ((Vector)object).add(hashMap.get(string));
        }
        return ((Vector)object).elements();
    }

    @Override
    protected void output(char[] cArray, int n2, int n3) throws IOException {
        if (!this.needEncoding) {
            super.output(cArray, n2, n3);
            return;
        }
        Writer writer = this.getWriter();
        int n4 = n2;
        int n5 = n3 + n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            String string = null;
            char c2 = cArray[i2];
            switch (c2) {
                case '<': {
                    string = "&lt;";
                    break;
                }
                case '>': {
                    string = "&gt;";
                    break;
                }
                case '&': {
                    string = "&amp;";
                    break;
                }
                case '\"': {
                    string = "&quot;";
                    break;
                }
                case '\u00a0': {
                    string = "&nbsp;";
                    break;
                }
                case ' ': {
                    if (!this.needSpacesEncoding || !this.wasSpace) break;
                    string = "&nbsp;";
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (c2 >= ' ' && c2 <= '\u007f') break;
                    if (i2 > n4) {
                        super.output(cArray, n4, i2 - n4);
                    }
                    n4 = i2 + 1;
                    writer.write("&#");
                    writer.write(String.valueOf((int)c2));
                    writer.write(59);
                }
            }
            if (string != null) {
                if (i2 > n4) {
                    super.output(cArray, n4, i2 - n4);
                }
                n4 = i2 + 1;
                writer.write(string);
            }
            if (!this.needSpacesEncoding) continue;
            this.wasSpace = c2 == ' ';
        }
        if (n4 < n5) {
            super.output(cArray, n4, n5 - n4);
        }
    }

    public void registerImageSRCreplace(Map<String, String> map) {
        this.imageReplaceMap = map;
    }

    private boolean isPreformatted(Element element) {
        WhiteSpace whiteSpace = StyleResolver.getAttributeValue(element, AttributeFinder.WHITE_SPACE);
        switch (whiteSpace.getValue()) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public static void setSorted(boolean bl2) {
        sortAttributes = bl2;
    }

    public void setInlineMode(boolean bl2) {
        this.inlineMode = bl2;
    }

    public void setAllowStyleSpan(boolean bl2) {
        this.allowStyleSpan = bl2;
        this.writeStyleSpanAfterBody &= bl2;
    }

    public Map<HTML.Tag, Boolean> getTagWritingOptions() {
        return this.tagWritingOptionsMap;
    }

    public void setTagWritingOptions(Map<HTML.Tag, Boolean> map) {
        this.tagWritingOptionsMap = map;
    }

    static {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("sortAttributes"))) {
                sortAttributes = true;
            }
        }
        catch (SecurityException securityException) {
            sortAttributes = false;
        }
    }
}

