/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.actions.InetHtmlAction;
import com.inet.html.views.HtmlRootView;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class BeginEndLineAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private final boolean select;
    private final boolean begin;

    public BeginEndLineAction(String string, boolean bl2, boolean bl3) {
        super(string);
        this.begin = bl2;
        this.select = bl3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JEditorPane jEditorPane = this.getHtmlEditor(actionEvent);
        if (jEditorPane != null) {
            try {
                int n2 = jEditorPane.getCaretPosition();
                n2 = BeginEndLineAction.getRowBeginEnd(jEditorPane, n2, this.begin);
                if (this.select) {
                    jEditorPane.moveCaretPosition(n2);
                } else {
                    jEditorPane.setCaretPosition(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jEditorPane);
            }
        }
    }

    public static int getRowBeginEnd(JTextComponent jTextComponent, int n2, boolean bl2) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n2);
        if (rectangle == null) {
            return -1;
        }
        int n3 = jTextComponent.getDocument().getLength();
        int n4 = rectangle.y;
        int n5 = n4 + rectangle.height;
        do {
            n2 = bl2 ? --n2 : ++n2;
            Rectangle rectangle2 = rectangle = n2 <= n3 && n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        } while (rectangle != null && n5 > rectangle.y && n4 < rectangle.y + rectangle.height || rectangle == null && n2 <= n3 && n2 >= 0);
        return n2 + (bl2 ? 1 : -1);
    }

    public static Rectangle modelToView(JTextComponent jTextComponent, int n2) throws BadLocationException {
        try {
            HtmlRootView htmlRootView = (HtmlRootView)jTextComponent.getUI().getRootView(jTextComponent).getView(0);
            Insets insets = jTextComponent.getMargin();
            Rectangle rectangle = insets == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rectangle(insets.left, insets.top, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return (Rectangle)htmlRootView.nativeModelToView(n2, rectangle, Position.Bias.Forward);
        }
        catch (Exception exception) {
            return jTextComponent.modelToView(n2);
        }
    }
}

