/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.editor.BaseEditor;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.actions.InetHtmlAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class EnterAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private final Action defaultAction;
    private JEditorPane editor;

    public EnterAction(Action action) {
        super("insert-break");
        this.defaultAction = action;
    }

    public EnterAction() {
        super("insert-break");
        this.defaultAction = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.editor = this.getHtmlEditor(actionEvent);
        if (this.editor != null) {
            Document document;
            if (!this.editor.isEditable()) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
                return;
            }
            int n2 = this.editor.getSelectionStart();
            int n3 = this.editor.getSelectionEnd() - n2;
            if (n3 > 0) {
                this.editor.replaceSelection("");
            }
            if ((document = this.editor.getDocument()) instanceof InetHtmlDocument) {
                InetHtmlEditorKit inetHtmlEditorKit = (InetHtmlEditorKit)this.editor.getEditorKit();
                MutableAttributeSet mutableAttributeSet = inetHtmlEditorKit.getInputAttributes();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(mutableAttributeSet);
                ((InetHtmlDocument)document).performParagraphBreak(n2);
                mutableAttributeSet.addAttributes(simpleAttributeSet);
                CaretListener[] caretListenerArray = this.editor.getCaretListeners();
                if (caretListenerArray != null) {
                    BaseEditor.SimpleCaretEvent simpleCaretEvent = new BaseEditor.SimpleCaretEvent(this.editor, this.editor.getSelectionStart(), this.editor.getSelectionEnd());
                    for (CaretListener caretListener : caretListenerArray) {
                        caretListener.caretUpdate(simpleCaretEvent);
                    }
                }
                return;
            }
        }
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(actionEvent);
        }
    }
}

