/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.editor.BaseEditor;
import com.inet.html.utils.Logger;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;

public abstract class InetHtmlAction
extends StyledEditorKit.StyledTextAction {
    private static final long serialVersionUID = 1L;

    public InetHtmlAction(String string) {
        super(string);
    }

    protected JEditorPane getHtmlEditor(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JEditorPane) {
            return (JEditorPane)object;
        }
        if (object instanceof Container) {
            Container container;
            for (container = (Container)object; container != null && !(container instanceof BaseEditor); container = container.getParent()) {
            }
            if (container != null && container instanceof BaseEditor) {
                return ((BaseEditor)container).getEditor();
            }
            if (container == null) {
                container = (Container)object;
                while (container != null && !(container instanceof BaseEditor)) {
                    if (container instanceof JPopupMenu) {
                        container = (Container)((JPopupMenu)container).getInvoker();
                        continue;
                    }
                    container = container.getParent();
                }
                if (container != null && container instanceof BaseEditor) {
                    return ((BaseEditor)container).getEditor();
                }
            }
        }
        return super.getEditor(actionEvent);
    }

    static String getTranslation(String string) {
        block2: {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.inet.html.i18n.Resources");
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (!Logger.doesLog(2)) break block2;
                Logger.warning("No lokalization for: " + string + " = " + string);
            }
        }
        return string;
    }

    void updateCaretListeners(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return;
        }
        CaretListener[] caretListenerArray = jTextComponent.getCaretListeners();
        if (caretListenerArray != null) {
            for (CaretListener caretListener : caretListenerArray) {
                caretListener.caretUpdate(new UpdateCaretEvent(jTextComponent));
            }
        }
    }

    private class UpdateCaretEvent
    extends CaretEvent {
        private static final long serialVersionUID = -563389637932878887L;
        private int dot;
        private int mark;

        public UpdateCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
            this.dot = -1;
            this.mark = -1;
            if (jTextComponent != null) {
                this.dot = jTextComponent.getCaret().getDot();
                this.mark = jTextComponent.getCaret().getMark();
            }
        }

        public int getDot() {
            return this.dot;
        }

        public int getMark() {
            return this.mark;
        }
    }
}

