/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.actions.search.ISearchDialog;
import com.inet.html.actions.search.SearchControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultSearchDialog
implements ISearchDialog,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField text;
    private JRadioButton forward;
    private JRadioButton backward;
    private JCheckBox caseSensitive;
    private JButton search;
    private JButton close;
    private JLabel status;
    private static String lastSearch = "";
    private static boolean lastCS = false;
    private static boolean lastForward = true;
    private Point lastPosition = null;
    private SearchControl control;
    private JDialog dialog;
    private final JEditorPane editor;

    public DefaultSearchDialog(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
    }

    private void initGui() {
        if (this.dialog != null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this.editor);
        this.dialog = window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog((Frame)window);
        this.dialog.setDefaultCloseOperation(2);
        Container container = this.dialog.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        String string = HtmlEditorUtils.getTranslation("search.title");
        this.dialog.setTitle(string);
        Insets insets = new Insets(2, 2, 2, 2);
        this.text = new JTextField(lastSearch, 20);
        JLabel jLabel = new JLabel(string + ":");
        jLabel.setLabelFor(this.text);
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 8, 3, 2), 0, 0));
        container.add((Component)this.text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 2), 0, 0));
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DefaultSearchDialog.this.fireSearchTextChanged();
            }
        });
        this.text.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.forward = new JRadioButton(HtmlEditorUtils.getTranslation("search.forward"));
        this.forward.setSelected(lastForward);
        container.add((Component)this.forward, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        buttonGroup.add(this.forward);
        this.backward = new JRadioButton(HtmlEditorUtils.getTranslation("search.backward"));
        container.add((Component)this.backward, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        buttonGroup.add(this.backward);
        this.caseSensitive = new JCheckBox(HtmlEditorUtils.getTranslation("search.caseSensitive"));
        container.add((Component)this.caseSensitive, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.caseSensitive.addActionListener(this);
        this.caseSensitive.setSelected(lastCS);
        this.search = new JButton(HtmlEditorUtils.getTranslation("search.next"));
        this.dialog.getRootPane().setDefaultButton(this.search);
        this.search.addActionListener(this);
        this.close = new JButton(HtmlEditorUtils.getTranslation("search.close"));
        this.close.addActionListener(this);
        this.dialog.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.search);
        jPanel.add(this.close);
        Color color = new Color(jPanel.getBackground().getRGB());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color.brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, color.darker())));
        container.add((Component)jPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.status = new JLabel(" ");
        container.add((Component)this.status, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        this.dialog.pack();
        this.dialog.setMinimumSize(this.dialog.getSize());
        this.dialog.setPreferredSize(this.dialog.getSize());
        if (this.lastPosition == null) {
            Dimension dimension = this.dialog.getSize();
            Rectangle rectangle = window.getBounds();
            this.lastPosition = new Point(rectangle.x + rectangle.width / 2 - dimension.width / 2, rectangle.y + rectangle.height / 2 - dimension.height / 2);
        }
        this.dialog.setLocation(this.lastPosition);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (DefaultSearchDialog.this.dialog != null) {
                    DefaultSearchDialog.this.close();
                }
            }
        });
    }

    public int getPatternType() {
        return 1;
    }

    public String getSearchString() {
        return this.text != null ? this.text.getText() : lastSearch;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive != null ? this.caseSensitive.isSelected() : lastCS;
    }

    public boolean isForward() {
        return this.forward != null ? this.forward.isSelected() : lastForward;
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void requestShow(boolean bl2) {
        this.initGui();
        if (bl2) {
            this.clear();
        }
        this.dialog.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultSearchDialog.this.text.requestFocus();
                int n2 = DefaultSearchDialog.this.text.getText().length();
                if (n2 > 0) {
                    DefaultSearchDialog.this.fireSearchTextChanged();
                    DefaultSearchDialog.this.text.setSelectionStart(0);
                    DefaultSearchDialog.this.text.setSelectionEnd(n2);
                }
            }
        });
    }

    public void setController(SearchControl searchControl) {
        this.control = searchControl;
    }

    private void fireSearchTextChanged() {
        if (this.isForward()) {
            this.editor.setSelectionEnd(this.editor.getSelectionStart());
        } else {
            this.editor.setSelectionStart(this.editor.getSelectionEnd());
        }
        this.control.doSearch(this.isForward(), false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ((object == this.close || object == this.dialog.getRootPane()) && this.dialog != null) {
            this.close();
        } else if (object == this.caseSensitive) {
            this.control.doSearch(this.isForward(), false);
        }
        if (object == this.search || object == this.text) {
            this.control.doSearch(this.isForward(), true);
        }
    }

    public void notifyMatches(int n2) {
        if (this.text == null) {
            return;
        }
        if (this.text.getText().length() == 0) {
            this.status.setText("");
        } else if (n2 > 0) {
            this.status.setText(HtmlEditorUtils.getTranslation("search.matches") + ": " + n2);
        } else {
            this.status.setText(HtmlEditorUtils.getTranslation("search.noMatches"));
        }
    }

    public void clear() {
        if (this.text != null) {
            this.text.setText("");
            this.status.setText("");
            this.forward.setSelected(true);
        }
    }

    public void close() {
        lastSearch = this.getSearchString();
        lastForward = this.isForward();
        lastCS = this.isCaseSensitive();
        this.dialog.setVisible(false);
        this.dialog = null;
        this.text = null;
        this.backward = null;
        this.caseSensitive = null;
        this.close = null;
        this.forward = null;
        this.search = null;
        this.status = null;
    }
}

