/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.search.ISearchHighlighter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchHighlighter
implements ISearchHighlighter {
    private static final DefaultHighlighter.DefaultHighlightPainter PAINTER = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 255, 0, 127));
    private final JEditorPane editor;

    public DefaultSearchHighlighter(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
    }

    @Override
    public int doHighlight(Pattern pattern, boolean bl2, boolean bl3) {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        try {
            String string = this.editor.getDocument().getText(0, this.editor.getDocument().getLength());
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                int n2;
                int n3 = matcher.start();
                if (n3 >= (n2 = matcher.end())) continue;
                boolean bl4 = Character.isLetterOrDigit(string.charAt(n3));
                boolean bl5 = Character.isLetterOrDigit(string.charAt(n2 - 1));
                arrayList.add(new Dimension(bl4 ? n3 : n3 + 1, bl5 ? n2 : n2 - 1));
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return 0;
        }
        this.markHighlights(arrayList);
        if (arrayList.size() > 0 && bl3) {
            this.markCurrent(arrayList, bl2);
        }
        return arrayList.size();
    }

    private void markHighlights(List<Dimension> list) {
        this.clearHighlights();
        Highlighter highlighter = this.editor.getHighlighter();
        for (Dimension dimension : list) {
            try {
                highlighter.addHighlight(dimension.width, dimension.height, PAINTER);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private static Dimension findPosition(List<Dimension> list, int n2, boolean bl2) {
        int n3;
        if (list.size() == 1) {
            return list.get(0);
        }
        if (bl2) {
            for (Dimension dimension : list) {
                if (dimension.width < n2) continue;
                return dimension;
            }
            return list.get(0);
        }
        for (int i2 = n3 = list.size() - 1; i2 >= 0; --i2) {
            Dimension dimension = list.get(i2);
            if (dimension.height > n2) continue;
            return dimension;
        }
        return list.get(n3);
    }

    private void markCurrent(List<Dimension> list, boolean bl2) {
        Caret caret = this.editor.getCaret();
        int n2 = bl2 ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        this.editor.setCaretPosition(n2);
        final Dimension dimension = DefaultSearchHighlighter.findPosition(list, n2, bl2);
        FocusListener[] focusListenerArray = this.editor.getFocusListeners();
        FocusEvent focusEvent = new FocusEvent(this.editor, 1004, true);
        for (FocusListener focusListener : focusListenerArray) {
            focusListener.focusGained(focusEvent);
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultSearchHighlighter.this.editor.select(dimension.width, dimension.height);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Caret caret = DefaultSearchHighlighter.this.editor.getCaret();
                        if (caret != null) {
                            caret.setSelectionVisible(true);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void clearHighlights() {
        Highlighter.Highlight[] highlightArray = this.editor.getHighlighter().getHighlights();
        if (highlightArray != null && highlightArray.length > 0) {
            for (Highlighter.Highlight highlight : highlightArray) {
                if (highlight.getPainter() != PAINTER) continue;
                this.editor.getHighlighter().removeHighlight(highlight);
            }
        }
    }
}

