/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.InetHtmlAction;
import com.inet.html.actions.search.SearchControl;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;

public class SearchAction
extends InetHtmlAction {
    private final boolean init;
    private final boolean forward;

    public SearchAction(boolean bl2, boolean bl3) {
        super("search-" + (bl2 ? "init" : (bl3 ? "next" : "previous")));
        this.init = bl2;
        this.forward = bl3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final JEditorPane jEditorPane = this.getEditor(actionEvent);
        if (jEditorPane == null) {
            return;
        }
        Object object = jEditorPane.getClientProperty("searchController");
        if (object instanceof SearchControl) {
            final SearchControl searchControl = (SearchControl)object;
            if (this.init) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Point point = jEditorPane.getLocationOnScreen();
                        Rectangle rectangle = jEditorPane.getVisibleRect();
                        Point point2 = rectangle.getLocation();
                        rectangle = new Rectangle(point, rectangle.getSize());
                        rectangle.translate(point2.x, point2.y);
                        searchControl.requestSearch(false, rectangle);
                    }
                });
            } else {
                searchControl.doSearch(this.forward, true);
            }
        }
    }
}

