/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.search.ISearchDialog;
import com.inet.html.actions.search.ISearchHighlighter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.regex.Pattern;

public class SearchControl {
    public static final String CLIENT_PROPERTY_SEARCH_CONTROLLER = "searchController";
    private final ISearchDialog dialog;
    private final ISearchHighlighter highlighter;

    public SearchControl(ISearchDialog iSearchDialog, ISearchHighlighter iSearchHighlighter) {
        this.dialog = iSearchDialog;
        iSearchDialog.setController(this);
        this.highlighter = iSearchHighlighter;
    }

    public void requestSearch(boolean bl2, Rectangle rectangle) {
        this.dialog.requestShow(bl2);
        if (this.dialog instanceof Component) {
            Window window = (Window)((Object)this.dialog);
            Point point = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
            Dimension dimension = window.getSize();
            window.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
        }
    }

    public void doSearch(boolean bl2, boolean bl3) {
        String string = this.dialog.getSearchString();
        boolean bl4 = this.dialog.isCaseSensitive();
        int n2 = this.dialog.getPatternType();
        Pattern pattern = this.compilePattern(string, bl4, n2);
        int n3 = this.highlighter.doHighlight(pattern, bl2, bl3);
        this.dialog.notifyMatches(n3);
    }

    public void clearSearch() {
        this.highlighter.clearHighlights();
        this.dialog.clear();
    }

    private Pattern compilePattern(String string, boolean bl2, int n2) {
        if (string == null) {
            return Pattern.compile("");
        }
        int n3 = bl2 ? 0 : 66;
        switch (n2) {
            case 0: {
                string = string.replaceAll("(\\[|\\]|\\.|\\(|\\)|\\?|\\*|\\+|\\{|\\}|\\^|\\$|\\|)", "\\$1");
                string = string.replaceAll("\\\\", "\\\\");
                break;
            }
            case 1: {
                string = string.replaceAll("(\\[|\\]|\\.|\\(|\\)|\\+|\\{|\\}|\\^|\\$|\\|)", "\\$1");
                string = string.replaceAll("\\\\", "\\\\");
                string = string.replaceAll("\\?", ".");
                string = string.replaceAll("\\*", ".*?");
                if (!string.endsWith(".*?")) break;
                string = string + "\\s";
            }
        }
        return Pattern.compile(string, n3);
    }
}

