/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.TextDecoration;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

public class CSS {
    private static final Hashtable<String, Attribute> ATTRIBUTE_MAP = new Hashtable();

    public static final Attribute getAttribute(String string) {
        return ATTRIBUTE_MAP.get(string);
    }

    public static void setTextColor(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute((Object)Attribute.COLOR, new ColorValue(color));
    }

    public static void setFontSizePT(MutableAttributeSet mutableAttributeSet, int n2) {
        FontSize fontSize = new FontSize(n2, true);
        mutableAttributeSet.addAttribute((Object)Attribute.FONT_SIZE, fontSize);
    }

    public static void setFontSize(MutableAttributeSet mutableAttributeSet, int n2) {
        FontSize fontSize = new FontSize(n2, false);
        mutableAttributeSet.addAttribute((Object)Attribute.FONT_SIZE, fontSize);
    }

    public static void setFontWeight(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        FontWeight fontWeight = new FontWeight(bl2);
        mutableAttributeSet.addAttribute((Object)Attribute.FONT_WEIGHT, fontWeight);
    }

    public static void setFontStyle(MutableAttributeSet mutableAttributeSet, boolean bl2) {
        FontStyle fontStyle = new FontStyle(bl2);
        mutableAttributeSet.addAttribute((Object)Attribute.FONT_STYLE, fontStyle);
    }

    public static void setTextDecoration(MutableAttributeSet mutableAttributeSet, int n2) {
        TextDecoration textDecoration = new TextDecoration(n2);
        mutableAttributeSet.addAttribute((Object)Attribute.TEXT_DECORATION, textDecoration);
    }

    public static void setFontFamily(MutableAttributeSet mutableAttributeSet, String string) {
        FontFamily fontFamily = new FontFamily(string);
        mutableAttributeSet.addAttribute((Object)Attribute.FONT_FAMILY, fontFamily);
    }

    public static boolean isBold(Element element) {
        FontWeight fontWeight = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_WEIGHT);
        return fontWeight != null && fontWeight.isBold();
    }

    public static boolean isItalic(Element element) {
        FontStyle fontStyle = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_STYLE);
        return fontStyle != null && fontStyle.isItalic();
    }

    public static boolean isUnderline(Element element) {
        TextDecoration textDecoration = StyleResolver.getAttributeValue(element, AttributeFinder.TEXT_DECORATION);
        return textDecoration != null && textDecoration.getDecoration() == 1;
    }

    public static void setMarginLeft(MutableAttributeSet mutableAttributeSet, int n2) {
        LengthUnit lengthUnit = new LengthUnit(n2 + "px");
        mutableAttributeSet.addAttribute((Object)Attribute.MARGIN_LEFT, lengthUnit);
    }

    static {
        for (Attribute attribute : Attribute.values()) {
            ATTRIBUTE_MAP.put(attribute.toString(), attribute);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        BACKGROUND("background"),
        BACKGROUND_ATTACHMENT("background-attachment"),
        BACKGROUND_COLOR("background-color"),
        BACKGROUND_IMAGE("background-image"),
        BACKGROUND_POSITION("background-position"),
        BACKGROUND_REPEAT("background-repeat"),
        BORDER("border"),
        BORDER_BOTTOM("border-bottom"),
        BORDER_BOTTOM_COLOR("border-bottom-color"),
        BORDER_BOTTOM_STYLE("border-bottom-style"),
        BORDER_BOTTOM_WIDTH("border-bottom-width"),
        BORDER_COLLAPSE("border-collapse"),
        BORDER_COLOR("border-color"),
        BORDER_LEFT("border-left"),
        BORDER_LEFT_COLOR("border-left-color"),
        BORDER_LEFT_STYLE("border-left-style"),
        BORDER_LEFT_WIDTH("border-left-width"),
        BORDER_RIGHT("border-right"),
        BORDER_RIGHT_COLOR("border-right-color"),
        BORDER_RIGHT_STYLE("border-right-style"),
        BORDER_RIGHT_WIDTH("border-right-width"),
        BORDER_SPACING("border-spacing"),
        BORDER_STYLE("border-style"),
        BORDER_TOP("border-top"),
        BORDER_TOP_COLOR("border-top-color"),
        BORDER_TOP_STYLE("border-top-style"),
        BORDER_TOP_WIDTH("border-top-width"),
        BORDER_WIDTH("border-width"),
        BOTTOM("bottom"),
        CLEAR("clear"),
        CONTENT("content"),
        COLOR("color"),
        DISPLAY("display"),
        DIRECTION("direction"),
        FLOAT("float"),
        FONT("font"),
        FONT_FAMILY("font-family"),
        FONT_SIZE("font-size"),
        FONT_STYLE("font-style"),
        FONT_VARIANT("font-variant"),
        FONT_WEIGHT("font-weight"),
        HEIGHT("height"),
        LEFT("left"),
        LETTER_SPACING("letter-spacing"),
        LINE_HEIGHT("line-height"),
        LIST_STYLE("list-style"),
        LIST_STYLE_IMAGE("list-style-image"),
        LIST_STYLE_POSITION("list-style-position"),
        LIST_STYLE_TYPE("list-style-type"),
        MARGIN("margin"),
        MARGIN_BOTTOM("margin-bottom"),
        MARGIN_LEFT("margin-left"),
        MARGIN_RIGHT("margin-right"),
        MARGIN_TOP("margin-top"),
        MAX_HEIGHT("max-height"),
        MAX_WIDTH("max-width"),
        MIN_HEIGHT("min-height"),
        MIN_WIDTH("min-width"),
        OUTLINE("outline"),
        OVERFLOW("overflow"),
        PADDING("padding"),
        PADDING_BOTTOM("padding-bottom"),
        PADDING_LEFT("padding-left"),
        PADDING_RIGHT("padding-right"),
        PADDING_TOP("padding-top"),
        POSITION("position"),
        RIGHT("right"),
        SPAN("span"),
        TEXT_ALIGN("text-align"),
        TEXT_DECORATION("text-decoration"),
        TEXT_INDENT("text-indent"),
        TEXT_TRANSFORM("text-transform"),
        TOP("top"),
        VERTICAL_ALIGN("vertical-align"),
        VISIBILITY("visibility"),
        WORD_SPACING("word-spacing"),
        WHITE_SPACE("white-space"),
        WIDTH("width"),
        UNICODEBIDI("unicode-bidi"),
        ZINDEX("z-index");

        private final String name;

        private Attribute(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

