/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIDGenerator {
    public static final String WEBENGINE_PREFIX = "jwe-style";
    public static final Pattern WEBENGINE_PREFIX_PATTERN = Pattern.compile(".*jwe-style(\\d+).*");
    private Set<Integer> knownIDs;

    public void register(String string) {
        Matcher matcher = WEBENGINE_PREFIX_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                this.getIDs().add(Integer.valueOf(matcher.group(1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void register(int n2) {
        this.getIDs().add(n2);
    }

    public void generateID(ClassID classID) {
        if (this.knownIDs == null) {
            this.knownIDs = new TreeSet<Integer>();
        }
        Integer n2 = null;
        while (this.knownIDs.contains(n2 = Integer.valueOf((int)(Math.random() * 9999999.0)))) {
        }
        this.knownIDs.add(n2);
        classID.setId(n2);
    }

    public ClassID getClassID(boolean bl2) {
        ClassID classID = new ClassID();
        if (bl2) {
            this.generateID(classID);
        }
        return classID;
    }

    private Set<Integer> getIDs() {
        if (this.knownIDs == null) {
            this.knownIDs = new TreeSet<Integer>();
        }
        return this.knownIDs;
    }

    public class ClassID {
        private Integer id;

        public void setId(Integer n2) {
            this.id = n2;
        }

        public String toString() {
            if (this.id == null) {
                ClassIDGenerator.this.generateID(this);
            }
            return ClassIDGenerator.WEBENGINE_PREFIX + this.id;
        }
    }
}

