/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
implements Comparable<Selector> {
    public static final Comparator COMPARATOR = new Comparator();
    private List<Tag> tagList;
    private int levelTag;
    private int levelClass;
    private int levelID;
    private int levelTotal;
    private int index;
    private AttributeSet rule;
    private boolean isAbsolutByTag = false;
    private boolean isAbsolutByElement = false;

    public Selector(String string, AttributeSet attributeSet, int n2) {
        List<String> list = this.splitSelector(string);
        if (list == null) {
            return;
        }
        this.index = n2;
        this.rule = attributeSet;
        this.tagList = new ArrayList<Tag>();
        for (String string2 : list) {
            Tag tag = new Tag(string2);
            this.tagList.add(tag);
            this.levelTag += tag.getLevelCount(1);
            this.levelClass += tag.getLevelCount(2);
            this.levelID += tag.getLevelCount(3);
        }
        Collections.reverse(this.tagList);
        if (this.tagList.size() == 1) {
            this.isAbsolutByElement = true;
            if (this.tagList.get(0).isTagOnly) {
                this.isAbsolutByTag = true;
            }
        }
        this.levelTotal = this.levelID * 65536 + this.levelClass * 256 + this.levelTag;
    }

    private List<String> splitSelector(String string) {
        if (string == null) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl6 && c2 != ' ') {
                bl6 = false;
            }
            if (!(bl2 || bl3 || bl6 || c2 != ' ' && c2 != '+' && c2 != '>' || stringBuffer.length() <= 0)) {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                bl4 = false;
                bl5 = false;
                if (c2 != '+' && c2 != '>') continue;
            }
            if (bl3 || c2 != ' ') {
                bl6 = stringBuffer.length() == 0 && (c2 == '>' || c2 == '+');
                stringBuffer.append(c2);
            }
            if (c2 == '\"') {
                if (bl5) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + string + "' at position " + i2);
                }
                if (!bl3) {
                    bl3 = true;
                } else {
                    bl3 = false;
                    bl5 = true;
                }
            }
            if (c2 == '[') {
                if (bl4 || bl2) {
                    throw new IllegalArgumentException("Syntax Error in Selector '" + string + "' at position " + i2);
                }
                bl2 = true;
            }
            if (c2 != ']') continue;
            if (bl4 || !bl2) {
                throw new IllegalArgumentException("Syntax Error in Selector '" + string + "' at position " + i2);
            }
            bl2 = false;
            bl4 = true;
        }
        if (bl2) {
            throw new IllegalArgumentException("Syntax Error in Selector '" + string + "', missing closing bracket.");
        }
        if (bl3) {
            throw new IllegalArgumentException("Syntax Error in Selector '" + string + "', missing closing quote.");
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public int getLevelTotal() {
        return this.levelTotal;
    }

    public int getIndex() {
        return this.index;
    }

    public HTML.Tag getMatchedTag() {
        if (this.isAbsolutByTag) {
            return this.tagList.get(0).getMatchedTag();
        }
        return null;
    }

    public boolean isUnversalTagOnly() {
        if (this.isAbsolutByTag) {
            return this.tagList.get(0).isUnversalTagOnly();
        }
        return false;
    }

    public boolean matches(Element element) {
        int n2 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.tagList.size() == 0) {
            return true;
        }
        Tag tag = this.tagList.get(n2++);
        for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
            if (bl3) {
                bl3 = false;
                continue;
            }
            if (tag.matches(element2)) {
                bl2 = false;
                if (n2 == this.tagList.size()) {
                    return true;
                }
                if (tag.modifier == 1) {
                    bl2 = true;
                }
                if (tag.modifier == 2) {
                    Element element3 = element2.getParentElement();
                    if (element3 == null || !(element3 instanceof AbstractDocument.BranchElement)) {
                        return false;
                    }
                    while (tag.modifier == 2) {
                        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element3;
                        if (branchElement.getChildCount() <= 1) {
                            return false;
                        }
                        TreeNode treeNode = null;
                        Enumeration<TreeNode> enumeration = branchElement.children();
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            TreeNode treeNode2 = enumeration.nextElement();
                            if (treeNode2 == element2) {
                                if (treeNode == null || !(treeNode instanceof Element)) {
                                    return false;
                                }
                                if (!(tag = this.tagList.get(n2++)).matches((Element)((Object)treeNode))) {
                                    return false;
                                }
                                element2 = (Element)((Object)treeNode);
                                bl3 = true;
                                if (n2 == this.tagList.size()) {
                                    return tag.modifier != 2;
                                }
                            }
                            treeNode = treeNode2;
                        }
                    }
                }
                if (n2 == this.tagList.size()) {
                    return true;
                }
                tag = this.tagList.get(n2++);
                continue;
            }
            if (!bl2) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        arrayList.addAll(this.tagList);
        Collections.reverse(arrayList);
        return ((Object)arrayList).toString();
    }

    public String toExternal() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        arrayList.addAll(this.tagList);
        Collections.reverse(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (Tag tag : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(tag.toString());
        }
        return stringBuilder.toString();
    }

    public AttributeSet getRule() {
        return this.rule;
    }

    public boolean isAbsolutByElement() {
        return this.isAbsolutByElement;
    }

    public boolean isAbsolutByTag() {
        return this.isAbsolutByTag;
    }

    @Override
    public int compareTo(Selector selector) {
        return COMPARATOR.compare(this, selector);
    }

    public void setSourceClass(Object object) {
        if (object == null || this.tagList.size() == 0) {
            return;
        }
        Tag tag = this.tagList.get(0);
        if (tag.classNames == null) {
            tag.classNames = new ArrayList();
            tag.classNames.add(object);
        } else {
            tag.classNames.add(0, object);
        }
        tag.isTagOnly = false;
        this.isAbsolutByTag = false;
    }

    public HTML.Tag getPrimaryTag() {
        if (this.tagList.size() > 0) {
            Object object = this.tagList.get(0).tagName;
            return object instanceof HTML.Tag ? (HTML.Tag)((Object)object) : null;
        }
        return null;
    }

    boolean hasJWEclass() {
        if (this.tagList != null && this.tagList.size() > 0) {
            Tag tag = this.tagList.get(0);
            if (tag.classNames == null || tag.classNames.size() == 0) {
                return false;
            }
            for (Object e2 : tag.classNames) {
                String string;
                if (!(e2 instanceof String) || !(string = (String)e2).startsWith("jwe-style") || !ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(string).matches()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comparator
    implements java.util.Comparator<Selector> {
        private Comparator() {
        }

        @Override
        public int compare(Selector selector, Selector selector2) {
            int n2;
            if (selector == null && selector2 == null) {
                return 0;
            }
            if (selector == null) {
                return 1;
            }
            if (selector2 == null) {
                return -1;
            }
            int n3 = selector.getLevelTotal();
            if (n3 != (n2 = selector2.getLevelTotal())) {
                return n2 - n3;
            }
            return selector2.getIndex() - selector.getIndex();
        }
    }

    private class Tag {
        private int modifier;
        private Object tagName;
        private String pseudoClass;
        private Object id;
        private Object attrib;
        private String attribValue;
        private int eqType;
        private List<Object> classNames;
        private boolean isUniversal = false;
        private boolean isTagOnly = false;
        private static final int STATE_PREFIX = 0;
        private static final int STATE_TAG = 1;
        private static final int STATE_ID = 2;
        private static final int STATE_PSEUDOCLASS = 3;
        private static final int STATE_CLASS = 4;
        private static final int STATE_ATTRIB = 5;
        private static final int STATE_COMPSIGN = 6;
        private static final int STATE_ATTRIBVALUES = 7;
        private static final int STATE_DONE = 8;
        private static final int TYPE_DESCENDANT = 0;
        private static final int TYPE_CHILD = 1;
        private static final int TYPE_ADJACENT = 2;
        public static final int LEVEL_ID = 3;
        public static final int LEVEL_CLASS = 2;
        public static final int LEVEL_TAG = 1;
        private static final int COMP_EQUAL = 1;
        private static final int COMP_EQUALS_ONE = 2;
        private static final int COMP_EQUALS_ONEH = 3;

        public Tag(String string) {
            this.parseTagString(string, 0);
        }

        private void parseTagString(String string, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                int n3 = 0;
                block21: for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    switch (n3) {
                        case 0: {
                            if (c2 == '+') {
                                this.modifier = 2;
                                ++n3;
                                continue block21;
                            }
                            if (c2 == '>') {
                                this.modifier = 1;
                                ++n3;
                                continue block21;
                            }
                            n3 = 1;
                        }
                        case 1: {
                            if ((c2 | 0x20) >= 97 && (c2 | 0x20) <= 122 || c2 == '*' || c2 >= '0' && c2 <= '9' || c2 == '-') {
                                stringBuilder.append(c2);
                                continue block21;
                            }
                            if (c2 == '#') {
                                if (stringBuilder.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                }
                                stringBuilder = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                n3 = 2;
                                continue block21;
                            }
                            if (c2 == ':') {
                                if (stringBuilder.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                }
                                stringBuilder = new StringBuilder();
                                n3 = 3;
                                continue block21;
                            }
                            if (c2 == '.') {
                                if (stringBuilder.length() > 0) {
                                    this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                }
                                stringBuilder = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                n3 = 4;
                                continue block21;
                            }
                            if (c2 == '[') {
                                this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                stringBuilder = new StringBuilder();
                                n3 = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Illegal character '" + c2 + "' in selector part '" + string + "' at position " + (i2 + n2));
                        }
                        case 2: {
                            if (c2 != '.' && c2 != ':' && c2 != '[') {
                                stringBuilder.append(c2);
                                continue block21;
                            }
                            if (c2 == ':') {
                                this.id = InetHtmlDocument.getCachedString(stringBuilder.toString());
                                stringBuilder = new StringBuilder();
                                n3 = 3;
                                continue block21;
                            }
                            if (c2 == '.') {
                                this.id = InetHtmlDocument.getCachedString(stringBuilder.toString());
                                stringBuilder = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                n3 = 4;
                                continue block21;
                            }
                            if (c2 == '[') {
                                this.id = InetHtmlDocument.getCachedString(stringBuilder.toString());
                                stringBuilder = new StringBuilder();
                                n3 = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Illegal character '" + c2 + "' in selector part '" + string + "' at position " + (i2 + n2));
                        }
                        case 3: {
                            if ((c2 | 0x20) >= 97 && (c2 | 0x20) <= 122 || c2 == '(' || c2 == ')' || c2 == '-' || c2 == '_') {
                                stringBuilder.append(c2);
                                continue block21;
                            }
                            if (c2 == '.') {
                                this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                stringBuilder = new StringBuilder();
                                this.classNames = new ArrayList<Object>();
                                n3 = 4;
                                continue block21;
                            }
                            if (c2 == '[') {
                                this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                                stringBuilder = new StringBuilder();
                                n3 = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (i2 + n2));
                        }
                        case 4: {
                            if (c2 != '.' && c2 != '[') {
                                stringBuilder.append(c2);
                                continue block21;
                            }
                            if (c2 == '.') {
                                this.classNames.add(InetHtmlDocument.getCachedString(stringBuilder.toString()).toLowerCase());
                                stringBuilder = new StringBuilder();
                                n3 = 4;
                                continue block21;
                            }
                            if (c2 == '[') {
                                this.classNames.add(InetHtmlDocument.getCachedString(stringBuilder.toString()).toLowerCase());
                                stringBuilder = new StringBuilder();
                                n3 = 5;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (i2 + n2));
                        }
                        case 5: {
                            if (c2 == '=') {
                                this.attrib = this.getAttribute(stringBuilder.toString());
                                this.eqType = 1;
                                stringBuilder = new StringBuilder();
                                n3 = 7;
                                continue block21;
                            }
                            if (c2 == '|' || c2 == '~') {
                                this.attrib = this.getAttribute(stringBuilder.toString());
                                stringBuilder = new StringBuilder();
                                stringBuilder.append(c2);
                                n3 = 6;
                                continue block21;
                            }
                            if (c2 == ']') {
                                this.attrib = this.getAttribute(stringBuilder.toString());
                                stringBuilder = null;
                                n3 = 8;
                                continue block21;
                            }
                            stringBuilder.append(c2);
                            continue block21;
                        }
                        case 6: {
                            if (c2 == '=') {
                                if (stringBuilder.charAt(0) == '~') {
                                    this.eqType = 2;
                                }
                                if (stringBuilder.charAt(0) == '|') {
                                    this.eqType = 3;
                                }
                                stringBuilder = new StringBuilder();
                                n3 = 7;
                                continue block21;
                            }
                            throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (i2 + n2) + ". Expected '='");
                        }
                        case 7: {
                            if (this.attribValue == null && stringBuilder == null) {
                                stringBuilder = new StringBuilder();
                            }
                            if ((c2 == '\"' || c2 == '\'') && this.attribValue == null && stringBuilder.length() == 0) continue block21;
                            if (c2 == '\"' || c2 == '\'') {
                                this.attribValue = InetHtmlDocument.getCachedString(stringBuilder.toString());
                                stringBuilder = null;
                                continue block21;
                            }
                            if (c2 != ']') {
                                if (stringBuilder == null) continue block21;
                                stringBuilder.append(c2);
                                continue block21;
                            }
                            if (this.attribValue == null) {
                                this.attribValue = InetHtmlDocument.getCachedString(stringBuilder.toString());
                                stringBuilder = null;
                            }
                            n3 = 8;
                        }
                        case 8: {
                            if (c2 == ']') continue block21;
                            throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (i2 + n2));
                        }
                    }
                }
                switch (n3) {
                    case 0: {
                        throw new IllegalArgumentException("Syntax error : tag is empty at position " + n2);
                    }
                    case 1: {
                        this.tagName = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                        break;
                    }
                    case 2: {
                        this.id = InetHtmlDocument.getCachedString(stringBuilder.toString());
                        break;
                    }
                    case 3: {
                        this.pseudoClass = InetHtmlDocument.getCachedString(stringBuilder.toString().toLowerCase());
                        break;
                    }
                    case 4: {
                        this.classNames.add(InetHtmlDocument.getCachedString(stringBuilder.toString()).toLowerCase());
                        break;
                    }
                    case 5: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (string.length() + n2) + ". Exprected ']'");
                    }
                    case 6: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (string.length() + n2) + ". Exprected '='");
                    }
                    case 7: {
                        throw new IllegalArgumentException("Syntax error in selector part '" + string + "' at position " + (string.length() + n2) + ". Exprected '\"'");
                    }
                }
                if (this.tagName == null || this.tagName.equals("*")) {
                    this.isUniversal = true;
                } else {
                    HTML.Tag tag = HTML.getTag((String)this.tagName);
                    if (tag != null) {
                        this.tagName = tag;
                    }
                }
                if ("link".equals(this.pseudoClass)) {
                    this.pseudoClass = null;
                    if (this.attrib == null) {
                        this.attrib = HTML.Attribute.HREF;
                    }
                }
                if ("class".equals(this.attrib)) {
                    this.attrib = null;
                    if (this.classNames == null) {
                        this.classNames = new ArrayList<Object>();
                    }
                    this.classNames.add(this.attribValue);
                    this.attribValue = null;
                }
                if (this.tagName != null && this.pseudoClass == null && this.id == null && this.attrib == null && this.attribValue == null && this.classNames == null) {
                    this.isTagOnly = true;
                }
            }
        }

        private Object getAttribute(String string) {
            HTML.Attribute attribute = HTML.getAttributeKey(string);
            if (attribute != null) {
                return attribute;
            }
            return InetHtmlDocument.getCachedString(string.toLowerCase());
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.modifier == 1) {
                stringBuffer.append('>');
            }
            if (this.modifier == 2) {
                stringBuffer.append('+');
            }
            if (this.tagName != null) {
                stringBuffer.append(this.tagName);
            }
            if (this.id != null) {
                stringBuffer.append('#').append(this.id);
            }
            if (this.pseudoClass != null) {
                stringBuffer.append(':').append(this.pseudoClass);
            }
            if (this.classNames != null) {
                for (Object object : this.classNames) {
                    stringBuffer.append('.').append(object);
                }
            }
            if (this.attrib != null) {
                stringBuffer.append('[').append(this.attrib);
                if (this.attribValue != null) {
                    if (this.eqType == 1) {
                        stringBuffer.append('=');
                    }
                    if (this.eqType == 2) {
                        stringBuffer.append("~=");
                    }
                    if (this.eqType == 3) {
                        stringBuffer.append("|=");
                    }
                    stringBuffer.append('\"');
                    stringBuffer.append(this.attribValue);
                    stringBuffer.append('\"');
                }
                stringBuffer.append(']');
            }
            return stringBuffer.toString();
        }

        public int getLevelCount(int n2) {
            switch (n2) {
                case 1: {
                    return this.tagName != null ? (this.isUniversal ? 0 : 1) : 0;
                }
                case 2: {
                    int n3 = this.classNames != null ? this.classNames.size() : 0;
                    int n4 = this.pseudoClass != null ? 1 : 0;
                    return n3 + n4;
                }
                case 3: {
                    return this.id != null ? 1 : 0;
                }
            }
            return 0;
        }

        public boolean matches(Element element) {
            ArrayList<Object> arrayList;
            Object object;
            boolean bl2 = false;
            AttributeSet attributeSet = element.getAttributes();
            if (!this.isUniversal) {
                object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                if (object != this.tagName) {
                    return false;
                }
                bl2 = true;
            } else if (this.tagName != null) {
                bl2 = true;
            }
            if (this.id != null) {
                Object object2 = object = attributeSet.isDefined((Object)HTML.Attribute.ID) ? attributeSet.getAttribute((Object)HTML.Attribute.ID) : null;
                if (this.id != object) {
                    return false;
                }
                bl2 = true;
            }
            if (this.pseudoClass != null) {
                return false;
            }
            if (this.classNames != null && this.classNames.size() > 0) {
                block27: {
                    boolean bl3 = attributeSet.isDefined((Object)HTML.Attribute.CLASS);
                    arrayList = null;
                    try {
                        Object object3 = attributeSet.getAttribute((Object)HTML.Attribute.CLASS);
                        arrayList = bl3 && object3 != null && object3 instanceof ClassValue ? ((ClassValue)object3).getClassNames() : null;
                    }
                    catch (Exception exception) {
                        if (!Logger.doesLog(1)) break block27;
                        Logger.error(exception);
                    }
                }
                int n2 = 0;
                if (arrayList != null) {
                    for (Object object4 : this.classNames) {
                        if (!arrayList.contains(object4)) continue;
                        ++n2;
                    }
                }
                if (n2 < this.classNames.size()) {
                    return false;
                }
                bl2 = true;
            }
            if (this.attrib != null) {
                object = null;
                if (attributeSet.isDefined(this.attrib)) {
                    if ("".equals(attributeSet.getAttribute(this.attrib))) {
                        return false;
                    }
                    arrayList = attributeSet.getAttribute(this.attrib);
                    if (arrayList == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                object = ((Object)arrayList).toString();
                bl2 = true;
                if (this.attribValue != null) {
                    boolean bl4 = false;
                    switch (this.eqType) {
                        case 1: {
                            bl4 = this.attribValue == object;
                            break;
                        }
                        case 2: {
                            bl4 = object == this.attribValue ? true : this.find((String)object, this.attribValue);
                        }
                        case 3: {
                            if (object == this.attribValue) {
                                bl4 = true;
                                break;
                            }
                            if (!((String)object).startsWith(this.attribValue)) break;
                            if (((String)object).length() == this.attribValue.length()) {
                                bl4 = true;
                                break;
                            }
                            if (((String)object).charAt(this.attribValue.length()) != '-') break;
                            bl4 = true;
                        }
                    }
                    if (!bl4) {
                        return false;
                    }
                }
            }
            return bl2;
        }

        private boolean find(String string, String string2) {
            if (string == null || string2 == null || string.length() < string2.length()) {
                return false;
            }
            int n2 = string.indexOf(string2);
            if (n2 < 0) {
                return false;
            }
            if (n2 > 0 && string.charAt(n2 - 1) != ' ') {
                return false;
            }
            return n2 + string2.length() >= string.length() || string.charAt(n2 + string2.length()) == ' ';
        }

        private HTML.Tag getMatchedTag() {
            if (this.isTagOnly && this.tagName instanceof HTML.Tag) {
                return (HTML.Tag)((Object)this.tagName);
            }
            return null;
        }

        private boolean isUnversalTagOnly() {
            return this.isTagOnly && this.isUniversal;
        }
    }
}

