/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.css;

import com.inet.html.css.CSS;
import com.inet.html.css.CSSChangeListener;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Styles
implements Cloneable {
    private static final String INITIAL = "initial_styles";
    private static final String DEFAULT_INLINE = "default_inline";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("-?(?:[_a-z]|[\u0080-\u00ff]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])(?:[_a-z0-9-]|[\u0080-\u00ff]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*");
    private StyleSourceMap sources = new StyleSourceMap();
    private final HashMap<CSS.Attribute, ArrayList<Selector>> importantSelectors = new HashMap();
    private final HashMap<CSS.Attribute, ArrayList<Selector>> normalSelectors = new HashMap();
    private final HashMap<HTML.Tag, ArrayList<Selector>> tagSelectors = new HashMap();
    private final ArrayList<Selector> allSelectors = new ArrayList();
    private final HashMap<HTML.Tag, ArrayList<Selector>> otherSelectors = new HashMap();
    private boolean compiled = false;
    private final HashMap<HTML.Tag, MutableAttributeSet> defaultAttributes = new HashMap();
    private MutableAttributeSet baseSet = null;
    private int index;
    private ClassIDGenerator idGenerator = new ClassIDGenerator();
    public static final Object DONT_PARSE = new Object();
    private int initialCount = 0;
    private boolean dropInitials = true;
    private int dropOffset = 0;
    private String filename;
    private CSSChangeListener resolver;
    private int indexChecked;

    public Styles(String string) {
        this.filename = string;
        this.sources.create(DEFAULT_INLINE, true, false);
    }

    public Styles(String string, Styles styles) {
        this.filename = string;
        this.sources.create(DEFAULT_INLINE, true, false);
        if (styles != null && styles.sources.get(DEFAULT_INLINE) != null) {
            this.initialCount = ((StyleSource)styles.sources.get(DEFAULT_INLINE)).size();
            for (StyleSheetEntry styleSheetEntry : (StyleSource)styles.sources.get(DEFAULT_INLINE)) {
                this.addInitialRule(styleSheetEntry.selector, styleSheetEntry.atts, INITIAL);
            }
            this.index = this.initialCount;
        }
    }

    public void addInitialRule(String string, AttributeSet attributeSet, String string2) {
        this.dropInitials = false;
        if (this.sources.get(DEFAULT_INLINE) != null && ((StyleSource)this.sources.get(DEFAULT_INLINE)).size() > 0) {
            this.dropInitials = true;
            return;
        }
        if (this.sources.get(INITIAL) == null) {
            this.sources.put(INITIAL, new StyleSource(INITIAL, true, false));
        }
        if (this.initialCount >= ((StyleSource)this.sources.get(INITIAL)).size()) {
            this.addRule(string, attributeSet, INITIAL, false, false);
            ++this.initialCount;
        }
        this.dropInitials = true;
    }

    public Object register(Object object, boolean bl2, boolean bl3) {
        if (object == null) {
            return null;
        }
        if (this.sources.get(object) != null) {
            if (Logger.doesLog(4)) {
                Logger.debug("Style source registered twice: " + object);
            }
            return DONT_PARSE;
        }
        this.sources.create(object, bl2, bl3);
        Object object2 = this.getClassName(object);
        if (Logger.doesLog(4)) {
            Logger.debug("Created CSS Namespace '" + object2 + "'  for source: " + object);
        }
        return object2;
    }

    public void unregister(Object object) {
        StyleSource styleSource = (StyleSource)this.sources.get(object);
        if (styleSource != null) {
            StyleSource styleSource2 = (StyleSource)this.sources.get(DEFAULT_INLINE);
            if (styleSource2 == null) {
                styleSource2 = new StyleSource(DEFAULT_INLINE, true, false);
                this.sources.put(DEFAULT_INLINE, styleSource2);
            }
            styleSource2.addAll(styleSource);
            this.sources.remove(object);
        }
    }

    public void updateIndex() {
        StyleSource styleSource = (StyleSource)this.sources.get(DEFAULT_INLINE);
        if (styleSource.size() > this.indexChecked) {
            for (int i2 = this.indexChecked; i2 < styleSource.size(); ++i2) {
                Matcher matcher;
                StyleSheetEntry styleSheetEntry = (StyleSheetEntry)styleSource.get(i2);
                if (styleSheetEntry.selector == null || !styleSheetEntry.selector.contains("jwe-style") || !(matcher = ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(styleSheetEntry.selector)).matches()) continue;
                try {
                    this.idGenerator.register(Integer.parseInt(matcher.group(1)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.indexChecked = styleSource.size();
    }

    public boolean addRule(String string, AttributeSet attributeSet, Object object, boolean bl2, boolean bl3) {
        Object object2;
        Object object3;
        if (this.dropInitials && this.initialCount > 0 && this.dropOffset < this.initialCount) {
            int n2 = this.index - this.initialCount + this.dropOffset;
            object3 = (StyleSource)this.sources.get(INITIAL);
            if (object3 != null) {
                if (n2 < ((ArrayList)object3).size()) {
                    object2 = (StyleSheetEntry)((ArrayList)object3).get(n2);
                    if ((((StyleSheetEntry)object2).selector.equals(string) || object instanceof String && ((StyleSheetEntry)object2).selector.toLowerCase().equals(string + "." + object)) && ((StyleSheetEntry)object2).atts.equals(attributeSet)) {
                        ++this.dropOffset;
                        return !(object instanceof String) || !((StyleSheetEntry)object2).selector.toLowerCase().equals(string + "." + object);
                    }
                    this.dropInitials = false;
                } else {
                    this.dropInitials = false;
                }
            }
        }
        this.dropInitials = false;
        StyleSheetEntry styleSheetEntry = new StyleSheetEntry(attributeSet, string);
        object3 = this.sources.add(styleSheetEntry, object == null ? DEFAULT_INLINE : object);
        object2 = string.split(",");
        boolean bl4 = true;
        for (String string2 : object2) {
            try {
                String string3 = string2.trim();
                if (string3.length() == 0) continue;
                Selector selector = new Selector(string3, attributeSet, this.index++);
                if (object3 != null && object != null && !selector.hasJWEclass()) {
                    selector.setSourceClass(object3);
                    styleSheetEntry.addSelector(selector);
                    bl4 = false;
                }
                this.addToSplittedLists(selector);
                if (this.resolver != null) {
                    this.resolver.handleNewCSSEntry(selector);
                }
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (obj instanceof CSS.Attribute) {
                        AttributeValue attributeValue = (AttributeValue)attributeSet.getAttribute(obj);
                        this.addSelector(selector, (CSS.Attribute)((Object)obj), attributeValue.isImportant());
                        continue;
                    }
                    if (!Logger.doesLog(2)) continue;
                    Logger.warning("Unknown CSS attribute: " + obj);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!Logger.doesLog(4)) continue;
                Logger.debug(illegalArgumentException.getMessage());
            }
        }
        return bl4;
    }

    private void addToSplittedLists(Selector selector) {
        HTML.Tag tag = selector.getMatchedTag();
        if (tag != null) {
            ArrayList<Selector> arrayList = this.tagSelectors.get((Object)tag);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.tagSelectors.put(tag, arrayList);
            }
            arrayList.add(selector);
        } else if (selector.isUnversalTagOnly()) {
            this.allSelectors.add(selector);
        } else {
            ArrayList<Selector> arrayList;
            tag = selector.getPrimaryTag();
            if (tag == null) {
                tag = HTML.Tag.CSSALL;
            }
            if ((arrayList = this.otherSelectors.get((Object)tag)) == null) {
                arrayList = new ArrayList();
                this.otherSelectors.put(tag, arrayList);
            }
            arrayList.add(selector);
        }
    }

    public int getRuleCount() {
        return this.sources.size();
    }

    public List<Object> getSourceIdentifiers() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object k2 : this.sources.keySet()) {
            if (k2 == INITIAL) {
                arrayList.add(0, k2);
                continue;
            }
            arrayList.add(k2);
        }
        return arrayList;
    }

    public boolean isExternal(Object object) {
        StyleSource styleSource = (StyleSource)this.sources.get(object);
        return styleSource != null && !styleSource.isInline();
    }

    public List<StyleSheetEntry> getEntries(Object object) {
        return (List)this.sources.get(object);
    }

    private void addSelector(Selector selector, CSS.Attribute attribute, boolean bl2) {
        HashMap<CSS.Attribute, ArrayList<Selector>> hashMap = bl2 ? this.importantSelectors : this.normalSelectors;
        ArrayList<Selector> arrayList = hashMap.get((Object)attribute);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(attribute, arrayList);
        }
        int n2 = Collections.binarySearch(arrayList, selector);
        arrayList.add(-n2 - 1, selector);
    }

    public AttributeValue getCssAttribute(Element element, CSS.Attribute attribute, boolean bl2) {
        ArrayList<Selector> arrayList = bl2 ? this.importantSelectors.get((Object)attribute) : this.normalSelectors.get((Object)attribute);
        if (arrayList == null) {
            return null;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Selector selector = arrayList.get(i2);
            if (!selector.matches(element)) continue;
            return (AttributeValue)selector.getRule().getAttribute((Object)attribute);
        }
        return null;
    }

    public AttributeValue getCssAttribute(Element element, CSS.Attribute attribute, boolean bl2, List<Selector> list) {
        ArrayList<Selector> arrayList = bl2 ? this.importantSelectors.get((Object)attribute) : this.normalSelectors.get((Object)attribute);
        if (arrayList == null) {
            return null;
        }
        if (list.size() < arrayList.size()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Selector selector = list.get(i2);
                int n2 = Collections.binarySearch(arrayList, selector);
                if (n2 < 0) continue;
                return (AttributeValue)arrayList.get(n2).getRule().getAttribute((Object)attribute);
            }
        } else {
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Selector selector = arrayList.get(i3);
                int n3 = Collections.binarySearch(list, selector);
                if (n3 < 0) continue;
                return (AttributeValue)list.get(n3).getRule().getAttribute((Object)attribute);
            }
        }
        return null;
    }

    public List<Selector> createMatchList(Element element, HTML.Tag tag) {
        int n2;
        int n3;
        ArrayList<Selector> arrayList;
        Object object;
        ArrayList<Selector> arrayList2 = new ArrayList<Selector>();
        if (!this.compiled) {
            if (tag != null && (object = this.tagSelectors.get((Object)tag)) != null) {
                arrayList2.addAll((Collection<Selector>)object);
            }
            if (this.allSelectors != null) {
                arrayList2.addAll(this.allSelectors);
            }
        }
        object = null;
        if (tag != null && (arrayList = this.otherSelectors.get((Object)tag)) != null) {
            n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = arrayList.get(n2);
                if (!((Selector)object).matches(element)) continue;
                arrayList2.add((Selector)object);
            }
        }
        if ((arrayList = this.otherSelectors.get((Object)HTML.Tag.CSSALL)) != null) {
            n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = arrayList.get(n2);
                if (!((Selector)object).matches(element)) continue;
                arrayList2.add((Selector)object);
            }
        }
        Collections.sort(arrayList2, Selector.COMPARATOR);
        return arrayList2;
    }

    public void clear() {
        this.sources.clear();
        this.importantSelectors.clear();
        this.normalSelectors.clear();
        this.index = 0;
        this.sources.create(DEFAULT_INLINE, true, false);
    }

    public String getName() {
        return this.filename;
    }

    public int getInitialCount() {
        return this.initialCount;
    }

    public void setResolver(CSSChangeListener cSSChangeListener) {
        this.resolver = cSSChangeListener;
    }

    public void compile() {
        this.baseSet = new SimpleAttributeSet();
        for (Selector selector : this.allSelectors) {
            this.convertToTemp(selector.getRule(), this.baseSet);
            this.removeSelectorFromMatchList(selector, this.importantSelectors);
            this.removeSelectorFromMatchList(selector, this.normalSelectors);
        }
        for (HTML.Tag tag : HTML.Tag.values()) {
            Object object = new SimpleAttributeSet(this.baseSet);
            this.defaultAttributes.put(tag, (MutableAttributeSet)object);
        }
        for (Map.Entry entry : this.tagSelectors.entrySet()) {
            MutableAttributeSet mutableAttributeSet = this.defaultAttributes.get(entry.getKey());
            for (Object object : (ArrayList)entry.getValue()) {
                this.convertToTemp(((Selector)object).getRule(), mutableAttributeSet);
                this.removeSelectorFromMatchList((Selector)object, this.importantSelectors);
                this.removeSelectorFromMatchList((Selector)object, this.normalSelectors);
            }
        }
        this.compiled = true;
        this.allSelectors.clear();
        this.tagSelectors.clear();
    }

    private void convertToTemp(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (attributeSet == null || mutableAttributeSet == null) {
            return;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof CSS.Attribute)) continue;
            Object object = attributeSet.getAttribute(obj);
            TemporaryStyle.Attribute attribute = TemporaryStyle.getAttribute((CSS.Attribute)((Object)obj));
            mutableAttributeSet.addAttribute((Object)attribute, object);
        }
    }

    private void removeSelectorFromMatchList(Selector selector, HashMap<CSS.Attribute, ArrayList<Selector>> hashMap) {
        ArrayList<CSS.Attribute> arrayList = new ArrayList<CSS.Attribute>();
        for (Map.Entry<CSS.Attribute, ArrayList<Selector>> object : hashMap.entrySet()) {
            ArrayList<Selector> arrayList2 = object.getValue();
            int n2 = Collections.binarySearch(arrayList2, selector);
            if (n2 >= 0) {
                arrayList2.remove(n2);
            }
            if (arrayList2.size() != 0) continue;
            arrayList.add(object.getKey());
        }
        for (CSS.Attribute attribute : arrayList) {
            hashMap.remove((Object)attribute);
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public Set<CSS.Attribute> getDescribedAttributes() {
        TreeSet<CSS.Attribute> treeSet = new TreeSet<CSS.Attribute>();
        treeSet.addAll(this.importantSelectors.keySet());
        treeSet.addAll(this.normalSelectors.keySet());
        return treeSet;
    }

    public MutableAttributeSet getDefaultSet(Object object) {
        if (this.compiled) {
            MutableAttributeSet mutableAttributeSet = this.defaultAttributes.get(object);
            if (mutableAttributeSet == null) {
                return this.baseSet;
            }
            return mutableAttributeSet;
        }
        return null;
    }

    public Object getClassName(Object object) {
        StyleSource styleSource = (StyleSource)this.sources.get(object);
        if (styleSource != null) {
            return styleSource.getNameSpace();
        }
        return null;
    }

    public static class StyleSheetEntry {
        private AttributeSet atts;
        private String selector;
        private List<Selector> selectors;

        public StyleSheetEntry(AttributeSet attributeSet, String string) {
            this.atts = attributeSet;
            this.selector = string;
        }

        public AttributeSet getAttributess() {
            return this.atts;
        }

        public String getSelector() {
            if (this.selectors == null) {
                return this.selector;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Selector selector : this.selectors) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(selector.toExternal());
            }
            return stringBuilder.toString();
        }

        public void addSelector(Selector selector) {
            if (this.selectors == null) {
                this.selectors = new ArrayList<Selector>(1);
            }
            this.selectors.add(selector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleSource
    extends ArrayList<StyleSheetEntry> {
        private static final long serialVersionUID = 1L;
        private boolean isInline = true;
        private Object identifier;
        private Object nameSpace;

        public StyleSource(Object object, boolean bl2, boolean bl3) {
            this.identifier = object;
            this.isInline = bl2;
            if (bl3) {
                this.nameSpace = object instanceof String && CLASS_NAME_PATTERN.matcher((String)object).matches() ? object : Styles.this.idGenerator.getClassID(false);
            }
        }

        public boolean isInline() {
            return this.isInline;
        }

        public Object getNameSpace() {
            return this.nameSpace;
        }

        @Override
        public int hashCode() {
            return this.identifier.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.identifier.equals(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleSourceMap
    extends HashMap<Object, StyleSource> {
        private static final long serialVersionUID = 1L;

        private StyleSourceMap() {
        }

        public void create(Object object, boolean bl2, boolean bl3) {
            this.put(object, new StyleSource(object, bl2, bl3));
        }

        public Object add(StyleSheetEntry styleSheetEntry, Object object) {
            StyleSource styleSource = (StyleSource)this.get(object);
            if (styleSource != null) {
                styleSource.add(styleSheetEntry);
                return styleSource.getNameSpace();
            }
            if (Logger.doesLog(1)) {
                Logger.error("No source CSS found for '" + styleSheetEntry.selector + "', style will be ignored");
            }
            return null;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (StyleSource styleSource : this.values()) {
                n2 += styleSource.size();
            }
            return n2;
        }
    }
}

