/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.finder;

import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.Selector;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.AttributeValue;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFinder<T extends AttributeValue>
implements AttributeFinder<T> {
    private static final HashMap<CSS.Attribute, AttributeFinder<? extends AttributeValue>> FINDER_MAP = new HashMap();
    private final CSS.Attribute cssAttr;
    private final HTML.Attribute htmlAttr;
    private final Class<?> type;
    private final boolean inherited;

    public GenericFinder(CSS.Attribute attribute, HTML.Attribute attribute2, boolean bl2, Class<T> clazz) {
        this.cssAttr = attribute;
        this.htmlAttr = attribute2;
        this.inherited = bl2;
        this.type = clazz;
        if (attribute != null) {
            FINDER_MAP.put(attribute, this);
        }
    }

    @Override
    public Object findStyleAttribute(Element element) {
        Object object;
        if (this.cssAttr != null && element.getAttributes().isDefined((Object)this.cssAttr) && ((object = element.getAttributes().getAttribute((Object)this.cssAttr)) == AttributeValue.INHERIT || this.type.isInstance(object))) {
            return object;
        }
        return null;
    }

    @Override
    public Object findCssAttribute(Styles styles, Element element, boolean bl2) {
        AttributeValue attributeValue = styles.getCssAttribute(element, this.cssAttr, bl2);
        if (attributeValue == AttributeValue.INHERIT || this.type.isInstance(attributeValue)) {
            return attributeValue;
        }
        return null;
    }

    @Override
    public Object findCssAttribute(Styles styles, Element element, boolean bl2, List<Selector> list) {
        AttributeValue attributeValue = styles.getCssAttribute(element, this.cssAttr, bl2, list);
        if (attributeValue == AttributeValue.INHERIT || this.type.isInstance(attributeValue)) {
            return attributeValue;
        }
        return null;
    }

    @Override
    public Object findHtmlAttribute(Element element) {
        Object object;
        if (this.htmlAttr != null && element.getAttributes().isDefined((Object)this.htmlAttr) && this.type.isInstance(object = element.getAttributes().getAttribute((Object)this.htmlAttr))) {
            return object;
        }
        return null;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public T getAttributeValue(View view) {
        return (T)((AttributeValue)StyleResolver.getAttributeValue(view.getElement(), this));
    }

    public String toString() {
        if (this.cssAttr != null) {
            return this.cssAttr.toString();
        }
        return this.htmlAttr.toString();
    }

    public static AttributeFinder<? extends AttributeValue> getFinder(CSS.Attribute attribute) {
        return FINDER_MAP.get((Object)attribute);
    }

    @Override
    public CSS.Attribute getCSSAttribute() {
        return this.cssAttr;
    }

    @Override
    public HTML.Attribute getHTMLAttribute() {
        return this.htmlAttr;
    }
}

