/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageFetcher;
import com.inet.html.image.RemoteImage;
import com.inet.html.utils.InetStreamHandler;
import com.inet.html.utils.Logger;
import com.inet.html.utils.SoftHashMap;
import com.inet.html.utils.URLUtils;
import com.inet.protocol.data.Handler;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicLong;

public class ImageCache {
    private static final String CACHE_PREFIX = "CACHE:";
    private ImageFetcher fetcher;
    private SoftHashMap<String, RemoteImage> cache = new SoftHashMap();
    private AtomicLong idCounter = new AtomicLong(1000000L);
    private static ImageCache staticInstance = null;

    public ImageCache(ImageFetcher imageFetcher) {
        this.fetcher = imageFetcher;
    }

    public static synchronized ImageCache getStaticInstance() {
        if (staticInstance == null) {
            staticInstance = new ImageCache(new ImageFetcher());
        }
        return staticInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteImage getImage(String string, URL uRL, AnimationObserver animationObserver) {
        RemoteImage remoteImage = null;
        if (ImageCache.isCacheReference(string)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                remoteImage = this.cache.get(string);
            }
            if (remoteImage != null) {
                remoteImage.addObserver(animationObserver);
                return remoteImage;
            }
            this.sendError(animationObserver);
            return null;
        }
        URL uRL2 = this.getTarget(string, uRL);
        if (uRL2 == null) {
            this.sendError(animationObserver);
            return null;
        }
        URL uRL3 = this.getURLwithReferrer(uRL2, uRL);
        String string2 = uRL2.toString();
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            remoteImage = this.cache.get(string2);
        }
        if (remoteImage != null) {
            remoteImage.addObserver(animationObserver);
        } else {
            remoteImage = this.fetcher.getImage(uRL3, animationObserver);
            softHashMap = this.cache;
            synchronized (softHashMap) {
                this.cache.put(string2, remoteImage);
            }
        }
        return remoteImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(String string, URL uRL, Image image) {
        Object object;
        RemoteImage remoteImage = new RemoteImage(image);
        if (ImageCache.isCacheReference(string)) {
            object = this.cache;
            synchronized (object) {
                remoteImage = this.cache.put(string, remoteImage);
            }
        }
        if ((object = this.getTarget(string, uRL)) == null) {
            return;
        }
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            this.cache.put(((URL)object).toString(), remoteImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(String string, URL uRL) {
        if (ImageCache.isCacheReference(string)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                return this.cache.remove(string) != null;
            }
        }
        URL uRL2 = this.getTarget(string, uRL);
        if (uRL2 != null) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                return this.cache.remove(uRL2) != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCachedImage(String string, URL uRL) {
        RemoteImage remoteImage = null;
        if (ImageCache.isCacheReference(string)) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                remoteImage = this.cache.get(string);
            }
        }
        URL uRL2 = this.getTarget(string, uRL);
        if (uRL2 != null) {
            SoftHashMap<String, RemoteImage> softHashMap = this.cache;
            synchronized (softHashMap) {
                remoteImage = this.cache.get(uRL2);
            }
        }
        if (remoteImage != null && remoteImage.getStatus() == 2) {
            return remoteImage.getContent();
        }
        return null;
    }

    private URL getTarget(String string, URL uRL) {
        URL uRL2;
        block12: {
            if (uRL == null) {
                Logger.warning("Missing base URL for image '" + string + "'. This image may not load.");
            }
            try {
                try {
                    uRL2 = new URL(uRL, URLUtils.transcode(string, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (Logger.doesLog(2)) {
                        Logger.error(unsupportedEncodingException);
                    }
                    uRL2 = new URL(uRL, string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (string.startsWith("data:")) {
                    try {
                        Field field = URL.class.getDeclaredField("handlers");
                        field.setAccessible(true);
                        Hashtable hashtable = (Hashtable)field.get(null);
                        hashtable.put("data", new Handler());
                        uRL2 = new URL(string);
                    }
                    catch (Throwable throwable) {
                        uRL2 = null;
                    }
                } else {
                    uRL2 = null;
                }
                if (uRL2 != null) break block12;
                if (Logger.doesLog(2)) {
                    Logger.error(malformedURLException);
                }
                return null;
            }
        }
        if (!this.isAllowedToConnectTo(uRL2)) {
            return null;
        }
        return uRL2;
    }

    private void sendError(ImageObserver imageObserver) {
        if (imageObserver != null) {
            imageObserver.imageUpdate(null, 64, 0, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerImage(Image image) {
        String string = CACHE_PREFIX + this.idCounter.incrementAndGet();
        SoftHashMap<String, RemoteImage> softHashMap = this.cache;
        synchronized (softHashMap) {
            this.cache.put(string, new RemoteImage(image));
        }
        return string;
    }

    public static boolean isCacheReference(String string) {
        return string != null && string.startsWith(CACHE_PREFIX);
    }

    private URL getURLwithReferrer(URL uRL, URL uRL2) {
        if (uRL == null) {
            return null;
        }
        InetStreamHandler inetStreamHandler = new InetStreamHandler(uRL);
        inetStreamHandler.setReferrer(uRL2);
        String string = uRL.getPath() + (uRL.getQuery() != null ? "?" + uRL.getQuery() : "") + (uRL.getRef() != null ? "#" + uRL.getRef() : "");
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string, inetStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
        catch (SecurityException securityException) {
            if (Logger.doesLog(4)) {
                Logger.debug("Could not attach referrer due to security restriction. URL was '" + uRL + "'");
            }
            return uRL;
        }
    }

    private boolean isAllowedToConnectTo(URL uRL) {
        if (uRL != null && uRL.getHost() != null && uRL.getHost().length() > 0 && "file".equals(uRL.getProtocol())) {
            return false;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (uRL != null && securityManager != null) {
            String string = uRL.getHost();
            int n2 = uRL.getPort();
            if (string != null) {
                try {
                    securityManager.checkConnect(string, n2);
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
        }
        return true;
    }
}

