/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.image.AnimationObserver;
import com.inet.html.image.RemoteImage;
import com.inet.html.views.RenderContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageFetcher {
    private static boolean useToolkit = false;
    private static LinkedBlockingQueue<RemoteImage> pending = new LinkedBlockingQueue();
    private static Vector<FetcherThread> threads = new Vector();
    private static int THREAD_COUNT = 5;
    private static int DEFAULT_DELAY = 100;

    public static void setUseToolkit(boolean bl2) {
        useToolkit = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteImage getImage(URL uRL, AnimationObserver animationObserver) {
        if (uRL == null) {
            return null;
        }
        Object object = threads;
        synchronized (object) {
            for (FetcherThread fetcherThread : threads) {
                RemoteImage remoteImage = fetcherThread.img;
                if (remoteImage == null || !uRL.equals(remoteImage.getLocation())) continue;
                remoteImage.addObserver(animationObserver);
                if (remoteImage.getWidth() > 0 || remoteImage.getHeight() > 0) {
                    remoteImage.imageUpdate(3, 0, 0, remoteImage.getWidth(), remoteImage.getHeight());
                }
                return remoteImage;
            }
        }
        object = new RemoteImage(uRL);
        ((RemoteImage)object).addObserver(animationObserver);
        pending.offer((RemoteImage)object);
        ImageFetcher.checkThreadStates();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkThreadStates() {
        Vector<FetcherThread> vector = threads;
        synchronized (vector) {
            if (threads.size() >= THREAD_COUNT) {
                return;
            }
            FetcherThread fetcherThread = new FetcherThread();
            Thread thread = new Thread(fetcherThread);
            try {
                thread.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            thread.start();
            threads.add(fetcherThread);
        }
    }

    static /* synthetic */ LinkedBlockingQueue access$200() {
        return pending;
    }

    static /* synthetic */ boolean access$300() {
        return useToolkit;
    }

    static /* synthetic */ Vector access$400() {
        return threads;
    }

    static {
        ImageIO.setUseCache(false);
    }

    private static class ImageNotifier
    implements IIOReadUpdateListener,
    IIOReadProgressListener {
        private final RemoteImage img;
        private int width;
        private int height;
        private boolean filled = false;

        public ImageNotifier(RemoteImage remoteImage) {
            this.img = remoteImage;
        }

        public void imageUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
            this.img.setContent(bufferedImage);
            if (!this.filled) {
                this.filled = true;
                if (n3 == 0 && n6 <= 1 && n7 <= 1 && n5 < bufferedImage.getHeight() && n4 == bufferedImage.getWidth()) {
                    Graphics graphics = bufferedImage.getGraphics();
                    if (bufferedImage.getColorModel().hasAlpha()) {
                        graphics.setColor(new Color(255, 255, 255, 255));
                    } else {
                        graphics.setColor(Color.WHITE);
                    }
                    graphics.fillRect(0, n5, n4, bufferedImage.getHeight() - n5);
                }
            }
            if (bufferedImage != null) {
                int n8 = 0;
                if (bufferedImage.getWidth() != n4) {
                    this.width = bufferedImage.getWidth();
                    ++n8;
                }
                if (bufferedImage.getHeight() != n5) {
                    this.height = bufferedImage.getHeight();
                    n8 += 2;
                }
                if (n8 != 0) {
                    this.img.imageUpdate(n8, 0, 0, this.width, this.height);
                    return;
                }
            }
            this.img.imageUpdate(8, n2, n3, n4, n5);
        }

        public void passComplete(ImageReader imageReader, BufferedImage bufferedImage) {
            this.img.setContent(bufferedImage);
            this.img.imageUpdate(16, 0, 0, this.width, this.height);
        }

        public void passStarted(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
            this.img.setContent(bufferedImage);
        }

        public void thumbnailPassComplete(ImageReader imageReader, BufferedImage bufferedImage) {
        }

        public void thumbnailPassStarted(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        }

        public void thumbnailUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        }

        public void imageComplete(ImageReader imageReader) {
            this.img.imageUpdate(32, 0, 0, this.width, this.height);
            this.filled = false;
        }

        public void imageProgress(ImageReader imageReader, float f2) {
        }

        public void imageStarted(ImageReader imageReader, int n2) {
        }

        public void readAborted(ImageReader imageReader) {
            this.img.imageUpdate(128, 0, 0, this.width, this.height);
        }

        public void sequenceComplete(ImageReader imageReader) {
            this.img.imageUpdate(16, 0, 0, this.width, this.height);
        }

        public void sequenceStarted(ImageReader imageReader, int n2) {
        }

        public void thumbnailComplete(ImageReader imageReader) {
        }

        public void thumbnailProgress(ImageReader imageReader, float f2) {
        }

        public void thumbnailStarted(ImageReader imageReader, int n2, int n3) {
        }
    }

    private static class FetcherThread
    implements Runnable {
        private RemoteImage img;

        private FetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                Thread.currentThread().setName("JWebEngine Image Fetcher");
            }
            catch (SecurityException var1_1) {
                // empty catch block
            }
            while (true) lbl-1000:
            // 7 sources

            {
                this.img = (RemoteImage)ImageFetcher.access$200().poll();
                if (this.img == null) {
                    return;
                }
                if (ImageFetcher.access$300()) {
                    var1_2 = this.img;
                    var1_2.setContent(Toolkit.getDefaultToolkit().createImage(var1_2.getLocation()));
                    Toolkit.getDefaultToolkit().checkImage(var1_2.getContent(), -1, -1, new ImageObserver((RemoteImage)var1_2){
                        final /* synthetic */ RemoteImage val$refImage;
                        {
                            this.val$refImage = remoteImage;
                        }

                        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
                            this.val$refImage.imageUpdate(n2, n3, n4, n5, n6);
                            return (n2 & 0x20) <= 0 && (n2 & 0x80) <= 0 && (n2 & 0x40) <= 0;
                        }
                    });
                    continue;
                }
                var1_2 = null;
                var2_3 = null;
                try {
                    var3_4 = this.img.getLocation().openConnection();
                    RenderContext.setSSLSocketFactory(var3_4);
                    var1_2 = var3_4.getInputStream();
                    if (var3_4 instanceof HttpURLConnection && (var5_11 = (var4_10 = (HttpURLConnection)var3_4).getResponseCode()) >= 300 && var5_11 < 400 && (var6_13 = var4_10.getHeaderField("Location")) != null) {
                        var1_2.close();
                        var3_4 = new URL(var6_13).openConnection();
                        RenderContext.setSSLSocketFactory(var3_4);
                        var1_2 = var3_4.getInputStream();
                    }
                    if (var3_4 instanceof HttpURLConnection && (var4_10 = ((HttpURLConnection)var3_4).getContentEncoding()) != null && var4_10.equalsIgnoreCase("gzip")) {
                        var1_2 = new GZIPInputStream((InputStream)var1_2);
                    }
                    if ((var4_10 = ImageIO.getImageReaders(var2_3 = ImageIO.createImageInputStream(var1_2))).hasNext()) {
                        var5_12 = var4_10.next();
                        if (var5_12.getFormatName().toLowerCase().equals("gif")) {
                            this.loadImageGIF(var2_3, var5_12);
                        }
                        this.loadImageDefault(var2_3, var5_12);
                    }
                    this.img.imageUpdate(64, 0, 0, 0, 0);
                }
                catch (IOException var3_7) {
                    this.img.imageUpdate(64, 0, 0, 0, 0);
                }
                finally {
                    if (var2_3 != null) {
                        try {
                            var2_3.close();
                        }
                        catch (IOException var3_8) {}
                    }
                    if (var1_2 == null) continue;
                    try {
                        var1_2.close();
                    }
                    catch (IOException var3_9) {}
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                ImageFetcher.access$400().remove(this);
            }
        }

        private void loadImageGIF(ImageInputStream imageInputStream, ImageReader imageReader) throws IOException {
            imageReader.setInput(imageInputStream, true, false);
            int n2 = Short.MAX_VALUE;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    BufferedImage bufferedImage = imageReader.read(i2);
                    Rectangle rectangle = null;
                    int n3 = DEFAULT_DELAY;
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(i2);
                    if (iIOMetadata != null) {
                        Node node = iIOMetadata.getAsTree("javax_imageio_gif_image_1.0");
                        rectangle = this.getGIFBoundsFromMetadata(node);
                        n3 = this.getGIFdelay(node);
                    }
                    this.img.addContent(bufferedImage, n3, rectangle);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
            }
        }

        private int getGIFdelay(Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                if (!"GraphicControlExtension".equals(node2.getNodeName())) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("delayTime");
                if (node3 == null || node3.getNodeValue() == null) break;
                try {
                    return Integer.valueOf(node3.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            return DEFAULT_DELAY;
        }

        private Rectangle getGIFBoundsFromMetadata(Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                if (!"ImageDescriptor".equals(node2.getNodeName())) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                try {
                    int n2 = Integer.valueOf(namedNodeMap.getNamedItem("imageLeftPosition").getNodeValue());
                    int n3 = Integer.valueOf(namedNodeMap.getNamedItem("imageTopPosition").getNodeValue());
                    int n4 = Integer.valueOf(namedNodeMap.getNamedItem("imageWidth").getNodeValue());
                    int n5 = Integer.valueOf(namedNodeMap.getNamedItem("imageHeight").getNodeValue());
                    return new Rectangle(n2, n3, n4, n5);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }

        private void loadImageDefault(ImageInputStream imageInputStream, ImageReader imageReader) throws IOException {
            ImageNotifier imageNotifier = new ImageNotifier(this.img);
            imageReader.addIIOReadUpdateListener(imageNotifier);
            imageReader.addIIOReadProgressListener(imageNotifier);
            imageReader.setInput(imageInputStream, true, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            this.img.setContent(bufferedImage);
        }
    }
}

