/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.image;

import com.inet.html.image.AnimationObserver;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemoteImage {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_INVALID = 3;
    public static final int DELAY_INFINITE = -1;
    private List<ImageStepInfo> images = new ArrayList<ImageStepInfo>(1);
    private URL location;
    private int height = 0;
    private int width = 0;
    private Set<AnimationObserver> observers = new HashSet<AnimationObserver>();
    private int status = 0;
    private Thread animator;

    public RemoteImage(URL uRL) {
        this.location = uRL;
    }

    public RemoteImage(Image image) {
        if (image != null) {
            this.images.add(new ImageStepInfo(image, -1, null));
        }
        this.status = 2;
    }

    public URL getLocation() {
        return this.location;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(AnimationObserver animationObserver) {
        if (animationObserver == null) {
            return;
        }
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            RemoteImage remoteImage = this;
            synchronized (remoteImage) {
                if (!(this.status <= 1 || this.images.size() > 1 && animationObserver.doAnimate())) {
                    int n2 = this.status == 2 ? 32 : 64;
                    animationObserver.imageUpdate(this.getContent(), n2, 0, 0, this.width, this.height);
                    return;
                }
            }
            if (!this.observers.contains(animationObserver)) {
                this.observers.add(animationObserver);
            }
            this.checkAnimator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(AnimationObserver animationObserver) {
        if (animationObserver == null) {
            return;
        }
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            this.observers.remove(animationObserver);
        }
        this.checkAnimator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageUpdate(int n2, int n3, int n4, int n5, int n6) {
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            if (this.status == 0) {
                this.status = 1;
            }
            for (AnimationObserver animationObserver : this.observers) {
                animationObserver.imageUpdate(this.getContent(), n2, n3, n4, n5, n6);
            }
            if ((n2 & 0x20) > 0 || (n2 & 0x40) > 0 || (n2 & 0x80) > 0) {
                this.status = (n2 & 0x20) > 0 ? 2 : 3;
                this.observers.clear();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Image image) {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            this.images.clear();
            if (image != null) {
                this.images.add(new ImageStepInfo(image, -1, null));
                this.width = image.getWidth(null);
                this.height = image.getHeight(null);
                this.status = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getContent() {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            if (this.images.size() > 0) {
                return this.images.get(0).content;
            }
        }
        return null;
    }

    public String toString() {
        String string;
        switch (this.status) {
            case 0: {
                string = "pending";
                break;
            }
            case 1: {
                string = "loading";
                break;
            }
            case 2: {
                string = "loaded";
                break;
            }
            default: {
                string = "error";
            }
        }
        return "RemoteImage(" + string + "): " + this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(Image image, int n2, Rectangle rectangle) {
        RemoteImage remoteImage = this;
        synchronized (remoteImage) {
            this.images.add(new ImageStepInfo(image, n2, rectangle));
            if (this.images.size() == 1) {
                this.width = image.getWidth(null);
                this.height = image.getHeight(null);
            }
            this.status = 2;
        }
        this.checkAnimator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countAnimatedObserver() {
        int n2 = 0;
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            for (AnimationObserver animationObserver : this.observers) {
                if (!animationObserver.doAnimate()) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAnimator() {
        Set<AnimationObserver> set = this.observers;
        synchronized (set) {
            RemoteImage remoteImage = this;
            synchronized (remoteImage) {
                if (this.countAnimatedObserver() > 0) {
                    if (this.images.size() > 1) {
                        if (this.animator == null) {
                            this.animator = new Thread(new Animator());
                            try {
                                this.animator.setName("Image Animator");
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                            this.animator.start();
                        }
                    } else if (this.images.size() == 1) {
                        ImageStepInfo imageStepInfo = this.images.get(0);
                        if (this.animator == null) {
                            for (AnimationObserver animationObserver : this.observers) {
                                animationObserver.imageUpdate(imageStepInfo.content, 16, 0, 0, this.width, this.height);
                            }
                        }
                    } else if (this.animator != null) {
                        this.animator.interrupt();
                    }
                } else {
                    if (this.animator != null) {
                        this.animator.interrupt();
                    }
                    if (this.observers.size() > 0 && this.images.size() == 1) {
                        ImageStepInfo imageStepInfo = this.images.get(0);
                        for (AnimationObserver animationObserver : this.observers) {
                            animationObserver.imageUpdate(imageStepInfo.content, 32, 0, 0, this.width, this.height);
                        }
                    }
                }
            }
        }
    }

    private class Animator
    implements Runnable {
        private Animator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n2 = 0;
            while (true) {
                ImageStepInfo imageStepInfo;
                Object object = RemoteImage.this;
                synchronized (object) {
                    int n3 = RemoteImage.this.images.size();
                    if (n3 == 0) {
                        RemoteImage.this.animator = null;
                        return;
                    }
                    if (n2 >= n3) {
                        n2 = 0;
                    }
                    imageStepInfo = (ImageStepInfo)RemoteImage.this.images.get(n2);
                    ++n2;
                }
                object = RemoteImage.this.observers;
                synchronized (object) {
                    if (RemoteImage.this.observers.size() == 0) {
                        RemoteImage.this.animator = null;
                        return;
                    }
                    for (AnimationObserver animationObserver : RemoteImage.this.observers) {
                        if (imageStepInfo.bounds == null) {
                            animationObserver.imageUpdate(imageStepInfo.content, 16, 0, 0, RemoteImage.this.width, RemoteImage.this.height);
                            continue;
                        }
                        animationObserver.imageUpdate(imageStepInfo.content, 16, ((ImageStepInfo)imageStepInfo).bounds.x, ((ImageStepInfo)imageStepInfo).bounds.y, ((ImageStepInfo)imageStepInfo).bounds.width, ((ImageStepInfo)imageStepInfo).bounds.height);
                    }
                }
                try {
                    Thread.sleep(imageStepInfo.delay * 10);
                }
                catch (InterruptedException interruptedException) {
                    RemoteImage.this.animator = null;
                    return;
                }
            }
        }
    }

    private static class ImageStepInfo {
        private Image content;
        private int delay;
        private final Rectangle bounds;

        public ImageStepInfo(Image image, int n2, Rectangle rectangle) {
            this.content = image;
            this.delay = n2;
            this.bounds = rectangle;
        }
    }
}

