/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import com.inet.html.css.CSS;
import com.inet.html.css.Styles;
import com.inet.html.parser.PushReader;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.utils.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class CssParser {
    private final PushReader reader;
    private final URL baseURL;
    private final StringBuilder content = new StringBuilder();
    private final Styles styles;
    private final Object sourceID;
    private boolean ignoreUnknown = false;
    private Pattern importPattern = Pattern.compile("@import[\\t\\s]+(?:url\\([\\t\\s]*\"?(.+?)\"?[\\t\\s]*\\)|\"(.+)\")[\\t\\s]*(.*?)[\\t\\s]*", 2);
    private boolean avoidDuplicates;
    private boolean isInline = true;

    public CssParser(URL uRL, Styles styles, boolean bl2, Object object) throws IOException {
        InputStreamReader inputStreamReader;
        InputStream inputStream = uRL.openStream();
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        }
        catch (Throwable throwable) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        this.isInline = false;
        this.reader = new PushReader(inputStreamReader);
        this.styles = styles;
        this.baseURL = uRL;
        this.sourceID = object;
        this.ignoreUnknown = bl2;
    }

    public CssParser(PushReader pushReader, Styles styles, boolean bl2) {
        this.reader = pushReader;
        this.styles = styles;
        this.baseURL = null;
        this.sourceID = null;
        this.ignoreUnknown = bl2;
    }

    public CssParser(URL uRL, Object object, Styles styles, String string, boolean bl2) throws IOException {
        InputStreamReader inputStreamReader;
        InputStream inputStream = uRL.openStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8192);
        bufferedInputStream.mark(8192);
        this.ignoreUnknown = bl2;
        try {
            inputStreamReader = string == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, string);
        }
        catch (Throwable throwable) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        PushReader pushReader = new PushReader(inputStreamReader);
        if (!"UTF8".equalsIgnoreCase(string)) {
            try {
                pushReader.checkForUtf8Prefix();
            }
            catch (ChangedCharSetException changedCharSetException) {
                string = changedCharSetException.getCharSetSpec();
                bufferedInputStream.reset();
                pushReader = new PushReader(new InputStreamReader((InputStream)bufferedInputStream, string));
            }
        }
        this.isInline = false;
        this.reader = pushReader;
        this.styles = styles;
        this.baseURL = uRL;
        this.sourceID = object;
    }

    public CssParser(String string, Styles styles, URL uRL, boolean bl2, boolean bl3) {
        this(new PushReader(new StringReader(string)), styles, null, uRL, bl2, bl3);
    }

    public CssParser(PushReader pushReader, Styles styles, Object object, URL uRL, boolean bl2, boolean bl3) {
        this.reader = pushReader;
        this.styles = styles;
        this.baseURL = uRL;
        this.sourceID = object;
        this.ignoreUnknown = bl2;
        this.avoidDuplicates = bl3;
    }

    public void parse() throws IOException {
        this.parseWithID();
    }

    public Object parseWithID() throws IOException {
        Object object = this.styles.register(this.sourceID, this.isInline, this.sourceID != null);
        if (object == Styles.DONT_PARSE) {
            this.parseLoop(true);
            return this.styles.getClassName(this.sourceID);
        }
        boolean bl2 = this.parseLoop(false);
        if (bl2) {
            object = null;
            this.styles.unregister(object);
        }
        this.styles.updateIndex();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseLoop(boolean bl2) throws IOException {
        boolean bl3 = true;
        boolean bl4 = false;
        try {
            block14: while (true) {
                int n2 = this.reader.read();
                switch (n2) {
                    case -1: {
                        this.reader.close();
                        return bl3;
                    }
                    case 60: {
                        if (this.skipHTMLCommentStart()) continue block14;
                        this.reader.push('<');
                        return bl3;
                    }
                    case 125: {
                        break;
                    }
                    case 123: {
                        Object object;
                        Object object2;
                        Object object3;
                        String string = this.content.toString().trim();
                        this.content.setLength(0);
                        if (string.contains("@")) {
                            object3 = string.toLowerCase();
                            if (((String)object3).contains("screen")) continue block14;
                            if (((String)object3).contains("all")) continue block14;
                            this.skipUnsupportedTarget();
                            break;
                        }
                        object3 = new SimpleAttributeSet();
                        this.parseStyle((MutableAttributeSet)object3);
                        if (object3.getAttributeCount() > 0) {
                            object2 = object3.getAttributeNames();
                            while (object2.hasMoreElements()) {
                                object = object3.getAttribute(object2.nextElement());
                                if (!(object instanceof AttributeValue)) continue;
                                ((AttributeValue)object).setBase(this.baseURL);
                            }
                        }
                        if (bl2) continue block14;
                        bl3 &= this.styles.addRule(string, (AttributeSet)object3, this.sourceID, this.avoidDuplicates, this.isInline);
                        break;
                    }
                    case 65279: {
                        break;
                    }
                    case 59: {
                        String string;
                        Object object3 = this.content.toString().trim();
                        Object object2 = this.importPattern.matcher((CharSequence)object3);
                        if (((String)object3).length() <= 10 || !((Matcher)object2).matches()) continue block14;
                        Object object = ((Matcher)object2).group(1) != null ? ((Matcher)object2).group(1) : ((Matcher)object2).group(2);
                        String string2 = string = ((Matcher)object2).groupCount() > 2 ? ((Matcher)object2).group(3) : null;
                        if (string != null && string.length() > 0 && !string.toLowerCase().contains("screen")) continue block14;
                        if (((String)object).length() <= 0) continue block14;
                        try {
                            URL uRL;
                            URL uRL2 = uRL = this.baseURL != null ? new URL(this.baseURL, (String)object) : new URL((String)object);
                            if (!bl2) {
                                CssParser cssParser = new CssParser(uRL, this.styles, this.ignoreUnknown, this.sourceID);
                                cssParser.parse();
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Logger.warning("Invalid CSS @import: " + (String)object);
                        }
                        catch (IOException iOException) {
                            Logger.warning("Unable to parse CSS @import: " + (String)object);
                            Logger.debug(iOException.getMessage());
                        }
                        this.content.setLength(0);
                        break;
                    }
                    case 47: {
                        if (!bl4) {
                            bl4 = true;
                            break;
                        }
                    }
                    default: {
                        if (bl4) {
                            if (n2 == 42) {
                                this.skipComment();
                            } else {
                                this.content.append('/');
                                this.content.append((char)n2);
                            }
                            bl4 = false;
                            break;
                        }
                        this.content.append((char)n2);
                    }
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return bl3;
        }
    }

    private void skipUnsupportedTarget() throws IOException {
        int n2 = 1;
        do {
            int n3 = this.reader.read();
            switch (n3) {
                case 123: {
                    ++n2;
                    break;
                }
                case 125: {
                    --n2;
                    break;
                }
                case -1: {
                    return;
                }
            }
        } while (n2 != 0);
    }

    private boolean skipHTMLCommentStart() throws IOException {
        int[] nArray = new int[2];
        int n2 = this.reader.read();
        if (n2 != 33) {
            this.reader.push((char)n2);
            return false;
        }
        nArray[0] = n2;
        n2 = this.reader.read();
        if (n2 != 45) {
            this.reader.push((char)n2);
            this.reader.push((char)nArray[0]);
            return false;
        }
        nArray[1] = n2;
        n2 = this.reader.read();
        if (n2 != 45) {
            this.reader.push((char)n2);
            this.reader.push((char)nArray[1]);
            this.reader.push((char)nArray[0]);
            return false;
        }
        return true;
    }

    private void skipComment() throws IOException {
        boolean bl2 = false;
        block5: while (true) {
            int n2 = this.reader.read();
            switch (n2) {
                case -1: {
                    return;
                }
                case 42: {
                    bl2 = true;
                    continue block5;
                }
                case 47: {
                    if (!bl2) break;
                    return;
                }
            }
            bl2 = false;
        }
    }

    public void parseStyle(MutableAttributeSet mutableAttributeSet) throws IOException {
        int n2 = 59;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        block9: while (true) {
            int n3 = this.reader.read();
            switch (n3) {
                case -1: 
                case 125: {
                    if (stringBuilder3 != null && stringBuilder3.toString().trim().equalsIgnoreCase("important")) {
                        this.addAttribute(mutableAttributeSet, stringBuilder, stringBuilder2, true);
                    } else {
                        this.addAttribute(mutableAttributeSet, stringBuilder, stringBuilder2, false);
                    }
                    return;
                }
                case 58: {
                    if (bl2) break;
                    n2 = n3;
                    continue block9;
                }
                case 59: {
                    if (bl2) break;
                    if (stringBuilder3 != null && stringBuilder3.toString().trim().equalsIgnoreCase("important")) {
                        this.addAttribute(mutableAttributeSet, stringBuilder, stringBuilder2, true);
                    } else {
                        this.addAttribute(mutableAttributeSet, stringBuilder, stringBuilder2, false);
                    }
                    stringBuilder3 = null;
                    n2 = n3;
                    continue block9;
                }
                case 47: {
                    if (bl3) break;
                    bl3 = true;
                    continue block9;
                }
                case 33: {
                    stringBuilder3 = new StringBuilder();
                    n2 = n3;
                    continue block9;
                }
                case 40: {
                    bl2 = true;
                    break;
                }
                case 41: {
                    bl2 = false;
                }
            }
            if (bl3) {
                if (n3 == 42) {
                    this.skipComment();
                } else if (n2 == 59) {
                    stringBuilder.append('/');
                    stringBuilder.append((char)n3);
                } else {
                    stringBuilder2.append('/');
                    stringBuilder2.append((char)n3);
                }
                bl3 = false;
                continue;
            }
            if (n2 == 59) {
                stringBuilder.append((char)n3);
                continue;
            }
            if (n2 == 33 && stringBuilder3 != null) {
                stringBuilder3.append((char)n3);
                continue;
            }
            stringBuilder2.append((char)n3);
        }
    }

    private void addAttribute(MutableAttributeSet mutableAttributeSet, StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl2) {
        String string = stringBuilder.toString().trim().toLowerCase();
        String string2 = stringBuilder2.toString().trim();
        stringBuilder.setLength(0);
        stringBuilder2.setLength(0);
        if (string.length() == 0) {
            return;
        }
        CSS.Attribute attribute = CSS.getAttribute(string);
        if (attribute != null) {
            AttributeValue.addCssAtrributes(mutableAttributeSet, attribute, string2, bl2);
        } else if (!this.ignoreUnknown) {
            mutableAttributeSet.addAttribute(string, string2);
        }
    }
}

