/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class DocType {
    private static final String PREFIX = "<!DOCTYPE html PUBLIC \"-//W3C//DTD ";
    private static final String SUFFIX = "\">";
    private static final NumberFormat VERSION_FORMAT;
    private Type type;
    private float version;
    private Variant variant;

    public DocType() {
        this.type = Type.quirks;
        this.version = 3.2f;
        this.variant = Variant.Transitional;
    }

    public DocType(Type type, float f2, Variant variant) {
        this.type = type;
        this.version = f2;
        this.variant = variant;
    }

    public void parseDocType(String string) {
        String string2;
        int n2;
        if (string == null) {
            this.type = Type.quirks;
            this.version = 3.2f;
            this.variant = Variant.Transitional;
            return;
        }
        int n3 = string.indexOf("-//W3C//DTD ");
        if (n3 > 0 && (n2 = string.indexOf("//", n3 += 12)) > 0 && (n3 = (string2 = string.substring(n3, n2).trim()).indexOf(32)) > 0) {
            String string3 = string2.substring(0, n3);
            if (string3.equals("HTML")) {
                this.setType(Type.HTML);
            } else if (string3.equals("XHTML")) {
                this.setType(Type.XHTML);
            } else {
                this.setType(Type.quirks);
                return;
            }
            string2 = string2.substring(n3).trim();
            n3 = string2.indexOf(32);
            if (n3 < 0) {
                n3 = string2.length();
            }
            try {
                this.setVersion(Float.parseFloat(string2.substring(0, n3)));
            }
            catch (Throwable throwable) {
                this.setType(Type.quirks);
                return;
            }
            string2 = string2.substring(n3).trim();
            if (string2.length() == 0) {
                this.setVariant(this.version >= 2.0f && this.version < 4.0f ? Variant.Transitional : Variant.Strict);
            } else if (string2.equalsIgnoreCase("Frameset")) {
                this.setVariant(Variant.Frameset);
            } else if (string2.equalsIgnoreCase("Strict")) {
                this.setVariant(Variant.Strict);
            } else {
                this.setVariant(Variant.Transitional);
            }
        }
    }

    public String getTypeString() {
        String string = null;
        switch (this.type) {
            case quirks: {
                return null;
            }
            case HTML: {
                if (this.version <= 2.0f) {
                    this.version = 2.0f;
                }
                if (!(this.version >= 4.0f)) break;
                this.version = 4.01f;
                string = "http://www.w3.org/TR/html4/" + (this.variant != Variant.Transitional ? this.variant.name().toLowerCase() : "loose") + ".dtd";
                break;
            }
            case XHTML: {
                if (this.version <= 1.0f) {
                    this.version = 1.0f;
                    string = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-" + this.variant.name().toLowerCase() + ".dtd";
                }
                if (!(this.version > 1.0f)) break;
                this.version = 1.1f;
                string = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(this.type.name()).append(" ").append(VERSION_FORMAT.format(this.version));
        if (this.version >= 4.0f && this.type == Type.HTML || this.version == 1.0f && this.type == Type.XHTML) {
            stringBuilder.append(" ").append(this.variant.name());
        }
        stringBuilder.append("//EN");
        if (string != null) {
            stringBuilder.append("\" \"").append(string);
        }
        stringBuilder.append(SUFFIX);
        return stringBuilder.toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float f2) {
        this.version = f2;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant variant) {
        this.variant = variant;
    }

    public boolean isHTML4OrHigher() {
        return this.type == Type.XHTML || this.type == Type.HTML && this.version >= 4.0f;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        VERSION_FORMAT = new DecimalFormat("0.0#", decimalFormatSymbols);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        quirks,
        HTML,
        XHTML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variant {
        Transitional,
        Strict,
        Frameset;

    }
}

