/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import javax.swing.text.ChangedCharSetException;

public class PushReader
extends BufferedReader {
    public static final String TOKEN_COMMENT = "!--";
    private static final Hashtable<String, Character> HTML_CHARS = new Hashtable();
    private StringBuilder stack = new StringBuilder();
    private StringBuilder rollback = new StringBuilder();
    private boolean transactionActive = false;
    private boolean isShutdown = false;

    public PushReader(Reader reader) {
        super(reader);
    }

    private static void putNamedChar(String string, int n2) {
        HTML_CHARS.put(string, new Character((char)n2));
    }

    public int read() throws IOException {
        int n2;
        if (this.isShutdown) {
            return -1;
        }
        if (this.stack.length() > 0) {
            char c2 = this.stack.charAt(this.stack.length() - 1);
            this.stack.setLength(this.stack.length() - 1);
            n2 = c2;
        } else {
            n2 = super.read();
        }
        if (this.transactionActive && n2 != -1) {
            this.rollback.append((char)n2);
        }
        return n2;
    }

    public void push(char c2) {
        this.stack.append(c2);
        if (this.transactionActive && this.rollback.length() > 0) {
            this.rollback.setLength(this.rollback.length() - 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char readQuotedChar() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        try {
            block13: while (true) {
                int n3;
                if ((n3 = this.read()) != -1) {
                    stringBuilder2.append((char)n3);
                }
                switch (n3) {
                    case -1: {
                        break block13;
                    }
                    case 59: {
                        break block13;
                    }
                    case 120: {
                        if (n2 == 1 && stringBuilder.length() == 0) {
                            n2 = 2;
                            continue block13;
                        }
                    }
                    case 35: {
                        if (n2 == 0 && stringBuilder.length() == 0) {
                            n2 = 1;
                            continue block13;
                        }
                    }
                    default: {
                        stringBuilder.append((char)n3);
                        continue block13;
                    }
                }
                break;
            }
            String string = stringBuilder.toString();
            switch (n2) {
                case 0: {
                    Character c2 = HTML_CHARS.get(string);
                    if (c2 != null) {
                        return c2.charValue();
                    }
                    break;
                }
                case 1: {
                    return (char)Integer.parseInt(string);
                }
                case 2: {
                    return (char)Integer.parseInt(string, 16);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.transactionActive && this.rollback.length() >= stringBuilder2.length()) {
            this.rollback.setLength(this.rollback.length() - stringBuilder2.length());
        }
        this.stack.append((CharSequence)stringBuilder2.reverse());
        return '&';
    }

    public void checkForUtf8Prefix() throws IOException, ChangedCharSetException {
        int n2 = this.read();
        if (n2 == 239) {
            int n3 = this.read();
            if (n3 == 187) {
                int n4 = this.read();
                if (n4 == 191) {
                    throw new ChangedCharSetException("utf8", true);
                }
                this.push((char)n4);
            }
            this.push((char)n3);
        }
        if (n2 != -1) {
            this.push((char)n2);
        }
    }

    public void startTransaction() {
        this.transactionActive = true;
        if (this.rollback.length() > 0) {
            this.rollback.setLength(0);
        }
    }

    public void rollBack() {
        if (this.transactionActive) {
            this.stack.append((CharSequence)this.rollback.reverse());
        }
        this.commit();
    }

    public void commit() {
        this.rollback.setLength(0);
        this.transactionActive = false;
    }

    public void shutDown() throws IOException {
        this.isShutdown = true;
        this.close();
    }

    public String readKey() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block9: while (true) {
            int n2 = this.read();
            switch (n2) {
                case -1: {
                    return null;
                }
                case 60: {
                    if (!(bl3 || stringBuilder.length() >= 3 && stringBuilder.substring(0, 3).equals(TOKEN_COMMENT))) {
                        return null;
                    }
                }
                case 47: 
                case 61: 
                case 62: {
                    this.push((char)n2);
                    return stringBuilder.toString();
                }
                case 33: {
                    if (stringBuilder.length() == 0) {
                        bl2 = true;
                    }
                    stringBuilder.append((char)n2);
                    continue block9;
                }
                case 91: {
                    if (stringBuilder.length() == 1) {
                        bl3 = true;
                    }
                    stringBuilder.append((char)n2);
                    continue block9;
                }
                case 93: {
                    if (bl2 && bl3) {
                        bl4 = true;
                    }
                    stringBuilder.append((char)n2);
                    continue block9;
                }
                case 45: {
                    if (!bl2 || stringBuilder.length() != 2 || stringBuilder.charAt(1) != '-') break;
                    return TOKEN_COMMENT;
                }
            }
            if (Character.isWhitespace(n2)) {
                if (stringBuilder.length() <= 0) continue;
                if (!bl2 || !bl3 || bl4) {
                    this.push((char)n2);
                    return stringBuilder.toString();
                }
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append((char)n2);
        }
    }

    public String readValue() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 32;
        block6: while (true) {
            int n3 = this.read();
            switch (n3) {
                case 62: {
                    if (n2 == 32) {
                        this.push('>');
                        return stringBuilder.toString();
                    }
                    stringBuilder.append((char)n3);
                    continue block6;
                }
                case -1: {
                    return stringBuilder.toString();
                }
                case 34: 
                case 39: {
                    if (n2 == n3) {
                        return stringBuilder.toString();
                    }
                    if (n2 == 32) {
                        n2 = n3;
                        continue block6;
                    }
                    stringBuilder.append((char)n3);
                    continue block6;
                }
                case 38: {
                    stringBuilder.append(this.readQuotedChar());
                    continue block6;
                }
            }
            if (n2 == 32 && Character.isWhitespace(n3)) {
                if (stringBuilder.length() <= 0) continue;
                return stringBuilder.toString();
            }
            stringBuilder.append((char)n3);
        }
    }

    public void skipScript() throws IOException {
        int n2 = 0;
        int n3 = 0;
        block9: while (true) {
            int n4 = this.read();
            switch (n4) {
                case -1: {
                    return;
                }
                case 60: {
                    if (n2 != 0 || n3 >= 2) continue block9;
                    char c2 = (char)this.read();
                    if (c2 != '/') continue block9;
                    this.push(c2);
                    this.push('<');
                    return;
                }
                case 10: {
                    if (n3 != true) break;
                    n3 = 0;
                    break;
                }
                case 42: {
                    if (n3 != 2) break;
                    char c2 = (char)this.read();
                    if (c2 != '/') continue block9;
                    n3 = 0;
                    break;
                }
                case 47: {
                    if (n2 != 0) break;
                    char c2 = (char)this.read();
                    if (c2 == '/') {
                        n3 = 1;
                        break;
                    }
                    if (c2 != '*') continue block9;
                    n3 = 2;
                    break;
                }
                case 92: {
                    if (n2 == 0) break;
                    this.read();
                    break;
                }
                case 34: 
                case 39: {
                    if (n3 != 0) break;
                    if (n2 == n4) {
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) break;
                    n2 = n4;
                }
            }
        }
    }

    public boolean skipTag() throws IOException {
        while (true) {
            int n2 = this.read();
            switch (n2) {
                case -1: 
                case 62: {
                    return true;
                }
                case 60: {
                    return false;
                }
            }
        }
    }

    public String skipComment() throws IOException {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        block5: while (true) {
            int n3 = this.read();
            stringBuilder.append((char)n3);
            switch (n3) {
                case -1: {
                    break block5;
                }
                case 62: {
                    if (n2 >= 2) {
                        return stringBuilder.toString();
                    }
                    n2 = 0;
                    continue block5;
                }
                case 45: {
                    ++n2;
                    continue block5;
                }
                default: {
                    n2 = 0;
                    continue block5;
                }
            }
            break;
        }
        return stringBuilder.toString();
    }

    static {
        PushReader.putNamedChar("quot", 34);
        PushReader.putNamedChar("amp", 38);
        PushReader.putNamedChar("lt", 60);
        PushReader.putNamedChar("gt", 62);
        PushReader.putNamedChar("nbsp", 160);
        PushReader.putNamedChar("iexcl", 161);
        PushReader.putNamedChar("cent", 162);
        PushReader.putNamedChar("pound", 163);
        PushReader.putNamedChar("curren", 164);
        PushReader.putNamedChar("yen", 165);
        PushReader.putNamedChar("brvbar", 166);
        PushReader.putNamedChar("sect", 167);
        PushReader.putNamedChar("uml", 168);
        PushReader.putNamedChar("copy", 169);
        PushReader.putNamedChar("ordf", 170);
        PushReader.putNamedChar("laquo", 171);
        PushReader.putNamedChar("not", 172);
        PushReader.putNamedChar("shy", 173);
        PushReader.putNamedChar("reg", 174);
        PushReader.putNamedChar("macr", 175);
        PushReader.putNamedChar("deg", 176);
        PushReader.putNamedChar("plusmn", 177);
        PushReader.putNamedChar("sup2", 178);
        PushReader.putNamedChar("sup3", 179);
        PushReader.putNamedChar("acute", 180);
        PushReader.putNamedChar("micro", 181);
        PushReader.putNamedChar("para", 182);
        PushReader.putNamedChar("middot", 183);
        PushReader.putNamedChar("cedil", 184);
        PushReader.putNamedChar("sup1", 185);
        PushReader.putNamedChar("ordm", 186);
        PushReader.putNamedChar("raquo", 187);
        PushReader.putNamedChar("frac14", 188);
        PushReader.putNamedChar("frac12", 189);
        PushReader.putNamedChar("frac34", 190);
        PushReader.putNamedChar("iquest", 191);
        PushReader.putNamedChar("Agrave", 192);
        PushReader.putNamedChar("Aacute", 193);
        PushReader.putNamedChar("Acirc", 194);
        PushReader.putNamedChar("Atilde", 195);
        PushReader.putNamedChar("Auml", 196);
        PushReader.putNamedChar("Aring", 197);
        PushReader.putNamedChar("AElig", 198);
        PushReader.putNamedChar("Ccedil", 199);
        PushReader.putNamedChar("Egrave", 200);
        PushReader.putNamedChar("Eacute", 201);
        PushReader.putNamedChar("Ecirc", 202);
        PushReader.putNamedChar("Euml", 203);
        PushReader.putNamedChar("Igrave", 204);
        PushReader.putNamedChar("Iacute", 205);
        PushReader.putNamedChar("Icirc", 206);
        PushReader.putNamedChar("Iuml", 207);
        PushReader.putNamedChar("ETH", 208);
        PushReader.putNamedChar("Ntilde", 209);
        PushReader.putNamedChar("Ograve", 210);
        PushReader.putNamedChar("Oacute", 211);
        PushReader.putNamedChar("Ocirc", 212);
        PushReader.putNamedChar("Otilde", 213);
        PushReader.putNamedChar("Ouml", 214);
        PushReader.putNamedChar("times", 215);
        PushReader.putNamedChar("Oslash", 216);
        PushReader.putNamedChar("Ugrave", 217);
        PushReader.putNamedChar("Uacute", 218);
        PushReader.putNamedChar("Ucirc", 219);
        PushReader.putNamedChar("Uuml", 220);
        PushReader.putNamedChar("Yacute", 221);
        PushReader.putNamedChar("THORN", 222);
        PushReader.putNamedChar("szlig", 223);
        PushReader.putNamedChar("agrave", 224);
        PushReader.putNamedChar("aacute", 225);
        PushReader.putNamedChar("acirc", 226);
        PushReader.putNamedChar("atilde", 227);
        PushReader.putNamedChar("auml", 228);
        PushReader.putNamedChar("aring", 229);
        PushReader.putNamedChar("aelig", 230);
        PushReader.putNamedChar("ccedil", 231);
        PushReader.putNamedChar("egrave", 232);
        PushReader.putNamedChar("eacute", 233);
        PushReader.putNamedChar("ecirc", 234);
        PushReader.putNamedChar("euml", 235);
        PushReader.putNamedChar("igrave", 236);
        PushReader.putNamedChar("iacute", 237);
        PushReader.putNamedChar("icirc", 238);
        PushReader.putNamedChar("iuml", 239);
        PushReader.putNamedChar("eth", 240);
        PushReader.putNamedChar("ntilde", 241);
        PushReader.putNamedChar("ograve", 242);
        PushReader.putNamedChar("oacute", 243);
        PushReader.putNamedChar("ocirc", 244);
        PushReader.putNamedChar("otilde", 245);
        PushReader.putNamedChar("ouml", 246);
        PushReader.putNamedChar("divide", 247);
        PushReader.putNamedChar("oslash", 248);
        PushReader.putNamedChar("ugrave", 249);
        PushReader.putNamedChar("uacute", 250);
        PushReader.putNamedChar("ucirc", 251);
        PushReader.putNamedChar("uuml", 252);
        PushReader.putNamedChar("yacute", 253);
        PushReader.putNamedChar("thorn", 254);
        PushReader.putNamedChar("yuml", 255);
        PushReader.putNamedChar("OElig", 338);
        PushReader.putNamedChar("oelig", 339);
        PushReader.putNamedChar("Scaron", 352);
        PushReader.putNamedChar("scaron", 353);
        PushReader.putNamedChar("Yuml", 376);
        PushReader.putNamedChar("fnof", 402);
        PushReader.putNamedChar("Alpha", 913);
        PushReader.putNamedChar("alpha", 945);
        PushReader.putNamedChar("Beta", 914);
        PushReader.putNamedChar("beta", 946);
        PushReader.putNamedChar("Gamma", 915);
        PushReader.putNamedChar("gamma", 947);
        PushReader.putNamedChar("Delta", 916);
        PushReader.putNamedChar("delta", 948);
        PushReader.putNamedChar("Epsilon", 917);
        PushReader.putNamedChar("epsilon", 949);
        PushReader.putNamedChar("Zeta", 918);
        PushReader.putNamedChar("zeta", 950);
        PushReader.putNamedChar("Eta", 919);
        PushReader.putNamedChar("eta", 951);
        PushReader.putNamedChar("Theta", 920);
        PushReader.putNamedChar("theta", 952);
        PushReader.putNamedChar("Iota", 921);
        PushReader.putNamedChar("iota", 953);
        PushReader.putNamedChar("Kappa", 922);
        PushReader.putNamedChar("kappa", 954);
        PushReader.putNamedChar("Lambda", 923);
        PushReader.putNamedChar("lambda", 955);
        PushReader.putNamedChar("Mu", 924);
        PushReader.putNamedChar("mu", 956);
        PushReader.putNamedChar("Nu", 925);
        PushReader.putNamedChar("nu", 957);
        PushReader.putNamedChar("Xi", 926);
        PushReader.putNamedChar("xi", 958);
        PushReader.putNamedChar("Omicron", 927);
        PushReader.putNamedChar("omicron", 959);
        PushReader.putNamedChar("Pi", 928);
        PushReader.putNamedChar("pi", 960);
        PushReader.putNamedChar("Rho", 929);
        PushReader.putNamedChar("rho", 961);
        PushReader.putNamedChar("Sigma", 931);
        PushReader.putNamedChar("sigmaf", 962);
        PushReader.putNamedChar("sigma", 963);
        PushReader.putNamedChar("Tau", 932);
        PushReader.putNamedChar("tau", 964);
        PushReader.putNamedChar("Upsilon", 933);
        PushReader.putNamedChar("upsilon", 965);
        PushReader.putNamedChar("Phi", 934);
        PushReader.putNamedChar("phi", 966);
        PushReader.putNamedChar("Chi", 935);
        PushReader.putNamedChar("chi", 967);
        PushReader.putNamedChar("Psi", 936);
        PushReader.putNamedChar("psi", 968);
        PushReader.putNamedChar("Omega", 937);
        PushReader.putNamedChar("omega", 969);
        PushReader.putNamedChar("thetasym", 977);
        PushReader.putNamedChar("upsih", 978);
        PushReader.putNamedChar("piv", 982);
        PushReader.putNamedChar("forall", 8704);
        PushReader.putNamedChar("part", 8706);
        PushReader.putNamedChar("exist", 8707);
        PushReader.putNamedChar("empty", 8709);
        PushReader.putNamedChar("nabla", 8711);
        PushReader.putNamedChar("isin", 8712);
        PushReader.putNamedChar("notin", 8713);
        PushReader.putNamedChar("ni", 8715);
        PushReader.putNamedChar("prod", 8719);
        PushReader.putNamedChar("sum", 8721);
        PushReader.putNamedChar("minus", 8722);
        PushReader.putNamedChar("lowast", 8727);
        PushReader.putNamedChar("radic", 8730);
        PushReader.putNamedChar("prop", 8733);
        PushReader.putNamedChar("infin", 8734);
        PushReader.putNamedChar("ang", 8736);
        PushReader.putNamedChar("and", 8869);
        PushReader.putNamedChar("or", 8870);
        PushReader.putNamedChar("cap", 8745);
        PushReader.putNamedChar("cup", 8746);
        PushReader.putNamedChar("int", 8747);
        PushReader.putNamedChar("there4", 8756);
        PushReader.putNamedChar("sim", 8764);
        PushReader.putNamedChar("cong", 8773);
        PushReader.putNamedChar("asymp", 8776);
        PushReader.putNamedChar("ne", 8800);
        PushReader.putNamedChar("equiv", 8801);
        PushReader.putNamedChar("le", 8804);
        PushReader.putNamedChar("ge", 8805);
        PushReader.putNamedChar("sub", 8834);
        PushReader.putNamedChar("sup", 8835);
        PushReader.putNamedChar("nsub", 8836);
        PushReader.putNamedChar("sube", 8838);
        PushReader.putNamedChar("supe", 8839);
        PushReader.putNamedChar("oplus", 8853);
        PushReader.putNamedChar("otimes", 8855);
        PushReader.putNamedChar("perp", 8869);
        PushReader.putNamedChar("sdot", 8901);
        PushReader.putNamedChar("loz", 9674);
        PushReader.putNamedChar("lceil", 8968);
        PushReader.putNamedChar("rceil", 8969);
        PushReader.putNamedChar("lfloor", 8970);
        PushReader.putNamedChar("rfloor", 8971);
        PushReader.putNamedChar("lang", 9001);
        PushReader.putNamedChar("rang", 9002);
        PushReader.putNamedChar("larr", 8592);
        PushReader.putNamedChar("uarr", 8593);
        PushReader.putNamedChar("rarr", 8594);
        PushReader.putNamedChar("darr", 8595);
        PushReader.putNamedChar("harr", 8596);
        PushReader.putNamedChar("crarr", 8629);
        PushReader.putNamedChar("lArr", 8656);
        PushReader.putNamedChar("uArr", 8657);
        PushReader.putNamedChar("rArr", 8658);
        PushReader.putNamedChar("dArr", 8659);
        PushReader.putNamedChar("hArr", 8660);
        PushReader.putNamedChar("bull", 8226);
        PushReader.putNamedChar("hellip", 8230);
        PushReader.putNamedChar("prime", 8242);
        PushReader.putNamedChar("oline", 8254);
        PushReader.putNamedChar("frasl", 8260);
        PushReader.putNamedChar("weierp", 8472);
        PushReader.putNamedChar("image", 8465);
        PushReader.putNamedChar("real", 8476);
        PushReader.putNamedChar("trade", 8482);
        PushReader.putNamedChar("euro", 8364);
        PushReader.putNamedChar("alefsym", 8501);
        PushReader.putNamedChar("spades", 9824);
        PushReader.putNamedChar("clubs", 9827);
        PushReader.putNamedChar("hearts", 9829);
        PushReader.putNamedChar("diams", 9830);
        PushReader.putNamedChar("ensp", 8194);
        PushReader.putNamedChar("emsp", 8195);
        PushReader.putNamedChar("thinsp", 8201);
        PushReader.putNamedChar("zwnj", 8204);
        PushReader.putNamedChar("zwj", 8205);
        PushReader.putNamedChar("lrm", 8206);
        PushReader.putNamedChar("rlm", 8207);
        PushReader.putNamedChar("ndash", 8211);
        PushReader.putNamedChar("mdash", 8212);
        PushReader.putNamedChar("lsquo", 8216);
        PushReader.putNamedChar("rsquo", 8217);
        PushReader.putNamedChar("sbquo", 8218);
        PushReader.putNamedChar("ldquo", 8220);
        PushReader.putNamedChar("rdquo", 8221);
        PushReader.putNamedChar("bdquo", 8222);
        PushReader.putNamedChar("dagger", 8224);
        PushReader.putNamedChar("Dagger", 8225);
        PushReader.putNamedChar("permil", 8240);
        PushReader.putNamedChar("lsaquo", 8249);
        PushReader.putNamedChar("rsaquo", 8250);
        PushReader.putNamedChar("circ", 710);
        PushReader.putNamedChar("tilde", 732);
    }
}

