/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;

public class BorderStyleValue
extends SingleAttributeValue {
    public static final int NONE = 0;
    public static final int INSET = 1;
    public static final int GROOVE = 2;
    public static final int OUTSET = 3;
    public static final int RIDGE = 4;
    public static final int DOTTED = 5;
    public static final int DASHED = 6;
    public static final int SOLID = 7;
    public static final int DOUBLE = 8;
    public static final int HIDDEN = 9;
    public static final int LNF_DEFAULT = 10;
    private int style;
    private static final Hashtable<String, BorderStyleValue> MAP = new Hashtable();
    static final BorderStyleValue PARSER;

    public BorderStyleValue(String string, int n2) {
        this.style = n2;
        this.setString(string);
    }

    private BorderStyleValue() {
    }

    private static void factory(String string, int n2) {
        BorderStyleValue borderStyleValue = new BorderStyleValue();
        borderStyleValue.style = n2;
        borderStyleValue.setString(string);
        MAP.put(string, borderStyleValue);
    }

    public int getStyle() {
        return this.style;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equalsIgnoreCase(string)) {
            return AttributeValue.INHERIT;
        }
        return MAP.get(string != null ? string.toLowerCase() : null);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BorderStyleValue)) {
            return false;
        }
        BorderStyleValue borderStyleValue = (BorderStyleValue)object;
        if (this.isImportant() != borderStyleValue.isImportant()) {
            return false;
        }
        return this.style == borderStyleValue.style;
    }

    static {
        BorderStyleValue.factory("none", 0);
        BorderStyleValue.factory("hidden", 9);
        BorderStyleValue.factory("dotted", 5);
        BorderStyleValue.factory("dashed", 6);
        BorderStyleValue.factory("solid", 7);
        BorderStyleValue.factory("double", 8);
        BorderStyleValue.factory("groove", 2);
        BorderStyleValue.factory("ridge", 4);
        BorderStyleValue.factory("inset", 1);
        BorderStyleValue.factory("outset", 3);
        BorderStyleValue.factory("lnfdefault", 10);
        PARSER = MAP.get("none");
    }
}

