/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Hashtable;

public class ColorValue
extends HtmlAttribute {
    private static final Hashtable<String, Color> MAP = new Hashtable();
    private Color color;
    static final ColorValue PARSER;

    private ColorValue() {
    }

    public ColorValue(Color color) {
        this.color = color;
        this.setString("rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
    }

    public AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        return this.parseValue(string, false);
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equalsIgnoreCase(string)) {
            return AttributeValue.INHERIT;
        }
        return this.parseValue(string, true);
    }

    private AttributeValue parseValue(String string, boolean bl2) {
        Color color = this.parseColorString(string, bl2);
        if (color == null) {
            return null;
        }
        ColorValue colorValue = new ColorValue();
        colorValue.color = color;
        colorValue.setString(string);
        return colorValue;
    }

    public Color getValue() {
        return this.color;
    }

    private Color parseColorString(String string, boolean bl2) {
        if (string.charAt(0) == '#') {
            return this.parseHexColor(string);
        }
        if ((string = string.toLowerCase()).startsWith("rgb")) {
            return ColorValue.parseRgb(string);
        }
        Color color = MAP.get(string);
        if (color != null) {
            return color;
        }
        return this.parseHexColor(string);
    }

    private final Color parseHexColor(String string) {
        if (string.startsWith("#")) {
            string = string.substring(1, Math.min(string.length(), 7));
        }
        try {
            int n2 = Integer.parseInt(string, 16);
            if (string.length() == 3) {
                int n3 = n2 >> 8 & 0xF;
                int n4 = n2 >> 4 & 0xF;
                int n5 = n2 & 0xF;
                return new Color(n3 + (n3 << 4), n4 + (n4 << 4), n5 + (n5 << 4));
            }
            return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static Color parseRgb(String string) {
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (n2 < 0 || n3 < 0 || n2 > n3) {
            return null;
        }
        String[] stringArray = (string = string.substring(n2 + 1, n3)).split(",");
        if (stringArray.length != 3) {
            return null;
        }
        int n4 = ColorValue.parseRgbDigit(stringArray[0]);
        int n5 = ColorValue.parseRgbDigit(stringArray[1]);
        int n6 = ColorValue.parseRgbDigit(stringArray[2]);
        return new Color(n4, n5, n6);
    }

    private static int parseRgbDigit(String string) {
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return 0;
        }
        try {
            if (string.charAt(n2 - 1) == '%') {
                string = string.substring(0, n2 - 1);
                return (int)(Double.parseDouble(string) * 2.55);
            }
            return (int)Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ColorValue) {
            ColorValue colorValue = (ColorValue)object;
            if (!colorValue.getValue().equals(this.getValue())) {
                return false;
            }
            return colorValue.isImportant() == this.isImportant();
        }
        return false;
    }

    public boolean isTransparent() {
        return this.color == null || this.color.getAlpha() == 0;
    }

    static {
        MAP.put("black", Color.BLACK);
        MAP.put("blue", Color.BLUE);
        MAP.put("red", Color.RED);
        MAP.put("yellow", Color.YELLOW);
        MAP.put("green", new Color(0, 128, 0));
        MAP.put("gray", Color.GRAY);
        MAP.put("white", Color.WHITE);
        MAP.put("silver", Color.LIGHT_GRAY);
        MAP.put("aqua", Color.CYAN);
        MAP.put("fuchsia", Color.MAGENTA);
        MAP.put("lime", Color.GREEN);
        MAP.put("maroon", new Color(128, 0, 0));
        MAP.put("purple", new Color(128, 0, 128));
        MAP.put("olive", new Color(128, 128, 0));
        MAP.put("navy", new Color(0, 0, 128));
        MAP.put("teal", new Color(0, 128, 128));
        MAP.put("IndianRed".toLowerCase(), new Color(205, 92, 92));
        MAP.put("LightCoral".toLowerCase(), new Color(240, 128, 128));
        MAP.put("Salmon".toLowerCase(), new Color(250, 128, 114));
        MAP.put("DarkSalmon".toLowerCase(), new Color(233, 150, 122));
        MAP.put("LightSalmon".toLowerCase(), new Color(255, 160, 122));
        MAP.put("Red".toLowerCase(), new Color(255, 0, 0));
        MAP.put("Crimson".toLowerCase(), new Color(220, 20, 60));
        MAP.put("FireBrick".toLowerCase(), new Color(178, 34, 34));
        MAP.put("DarkRed".toLowerCase(), new Color(139, 0, 0));
        MAP.put("Pink".toLowerCase(), new Color(255, 192, 203));
        MAP.put("LightPink".toLowerCase(), new Color(255, 182, 193));
        MAP.put("HotPink".toLowerCase(), new Color(255, 105, 180));
        MAP.put("DeepPink".toLowerCase(), new Color(255, 20, 147));
        MAP.put("MediumVioletRed".toLowerCase(), new Color(199, 21, 133));
        MAP.put("PaleVioletRed".toLowerCase(), new Color(219, 112, 147));
        MAP.put("LightSalmon".toLowerCase(), new Color(255, 160, 122));
        MAP.put("Coral".toLowerCase(), new Color(255, 127, 80));
        MAP.put("Tomato".toLowerCase(), new Color(255, 99, 71));
        MAP.put("OrangeRed".toLowerCase(), new Color(255, 69, 0));
        MAP.put("DarkOrange".toLowerCase(), new Color(255, 140, 0));
        MAP.put("Orange".toLowerCase(), new Color(255, 165, 0));
        MAP.put("Gold".toLowerCase(), new Color(255, 215, 0));
        MAP.put("Yellow".toLowerCase(), new Color(255, 255, 0));
        MAP.put("LightYellow".toLowerCase(), new Color(255, 255, 224));
        MAP.put("LemonChiffon".toLowerCase(), new Color(255, 250, 205));
        MAP.put("LightGoldenrodYellow".toLowerCase(), new Color(250, 250, 210));
        MAP.put("PapayaWhip".toLowerCase(), new Color(255, 239, 213));
        MAP.put("Moccasin".toLowerCase(), new Color(255, 228, 181));
        MAP.put("PeachPuff".toLowerCase(), new Color(255, 218, 185));
        MAP.put("PaleGoldenrod".toLowerCase(), new Color(238, 232, 170));
        MAP.put("Khaki".toLowerCase(), new Color(240, 230, 140));
        MAP.put("DarkKhaki".toLowerCase(), new Color(189, 183, 107));
        MAP.put("Lavender".toLowerCase(), new Color(230, 230, 250));
        MAP.put("Thistle".toLowerCase(), new Color(216, 191, 216));
        MAP.put("Plum".toLowerCase(), new Color(221, 160, 221));
        MAP.put("Violet".toLowerCase(), new Color(238, 130, 238));
        MAP.put("Orchid".toLowerCase(), new Color(218, 112, 214));
        MAP.put("Fuchsia".toLowerCase(), new Color(255, 0, 255));
        MAP.put("Magenta".toLowerCase(), new Color(255, 0, 255));
        MAP.put("MediumOrchid".toLowerCase(), new Color(186, 85, 211));
        MAP.put("MediumPurple".toLowerCase(), new Color(147, 112, 219));
        MAP.put("BlueViolet".toLowerCase(), new Color(138, 43, 226));
        MAP.put("DarkViolet".toLowerCase(), new Color(148, 0, 211));
        MAP.put("DarkOrchid".toLowerCase(), new Color(153, 50, 204));
        MAP.put("DarkMagenta".toLowerCase(), new Color(139, 0, 139));
        MAP.put("Purple".toLowerCase(), new Color(128, 0, 128));
        MAP.put("Indigo".toLowerCase(), new Color(75, 0, 130));
        MAP.put("DarkSlateBlue".toLowerCase(), new Color(72, 61, 139));
        MAP.put("SlateBlue".toLowerCase(), new Color(106, 90, 205));
        MAP.put("MediumSlateBlue".toLowerCase(), new Color(123, 104, 238));
        MAP.put("GreenYellow".toLowerCase(), new Color(173, 255, 47));
        MAP.put("Chartreuse".toLowerCase(), new Color(127, 255, 0));
        MAP.put("LawnGreen".toLowerCase(), new Color(124, 252, 0));
        MAP.put("Lime".toLowerCase(), new Color(0, 255, 0));
        MAP.put("LimeGreen".toLowerCase(), new Color(50, 205, 50));
        MAP.put("PaleGreen".toLowerCase(), new Color(152, 251, 152));
        MAP.put("LightGreen".toLowerCase(), new Color(144, 238, 144));
        MAP.put("MediumSpringGreen".toLowerCase(), new Color(0, 250, 154));
        MAP.put("SpringGreen".toLowerCase(), new Color(0, 255, 127));
        MAP.put("MediumSeaGreen".toLowerCase(), new Color(60, 179, 113));
        MAP.put("SeaGreen".toLowerCase(), new Color(46, 139, 87));
        MAP.put("ForestGreen".toLowerCase(), new Color(34, 139, 34));
        MAP.put("Green".toLowerCase(), new Color(0, 128, 0));
        MAP.put("DarkGreen".toLowerCase(), new Color(0, 100, 0));
        MAP.put("YellowGreen".toLowerCase(), new Color(154, 205, 50));
        MAP.put("OliveDrab".toLowerCase(), new Color(107, 142, 35));
        MAP.put("Olive".toLowerCase(), new Color(128, 128, 0));
        MAP.put("DarkOliveGreen".toLowerCase(), new Color(85, 107, 47));
        MAP.put("MediumAquamarine".toLowerCase(), new Color(102, 205, 170));
        MAP.put("DarkSeaGreen".toLowerCase(), new Color(143, 188, 143));
        MAP.put("LightSeaGreen".toLowerCase(), new Color(32, 178, 170));
        MAP.put("DarkCyan".toLowerCase(), new Color(0, 139, 139));
        MAP.put("Teal".toLowerCase(), new Color(0, 128, 128));
        MAP.put("Aqua".toLowerCase(), new Color(0, 255, 255));
        MAP.put("Cyan".toLowerCase(), new Color(0, 255, 255));
        MAP.put("LightCyan".toLowerCase(), new Color(224, 255, 255));
        MAP.put("PaleTurquoise".toLowerCase(), new Color(175, 238, 238));
        MAP.put("Aquamarine".toLowerCase(), new Color(127, 255, 212));
        MAP.put("Turquoise".toLowerCase(), new Color(64, 224, 208));
        MAP.put("MediumTurquoise".toLowerCase(), new Color(72, 209, 204));
        MAP.put("DarkTurquoise".toLowerCase(), new Color(0, 206, 209));
        MAP.put("CadetBlue".toLowerCase(), new Color(95, 158, 160));
        MAP.put("SteelBlue".toLowerCase(), new Color(70, 130, 180));
        MAP.put("LightSteelBlue".toLowerCase(), new Color(176, 196, 222));
        MAP.put("PowderBlue".toLowerCase(), new Color(176, 224, 230));
        MAP.put("LightBlue".toLowerCase(), new Color(173, 216, 230));
        MAP.put("SkyBlue".toLowerCase(), new Color(135, 206, 235));
        MAP.put("LightSkyBlue".toLowerCase(), new Color(135, 206, 250));
        MAP.put("DeepSkyBlue".toLowerCase(), new Color(0, 191, 255));
        MAP.put("DodgerBlue".toLowerCase(), new Color(30, 144, 255));
        MAP.put("CornflowerBlue".toLowerCase(), new Color(100, 149, 237));
        MAP.put("RoyalBlue".toLowerCase(), new Color(65, 105, 225));
        MAP.put("Blue".toLowerCase(), new Color(0, 0, 255));
        MAP.put("MediumBlue".toLowerCase(), new Color(0, 0, 205));
        MAP.put("DarkBlue".toLowerCase(), new Color(0, 0, 139));
        MAP.put("Navy".toLowerCase(), new Color(0, 0, 128));
        MAP.put("MidnightBlue".toLowerCase(), new Color(25, 25, 112));
        MAP.put("Cornsilk".toLowerCase(), new Color(255, 248, 220));
        MAP.put("BlanchedAlmond".toLowerCase(), new Color(255, 235, 205));
        MAP.put("Bisque".toLowerCase(), new Color(255, 228, 196));
        MAP.put("NavajoWhite".toLowerCase(), new Color(255, 222, 173));
        MAP.put("Wheat".toLowerCase(), new Color(245, 222, 179));
        MAP.put("BurlyWood".toLowerCase(), new Color(222, 184, 135));
        MAP.put("Tan".toLowerCase(), new Color(210, 180, 140));
        MAP.put("RosyBrown".toLowerCase(), new Color(188, 143, 143));
        MAP.put("SandyBrown".toLowerCase(), new Color(244, 164, 96));
        MAP.put("Goldenrod".toLowerCase(), new Color(218, 165, 32));
        MAP.put("DarkGoldenrod".toLowerCase(), new Color(184, 134, 11));
        MAP.put("Peru".toLowerCase(), new Color(205, 133, 63));
        MAP.put("Chocolate".toLowerCase(), new Color(210, 105, 30));
        MAP.put("SaddleBrown".toLowerCase(), new Color(139, 69, 19));
        MAP.put("Sienna".toLowerCase(), new Color(160, 82, 45));
        MAP.put("Brown".toLowerCase(), new Color(165, 42, 42));
        MAP.put("Maroon".toLowerCase(), new Color(128, 0, 0));
        MAP.put("White".toLowerCase(), new Color(255, 255, 255));
        MAP.put("Snow".toLowerCase(), new Color(255, 250, 250));
        MAP.put("Honeydew".toLowerCase(), new Color(240, 255, 240));
        MAP.put("MintCream".toLowerCase(), new Color(245, 255, 250));
        MAP.put("Azure".toLowerCase(), new Color(240, 255, 255));
        MAP.put("AliceBlue".toLowerCase(), new Color(240, 248, 255));
        MAP.put("GhostWhite".toLowerCase(), new Color(248, 248, 255));
        MAP.put("WhiteSmoke".toLowerCase(), new Color(245, 245, 245));
        MAP.put("Seashell".toLowerCase(), new Color(255, 245, 238));
        MAP.put("Beige".toLowerCase(), new Color(245, 245, 220));
        MAP.put("OldLace".toLowerCase(), new Color(253, 245, 230));
        MAP.put("FloralWhite".toLowerCase(), new Color(255, 250, 240));
        MAP.put("Ivory".toLowerCase(), new Color(255, 255, 240));
        MAP.put("AntiqueWhite".toLowerCase(), new Color(250, 235, 215));
        MAP.put("Linen".toLowerCase(), new Color(250, 240, 230));
        MAP.put("LavenderBlush".toLowerCase(), new Color(255, 240, 245));
        MAP.put("MistyRose".toLowerCase(), new Color(255, 228, 225));
        MAP.put("Gainsboro".toLowerCase(), new Color(220, 220, 220));
        MAP.put("LightGrey".toLowerCase(), new Color(211, 211, 211));
        MAP.put("Silver".toLowerCase(), new Color(192, 192, 192));
        MAP.put("DarkGray".toLowerCase(), new Color(169, 169, 169));
        MAP.put("Gray".toLowerCase(), new Color(128, 128, 128));
        MAP.put("DimGray".toLowerCase(), new Color(105, 105, 105));
        MAP.put("LightSlateGray".toLowerCase(), new Color(119, 136, 153));
        MAP.put("SlateGray".toLowerCase(), new Color(112, 128, 144));
        MAP.put("DarkSlateGray".toLowerCase(), new Color(47, 79, 79));
        MAP.put("Black".toLowerCase(), new Color(0, 0, 0));
        MAP.put("orange", new Color(255, 165, 0));
        MAP.put("cyan", Color.CYAN);
        MAP.put("magenta", Color.MAGENTA);
        MAP.put("transparent", new Color(0, true));
        MAP.put("activeborder", SystemColor.activeCaptionBorder);
        MAP.put("activecaption", SystemColor.activeCaption);
        MAP.put("appworkspace", SystemColor.window);
        MAP.put("background", SystemColor.desktop);
        MAP.put("buttonface", SystemColor.control);
        MAP.put("buttonhighlight", SystemColor.controlHighlight);
        MAP.put("buttonshadow", SystemColor.controlShadow);
        MAP.put("buttontext", SystemColor.controlText);
        MAP.put("captiontext", SystemColor.activeCaptionText);
        MAP.put("graytext", SystemColor.textInactiveText);
        MAP.put("highlight", SystemColor.textHighlight);
        MAP.put("highlighttext", SystemColor.textHighlightText);
        MAP.put("inactiveborder", SystemColor.inactiveCaptionBorder);
        MAP.put("inactivecaption", SystemColor.inactiveCaption);
        MAP.put("inactivecaptiontext", SystemColor.inactiveCaptionText);
        MAP.put("infobackground", SystemColor.info);
        MAP.put("infotext", SystemColor.infoText);
        MAP.put("menu", SystemColor.menu);
        MAP.put("menutext", SystemColor.menuText);
        MAP.put("scrollbar", SystemColor.scrollbar);
        MAP.put("threeddarkshadow", SystemColor.controlDkShadow);
        MAP.put("threeddarkface", SystemColor.control);
        MAP.put("threedhighlight", SystemColor.controlHighlight);
        MAP.put("threedlightshadow", SystemColor.controlLtHighlight);
        MAP.put("threedshadow", SystemColor.controlShadow);
        MAP.put("window", SystemColor.window);
        MAP.put("windowframe", SystemColor.windowBorder);
        MAP.put("windowtext", SystemColor.windowText);
        PARSER = new ColorValue();
    }
}

