/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class FontFamily
extends HtmlAttribute {
    private static final HashSet<String> AVAILABLE_FONT_FAMILIY_NAMES;
    private static final HashSet<String> SERIF_FONTS;
    private static final HashSet<String> SANS_SERIF_FONTS;
    private static final HashSet<String> MONOSPACE_FONTS;
    private String family;
    private boolean isSymbolic;
    private static final int START_OF_SYMBOLIC_CHAR_INTERVAL = 61440;

    FontFamily() {
    }

    public FontFamily(String string) {
        this.family = string;
        this.setString(string);
        String string2 = null;
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2].trim();
            if (string3.length() == 0) continue;
            char c2 = string3.charAt(0);
            if (string3.length() > 2 && (c2 == '\'' || c2 == '\"') && c2 == string3.charAt(string3.length() - 1)) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (AVAILABLE_FONT_FAMILIY_NAMES.contains(string3.toLowerCase())) {
                this.setFamily(string3);
                return;
            }
            if (string2 == null) {
                string2 = this.getSymbolicFont(string3);
            }
            if (string2 != null) continue;
            string2 = string3;
        }
        if (string2 != null) {
            this.setFamily(string2);
            return;
        }
    }

    private String getSymbolicFont(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if ("serif".equals(string2)) {
            for (String string3 : SERIF_FONTS) {
                if (!AVAILABLE_FONT_FAMILIY_NAMES.contains(string3)) continue;
                return string3;
            }
            return null;
        }
        if ("sans-serif".equals(string2)) {
            for (String string4 : SANS_SERIF_FONTS) {
                if (!AVAILABLE_FONT_FAMILIY_NAMES.contains(string4)) continue;
                return string4;
            }
            return null;
        }
        if ("monospace".equals(string2)) {
            for (String string5 : MONOSPACE_FONTS) {
                if (!AVAILABLE_FONT_FAMILIY_NAMES.contains(string5)) continue;
                return string5;
            }
            return null;
        }
        return null;
    }

    private void setFamily(String string) {
        this.family = string;
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', '1', '2', '3', '4', '5'};
        this.isSymbolic = false;
        Font font = new Font(string, 0, 1);
        if (font.canDisplayUpTo(cArray, 0, cArray.length) != -1) {
            FontFamily.translateSymbolic(cArray);
            if (font.canDisplayUpTo(cArray, 0, cArray.length) == -1) {
                this.isSymbolic = true;
            }
        }
    }

    public static void translateSymbolic(char[] cArray) {
        if (cArray == null) {
            return;
        }
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = (char)(cArray[i2] | 0xF000);
        }
    }

    public String getFamily() {
        return this.family;
    }

    protected void parseCssValue(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string, boolean bl2) {
        String string2 = null;
        if ("inherit".equalsIgnoreCase(string)) {
            mutableAttributeSet.addAttribute((Object)attribute, AttributeValue.INHERIT);
            return;
        }
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2].trim();
            if (string3.length() == 0) continue;
            char c2 = string3.charAt(0);
            if (string3.length() > 2 && (c2 == '\'' || c2 == '\"') && c2 == string3.charAt(string3.length() - 1)) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (AVAILABLE_FONT_FAMILIY_NAMES.contains(string3.toLowerCase())) {
                FontFamily fontFamily = new FontFamily();
                fontFamily.setFamily(string3);
                fontFamily.setString(string);
                fontFamily.setImportant(bl2);
                mutableAttributeSet.addAttribute((Object)attribute, fontFamily);
                return;
            }
            if (string2 == null) {
                string2 = this.getSymbolicFont(string3);
            }
            if (string2 != null) continue;
            string2 = string3;
        }
        if (string2 != null) {
            FontFamily fontFamily = new FontFamily();
            fontFamily.setFamily(string2);
            fontFamily.setString(string);
            fontFamily.setImportant(bl2);
            mutableAttributeSet.addAttribute((Object)attribute, fontFamily);
            return;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FontFamily) {
            FontFamily fontFamily = (FontFamily)object;
            if (!fontFamily.getFamily().equals(this.getFamily())) {
                return false;
            }
            return fontFamily.isImportant() == this.isImportant();
        }
        return false;
    }

    AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        return this.parseCssValue(string, false);
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.parseCssValue(simpleAttributeSet, CSS.Attribute.FONT_FAMILY, string, bl2);
        return (AttributeValue)simpleAttributeSet.getAttribute((Object)CSS.Attribute.FONT_FAMILY);
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    static {
        String[] stringArray;
        AVAILABLE_FONT_FAMILIY_NAMES = new HashSet();
        SERIF_FONTS = new HashSet();
        SANS_SERIF_FONTS = new HashSet();
        MONOSPACE_FONTS = new HashSet();
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            AVAILABLE_FONT_FAMILIY_NAMES.add(string.toLowerCase());
        }
        SERIF_FONTS.add("times");
        SERIF_FONTS.add("times new roman");
        SERIF_FONTS.add("ms serfi");
        SERIF_FONTS.add("georgia");
        SERIF_FONTS.add("vera serif");
        SANS_SERIF_FONTS.add("arial");
        SANS_SERIF_FONTS.add("verdana");
        SANS_SERIF_FONTS.add("helvetica");
        SANS_SERIF_FONTS.add("calibri");
        SANS_SERIF_FONTS.add("gothic");
        SANS_SERIF_FONTS.add("urw gothic l");
        SANS_SERIF_FONTS.add("lucida sans");
        SANS_SERIF_FONTS.add("dejavu sans");
        MONOSPACE_FONTS.add("courier");
        MONOSPACE_FONTS.add("courier new");
        MONOSPACE_FONTS.add("fixed");
        MONOSPACE_FONTS.add("arial monospaced");
        MONOSPACE_FONTS.add("fixedsys");
        MONOSPACE_FONTS.add("lucide console");
    }
}

