/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.BoxView;
import javax.swing.text.View;

public class FontSize
extends HtmlAttribute {
    private static final int ABSOLUTE = 0;
    private static final int RELATIVE_NUMBER = 1;
    private static final int UNIT = 2;
    private int type;
    private float size;
    private LengthUnit lengthUnit;

    public FontSize(int n2) {
        this.type = 2;
        this.lengthUnit = new LengthUnit(n2 + "pt");
        this.size = this.lengthUnit.getValue();
        this.setString(n2 + "pt");
    }

    public FontSize(int n2, boolean bl2) {
        this.type = 2;
        if (bl2) {
            this.lengthUnit = new LengthUnit(n2 + "pt");
            this.size = this.lengthUnit.getValue();
            this.setString(n2 + "pt");
        } else {
            this.lengthUnit = new LengthUnit(n2 + "px");
            this.size = this.lengthUnit.getValue();
            this.setString(n2 + "px");
        }
    }

    public FontSize() {
    }

    public float getValue(BoxView boxView) {
        View view = boxView.getParent();
        float f2 = 16.0f;
        if (view != null && view instanceof BoxView) {
            f2 = ((BoxView)view).getFontSize();
        }
        return this.getValue(f2);
    }

    public float getValue(float f2) {
        switch (this.type) {
            case 1: {
                int n2 = FontSize.convertPointSizeToTableSize(f2) + (int)this.size;
                return FontSize.convertTableSizeToPointSize(n2);
            }
            case 2: {
                if (this.lengthUnit.isAbsolute()) {
                    return this.lengthUnit.getValue();
                }
                return f2 * this.lengthUnit.getValue();
            }
        }
        return this.size;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        FontSize fontSize = new FontSize();
        if ("inherit".equals(string = string.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        if (string.equals("xx-small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(1);
            fontSize.type = 0;
        } else if (string.equals("x-small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(2);
            fontSize.type = 0;
        } else if (string.equals("small")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(3);
            fontSize.type = 0;
        } else if (string.equals("medium")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(4);
            fontSize.type = 0;
        } else if (string.equals("large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(5);
            fontSize.type = 0;
        } else if (string.equals("x-large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(6);
            fontSize.type = 0;
        } else if (string.equals("xx-large")) {
            fontSize.size = FontSize.convertTableSizeToPointSize(7);
            fontSize.type = 0;
        } else if (string.equals("larger")) {
            fontSize.size = 1.0f;
            fontSize.type = 1;
        } else if (string.equals("smaller")) {
            fontSize.size = -1.0f;
            fontSize.type = 1;
        } else {
            AttributeValue attributeValue = LengthUnit.PARSER.parseCssValue(string, bl2);
            if (attributeValue == null) {
                return null;
            }
            fontSize.lengthUnit = (LengthUnit)attributeValue;
            fontSize.type = 2;
            fontSize.size = fontSize.lengthUnit.getValue();
        }
        fontSize.setString(string);
        return fontSize;
    }

    public AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        try {
            FontSize fontSize = new FontSize();
            char c2 = string.charAt(0);
            fontSize.setString(string);
            if (c2 == '+' || c2 == '-') {
                int n2 = 3 + Integer.parseInt(c2 == '+' ? string.substring(1) : string);
                n2 = Math.max(1, Math.min(7, n2));
                fontSize.lengthUnit = new LengthUnit(FontSize.convertTableSizeToPointSize(n2) + "pt");
                fontSize.type = 2;
            } else {
                LengthUnit lengthUnit = (LengthUnit)LengthUnit.PARSER.parseCssValue(string, false);
                fontSize.type = 2;
                int n3 = lengthUnit != null ? (int)lengthUnit.getValue() : Integer.parseInt(string);
                fontSize.lengthUnit = new LengthUnit(FontSize.convertTableSizeToPointSize(n3) + "pt");
            }
            return fontSize;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static final int convertTableSizeToPointSize(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        switch (n2) {
            case 1: {
                return 8;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 18;
            }
            case 6: {
                return 24;
            }
        }
        return 36;
    }

    private static final int convertPointSizeToTableSize(float f2) {
        if (f2 < 9.0f) {
            return 1;
        }
        if (f2 < 11.0f) {
            return 2;
        }
        if (f2 < 13.0f) {
            return 3;
        }
        if (f2 < 16.0f) {
            return 4;
        }
        if (f2 < 21.0f) {
            return 5;
        }
        if (f2 < 30.0f) {
            return 6;
        }
        return 7;
    }

    public boolean equals(Object object) {
        if (object instanceof FontSize) {
            FontSize fontSize = (FontSize)object;
            if (fontSize.lengthUnit == null || !fontSize.lengthUnit.equals(this.lengthUnit)) {
                return false;
            }
            if (fontSize.size != this.size) {
                return false;
            }
            return fontSize.type == this.type;
        }
        return false;
    }
}

