/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;

public class FontStyle
extends SingleAttributeValue {
    private boolean italic;

    public FontStyle() {
    }

    public FontStyle(boolean bl2) {
        this.italic = bl2;
        if (bl2) {
            this.setString("italic");
        } else {
            this.setString("normal");
        }
    }

    public boolean isItalic() {
        return this.italic;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equalsIgnoreCase(string)) {
            return AttributeValue.INHERIT;
        }
        FontStyle fontStyle = new FontStyle();
        if (string.equalsIgnoreCase("italic") || string.equalsIgnoreCase("oblique")) {
            fontStyle.italic = true;
        } else if (string.equalsIgnoreCase("normal")) {
            fontStyle.italic = false;
        } else {
            return null;
        }
        fontStyle.setString(string);
        fontStyle.setImportant(bl2);
        return fontStyle;
    }

    public boolean equals(Object object) {
        if (object instanceof FontStyle) {
            FontStyle fontStyle = (FontStyle)object;
            if (fontStyle.isItalic() != this.isItalic()) {
                return false;
            }
            return fontStyle.isImportant() == this.isImportant();
        }
        return false;
    }
}

