/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;

public class FontWeight
extends SingleAttributeValue {
    private boolean bold;

    FontWeight() {
    }

    public FontWeight(boolean bl2) {
        this.bold = bl2;
        if (bl2) {
            this.setString("bold");
        } else {
            this.setString("normal");
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean equals(Object object) {
        if (object instanceof FontWeight) {
            FontWeight fontWeight = (FontWeight)object;
            if (fontWeight.isBold() != this.isBold()) {
                return false;
            }
            return fontWeight.isImportant() == this.isImportant();
        }
        return false;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equalsIgnoreCase(string)) {
            return AttributeValue.INHERIT;
        }
        FontWeight fontWeight = new FontWeight();
        fontWeight.setString(string);
        if (string.equalsIgnoreCase("bold")) {
            fontWeight.bold = true;
            fontWeight.setImportant(bl2);
            return fontWeight;
        }
        if (string.equalsIgnoreCase("bolder")) {
            fontWeight.bold = true;
            fontWeight.setImportant(bl2);
            return fontWeight;
        }
        if (string.equalsIgnoreCase("lighter")) {
            fontWeight.bold = false;
            fontWeight.setImportant(bl2);
            return fontWeight;
        }
        if (string.equalsIgnoreCase("normal")) {
            fontWeight.bold = false;
            fontWeight.setImportant(bl2);
            return fontWeight;
        }
        try {
            fontWeight.bold = Integer.parseInt(string) >= 700;
            fontWeight.setImportant(bl2);
            return fontWeight;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

