/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;

public class IntegerValue
extends HtmlAttribute {
    private int value;
    static final IntegerValue PARSER = new IntegerValue();

    public IntegerValue() {
    }

    public IntegerValue(int n2) {
        this.value = n2;
        this.setString(Integer.toString(n2));
    }

    public int getInt() {
        return this.value;
    }

    AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        return this.parseCssValue(string, false);
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        try {
            if ("inherit".equalsIgnoreCase(string)) {
                return AttributeValue.INHERIT;
            }
            int n2 = Integer.parseInt(string);
            IntegerValue integerValue = new IntegerValue();
            integerValue.value = n2;
            integerValue.setString(string);
            integerValue.setImportant(bl2);
            return integerValue;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)object;
            if (integerValue.getInt() != this.getInt()) {
                return false;
            }
            return integerValue.isImportant() == this.isImportant();
        }
        return false;
    }
}

