/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.text.View;

public class LengthUnit
extends HtmlAttribute {
    static final LengthUnit PARSER = new LengthUnit();
    private static final Hashtable<String, Float> UNITS = new Hashtable();
    private static float logicalInch;
    private float value;
    private int type;
    private boolean isAsterisk;
    public static final int AUTO = -1;
    public static final int ABSOLUTE = 0;
    public static final int REALTIVE = 1;
    public static final int EM = 2;
    public static final int EX = 3;

    public LengthUnit(String string) {
        LengthUnit lengthUnit = (LengthUnit)this.parseCssValue(string, false);
        if (lengthUnit != null) {
            this.setString(string);
            this.type = lengthUnit.type;
            this.value = lengthUnit.value;
            this.isAsterisk = lengthUnit.isAsterisk;
        }
    }

    public LengthUnit(int n2) {
        this(Integer.toString(n2), n2, 0);
    }

    LengthUnit() {
    }

    LengthUnit(String string, float f2, int n2) {
        this.setString(string);
        this.value = f2;
        this.type = n2;
    }

    public static void setSystemDPI(float f2) {
        logicalInch = f2;
        UNITS.put("pt", new Float(logicalInch / 72.0f));
        UNITS.put("px", new Float(1.0f));
        UNITS.put("mm", new Float(logicalInch / 25.4f));
        UNITS.put("cm", new Float((double)logicalInch / 2.54));
        UNITS.put("pc", new Float(logicalInch / 6.0f));
        UNITS.put("in", new Float(logicalInch));
    }

    public static float getPTforPX(float f2) {
        return Math.round(f2 * 72.0f / logicalInch);
    }

    public static float getPXforPT(float f2) {
        return Math.round(f2 * logicalInch / 72.0f);
    }

    public float getValue() {
        return this.value;
    }

    public boolean isAbsolute() {
        return this.type == 0;
    }

    public boolean isAuto() {
        return this.type == -1;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        LengthUnit lengthUnit;
        block17: {
            int n2;
            block16: {
                if ("inherit".equalsIgnoreCase(string)) {
                    return AttributeValue.INHERIT;
                }
                lengthUnit = new LengthUnit();
                lengthUnit.setString(string);
                if ("auto".equalsIgnoreCase(string)) {
                    lengthUnit.type = -1;
                    return lengthUnit;
                }
                if ("0".equals(string)) {
                    return lengthUnit;
                }
                if ("*".equals(string)) {
                    lengthUnit.isAsterisk = true;
                    lengthUnit.type = 1;
                    lengthUnit.value = 1.0f;
                    return lengthUnit;
                }
                n2 = string.length();
                if (string.endsWith("%")) {
                    try {
                        lengthUnit.value = Float.parseFloat(string.substring(0, n2 - 1)) / 100.0f;
                        lengthUnit.type = 1;
                        return lengthUnit;
                    }
                    catch (Throwable throwable) {
                        if (!Logger.doesLog(1)) break block16;
                        Logger.error(throwable);
                    }
                }
            }
            if (string.length() < 3) {
                return null;
            }
            String string2 = string.substring(n2 - 2, n2).toLowerCase();
            String string3 = string.substring(0, n2 - 2);
            if (string3.length() > 0 && string3.indexOf(44) >= 0) {
                string3 = string3.replace(',', '.');
            }
            Float f2 = UNITS.get(string2);
            try {
                if (f2 != null) {
                    lengthUnit.value = Float.parseFloat(string3) * f2.floatValue();
                    return lengthUnit;
                }
                if (string2.equals("em")) {
                    lengthUnit.value = Float.parseFloat(string3);
                    lengthUnit.type = 2;
                    return lengthUnit;
                }
                if (string2.equals("ex")) {
                    lengthUnit.value = Float.parseFloat(string3) * 0.5f;
                    lengthUnit.type = 2;
                    return lengthUnit;
                }
            }
            catch (Throwable throwable) {
                if (!Logger.doesLog(1)) break block17;
                Logger.error(throwable);
            }
        }
        try {
            int n3 = Integer.parseInt(string);
            lengthUnit.value = n3;
            lengthUnit.type = 0;
            return lengthUnit;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        try {
            LengthUnit lengthUnit = new LengthUnit();
            lengthUnit.setString(string);
            if ("*".equals(string)) {
                lengthUnit.isAsterisk = true;
                lengthUnit.type = 1;
                lengthUnit.value = 1.0f;
                return lengthUnit;
            }
            int n2 = string.length();
            try {
                if (string.endsWith("%")) {
                    lengthUnit.value = Float.parseFloat(string.substring(0, n2 - 1)) / 100.0f;
                    lengthUnit.type = 1;
                } else if (string.startsWith("%")) {
                    lengthUnit.value = Float.parseFloat(string.substring(1)) / 100.0f;
                    lengthUnit.type = 1;
                } else {
                    if (string.toLowerCase().endsWith("px")) {
                        string = string.substring(0, n2 - 2);
                    }
                    int n3 = Integer.parseInt(string);
                    lengthUnit.value = n3;
                    lengthUnit.type = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return lengthUnit;
        }
        catch (Throwable throwable) {
            if (Logger.doesLog(1)) {
                Logger.error(throwable);
            }
            return null;
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isAsterisk() {
        return this.isAsterisk;
    }

    public float calculateValue(float f2, View view) {
        switch (this.type) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.value * f2;
            }
            case 2: {
                float f3 = view != null ? ((BoxView)view).getFontSize() : 16.0f;
                return this.value * f3;
            }
            case 3: {
                float f4 = view != null ? ((BoxView)view).getFontSize() : 16.0f;
                return this.value * f4 * 0.6f;
            }
        }
        return 0.0f;
    }

    public boolean equals(Object object) {
        if (object instanceof LengthUnit) {
            LengthUnit lengthUnit = (LengthUnit)object;
            if (lengthUnit.type != this.type) {
                return false;
            }
            if (lengthUnit.value != this.value) {
                return false;
            }
            return lengthUnit.isAsterisk == this.isAsterisk;
        }
        return false;
    }

    static {
        float f2 = 96.0f;
        try {
            f2 = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        logicalInch = 96.0f;
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().contains("windows")) {
                logicalInch = f2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LengthUnit.setSystemDPI(logicalInch);
    }
}

