/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.util.Hashtable;

public class ListStyleType
extends HtmlAttribute {
    public static final int DISC = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int DECIMAL = 3;
    public static final int DECIMAL_LEADING_ZERO = 4;
    public static final int LOWER_ROMAN = 5;
    public static final int UPPER_ROMAN = 6;
    public static final int HEBREW = 7;
    public static final int GEORGIAN = 8;
    public static final int ARMENIAN = 9;
    public static final int CJK_IDEOGRAPHIC = 10;
    public static final int HIRAGANA = 11;
    public static final int KATAKANA = 12;
    public static final int HIRAGANA_IROHA = 13;
    public static final int KATAKANA_IROHA = 14;
    public static final int LOWER_LATIN = 15;
    public static final int UPPER_LATIN = 16;
    public static final int LOWER_GREEK = 17;
    public static final int NONE = 18;
    private int type;
    private static final Hashtable<String, ListStyleType> MAP = new Hashtable();
    static final ListStyleType PARSER;

    private static void factory(String string, int n2) {
        ListStyleType listStyleType = new ListStyleType();
        listStyleType.type = n2;
        listStyleType.setString(string);
        MAP.put(string, listStyleType);
    }

    public int getType() {
        return this.type;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equalsIgnoreCase(string)) {
            return AttributeValue.INHERIT;
        }
        return MAP.get(string);
    }

    AttributeValue parseHtmlValue(InetHtmlDocument inetHtmlDocument, String string) {
        int n2;
        if ("disc".equalsIgnoreCase(string) || "disk".equalsIgnoreCase(string)) {
            n2 = 0;
        } else if ("circle".equalsIgnoreCase(string)) {
            n2 = 1;
        } else if ("square".equalsIgnoreCase(string)) {
            n2 = 2;
        } else if ("1".equals(string)) {
            n2 = 3;
        } else if ("a".equals(string)) {
            n2 = 15;
        } else if ("A".equals(string)) {
            n2 = 16;
        } else if ("i".equals(string)) {
            n2 = 5;
        } else if ("I".equals(string)) {
            n2 = 6;
        } else {
            return null;
        }
        ListStyleType listStyleType = new ListStyleType();
        listStyleType.type = n2;
        listStyleType.setString(string);
        return listStyleType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListStyleType)) {
            return false;
        }
        ListStyleType listStyleType = (ListStyleType)object;
        if (this.isImportant() != listStyleType.isImportant()) {
            return false;
        }
        return this.type == listStyleType.type;
    }

    static {
        ListStyleType.factory("disc", 0);
        ListStyleType.factory("circle", 1);
        ListStyleType.factory("square", 2);
        ListStyleType.factory("decimal", 3);
        ListStyleType.factory("decimal-leading-zero", 4);
        ListStyleType.factory("lower-roman", 5);
        ListStyleType.factory("upper-roman", 6);
        ListStyleType.factory("hebrew", 7);
        ListStyleType.factory("georgian", 8);
        ListStyleType.factory("armenian", 9);
        ListStyleType.factory("cjk-ideographic", 10);
        ListStyleType.factory("hiragana", 11);
        ListStyleType.factory("katakana", 12);
        ListStyleType.factory("hiragana-iroha", 13);
        ListStyleType.factory("katakana-iroha", 14);
        ListStyleType.factory("lower-latin", 15);
        ListStyleType.factory("lower-alpha", 15);
        ListStyleType.factory("upper-latin", 16);
        ListStyleType.factory("upper-alpha", 16);
        ListStyleType.factory("lower-greek", 17);
        ListStyleType.factory("none", 18);
        PARSER = MAP.get("decimal");
    }
}

