/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.HashMap;
import java.util.Map;

public class TextDecoration
extends SingleAttributeValue {
    private int decoration;
    public static final int NONE = 0;
    public static final int UNDERLINE = 1;
    public static final int OVERLINE = 2;
    public static final int LINE_THROUGH = 4;
    private static final HashMap<Integer, String> KEY_MAP = new HashMap();
    static final TextDecoration PARSER = new TextDecoration();

    public TextDecoration() {
        this.setString(KEY_MAP.get(0));
    }

    public TextDecoration(int n2) {
        this.decoration = n2;
        this.setString(this.getCompleteString(n2));
    }

    private String getCompleteString(int n2) {
        if (n2 == 0) {
            return KEY_MAP.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 1) != 0) {
            stringBuilder.append(KEY_MAP.get(1)).append(" ");
        }
        if ((n2 & 2) != 0) {
            stringBuilder.append(KEY_MAP.get(2)).append(" ");
        }
        if ((n2 & 4) != 0) {
            stringBuilder.append(KEY_MAP.get(4)).append(" ");
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString().trim();
        }
        return KEY_MAP.get(0);
    }

    public int getDecoration() {
        return this.decoration;
    }

    protected AttributeValue parseCssValue(String string, boolean bl2) {
        if ("inherit".equals(string = string.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        TextDecoration textDecoration = new TextDecoration();
        int n2 = 0;
        String[] stringArray = string.split("\\s+");
        block0: for (Map.Entry<Integer, String> entry : KEY_MAP.entrySet()) {
            for (String string2 : stringArray) {
                if (!string2.equals(entry.getValue())) continue;
                n2 |= entry.getKey().intValue();
                continue block0;
            }
        }
        textDecoration.decoration = n2;
        textDecoration.setString(string);
        return textDecoration;
    }

    public boolean equals(Object object) {
        if (object instanceof TextDecoration) {
            TextDecoration textDecoration = (TextDecoration)object;
            if (textDecoration.getDecoration() != this.getDecoration()) {
                return false;
            }
            return textDecoration.isImportant() == this.isImportant();
        }
        return false;
    }

    static {
        KEY_MAP.put(0, "none");
        KEY_MAP.put(1, "underline");
        KEY_MAP.put(2, "overline");
        KEY_MAP.put(4, "line-through");
    }
}

