/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractDecoder {
    private byte[] buffer;
    private int offset;
    private int length;
    private transient Image image;
    private int hash = 0;
    private float ppmx = 3779.52f;
    private float ppmy = 3779.52f;
    private int index = 0;

    AbstractDecoder() {
    }

    AbstractDecoder(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.offset = n2;
        this.length = n3;
    }

    public AbstractDecoder setBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        return this;
    }

    private synchronized void decodeImageSynchronized(int n2, int n3) {
        if (this.image == null) {
            try {
                this.image = this.decodeImage(n2, n3);
            }
            catch (Exception exception) {
                this.image = null;
            }
        }
    }

    public double getResolutionScaleX() {
        return 3780.0f / this.ppmx;
    }

    public double getResolutionScaleY() {
        return 3780.0f / this.ppmy;
    }

    public Image getImage(int n2, int n3) {
        if (this.image == null) {
            this.decodeImageSynchronized(n2, n3);
        }
        return this.image;
    }

    private Image scaleImageOnServer(Image image, int n2, int n3, int n4, int n5) {
        try {
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.scale((double)n2 / (double)n4, (double)n3 / (double)n5);
            graphics2D.drawImage(image, null, null);
            return bufferedImage;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return image.getScaledInstance(n2, n3, 1);
        }
    }

    public Image getScaledImage(int n2, int n3) {
        this.getImage(n2, n3);
        int n4 = this.image.getWidth(null);
        int n5 = this.image.getHeight(null);
        if (n4 == n2 && n5 == n3) {
            return this.image;
        }
        return this.scaleImageOnServer(this.image, n2, n3, n4, n5);
    }

    public final Image getImage() {
        if (this.image == null) {
            this.decodeImageSynchronized(100, 100);
        }
        return this.image;
    }

    abstract Image decodeImage(int var1, int var2) throws Exception;

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.buffer);
        objectOutput.writeInt(this.offset);
        objectOutput.writeInt(this.length);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.buffer = (byte[])objectInput.readObject();
        this.offset = objectInput.readInt();
        this.length = objectInput.readInt();
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            this.hash = this.hash * 31 + this.buffer[i2];
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        AbstractDecoder abstractDecoder = (AbstractDecoder)object;
        if (abstractDecoder.hashCode() != this.hashCode()) {
            return false;
        }
        if (abstractDecoder.buffer.length != this.buffer.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            if (abstractDecoder.buffer[i2] == this.buffer[i2]) continue;
            return false;
        }
        return true;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public float getPpmx() {
        return this.ppmx;
    }

    public float getPpmy() {
        return this.ppmy;
    }

    public void setPpmx(float f2) {
        this.ppmx = f2;
    }

    public void setPpmy(float f2) {
        this.ppmy = f2;
    }

    protected int readInt() throws IOException {
        try {
            int n2 = (this.buffer[this.index] & 0xFF) + ((this.buffer[this.index + 1] & 0xFF) << 8) + ((this.buffer[this.index + 2] & 0xFF) << 16) + (this.buffer[this.index + 3] << 24);
            this.index += 4;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readShort() throws IOException {
        try {
            int n2 = (this.buffer[this.index] & 0xFF) + (this.buffer[this.index + 1] << 8);
            this.index += 2;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readRGB24() throws IOException {
        try {
            int n2 = 0xFF000000 | this.buffer[this.index] & 0xFF | (this.buffer[this.index + 1] & 0xFF) << 8 | (this.buffer[this.index + 2] & 0xFF) << 16;
            this.index += 3;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Premature end of image data");
        }
    }

    protected int readRGB16() throws IOException {
        int n2 = this.readShort();
        int n3 = (0x7C00 & n2) >> 7;
        int n4 = (0x3E0 & n2) >> 2;
        int n5 = (0x1F & n2) << 3;
        int n6 = 0xFF000000 | n5 | n4 << 8 | n3 << 16;
        return n6;
    }

    protected byte readByte() throws IOException {
        try {
            return this.buffer[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Premature end of image data");
        }
    }

    protected void setIndexTo(int n2) {
        this.index = n2;
    }

    protected void skipBytes(int n2) throws IOException {
        this.index += n2;
        if (this.index > this.buffer.length) {
            throw new IOException("Premature end of image data");
        }
    }
}

