/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.AbstractDecoder;
import com.inet.html.utils.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;

public class BMPDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = -8230871491045063636L;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    public static final int BI_JPEG = 4;
    public static final int BI_PNG = 5;

    public BMPDecoder() {
    }

    public BMPDecoder(byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
        try {
            this.decodeImage(0, 0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Image decodeImage(int n2, int n3) throws IOException {
        Object object;
        MemoryImageSource memoryImageSource = null;
        this.setIndexTo(this.getOffset());
        this.skipBytes(14);
        int n4 = this.readInt();
        if (n4 < 40) {
            throw new IOException("bmi size < 40 : " + n4);
        }
        int n5 = this.readInt();
        int n6 = this.readInt();
        this.skipBytes(2);
        int n7 = this.readShort();
        int n8 = n5 / 4 * 4;
        if (n5 % 4 > 0) {
            n8 += 4;
        }
        int n9 = this.readInt();
        this.skipBytes(4);
        this.setPpmx(this.readInt());
        this.setPpmy(this.readInt());
        int n10 = this.readInt();
        this.skipBytes(4);
        this.skipBytes(n4 - 40);
        switch (n7) {
            case 1: {
                object = this.getColorModel(n7, n10);
                byte[] byArray = new byte[n5 * n6];
                n8 = n5 + 31 >> 3 & 0xFFFFFFFC;
                for (int i2 = n6 - 1; i2 >= 0; --i2) {
                    for (int i3 = 0; i3 < n5; i3 += 8) {
                        byte by2 = this.readByte();
                        for (int i4 = 0; i4 < 8 && i4 < n5 - i3; ++i4) {
                            byte by3;
                            byArray[i2 * n5 + i3 + i4] = by3 = (byte)(by2 >> 7 - i4 & 1);
                        }
                    }
                }
                memoryImageSource = new MemoryImageSource(n5, n6, (ColorModel)object, byArray, 0, n5);
                break;
            }
            case 4: {
                object = this.getColorModel(n7, n10);
                byte[] byArray = new byte[n5 * n6];
                if (n9 == 2) {
                    Logger.warning("can not read bmp compression: " + n9);
                    return null;
                }
                for (int i5 = n6 - 1; i5 >= 0; --i5) {
                    int n11 = 0;
                    int n12 = 0;
                    for (int i6 = 0; i6 < n5; ++i6) {
                        if ((i6 & 1) == 0) {
                            n11 = this.readByte();
                            n12 = n11 >> 4;
                        } else {
                            n12 = n11;
                        }
                        byArray[i5 * n5 + i6] = (byte)(n12 &= 0xF);
                    }
                }
                memoryImageSource = new MemoryImageSource(n5, n6, (ColorModel)object, byArray, 0, n5);
                break;
            }
            case 8: {
                object = this.getColorModel(n7, n10);
                int n13 = n8 - n5;
                byte[] byArray = new byte[n5 * n6];
                for (int i7 = n6 - 1; i7 >= 0; --i7) {
                    for (int i8 = 0; i8 < n5; ++i8) {
                        byArray[i7 * n5 + i8] = this.readByte();
                    }
                    this.skipBytes(n13);
                }
                memoryImageSource = new MemoryImageSource(n5, n6, (ColorModel)object, byArray, 0, n5);
                break;
            }
            case 16: {
                this.skipColorTable(n10);
                if (n9 != 0) {
                    Logger.warning("can not read bmp compression: " + n9);
                    return null;
                }
                int n14 = (2 - n5 % 2) % 2 * 2;
                int[] nArray = new int[n5 * n6];
                for (int i9 = n6 - 1; i9 >= 0; --i9) {
                    for (int i10 = 0; i10 < n5; ++i10) {
                        nArray[i9 * n5 + i10] = this.readRGB16();
                    }
                    this.skipBytes(n14);
                }
                memoryImageSource = new MemoryImageSource(n5, n6, nArray, 0, n5, null);
                break;
            }
            case 24: {
                int n15 = n5 % 4;
                int[] nArray = new int[n5 * n6];
                for (int i11 = n6 - 1; i11 >= 0; --i11) {
                    for (int i12 = 0; i12 < n5; ++i12) {
                        nArray[i11 * n5 + i12] = this.readRGB24();
                    }
                    this.skipBytes(n15);
                }
                memoryImageSource = new MemoryImageSource(n5, n6, nArray, 0, n5, null);
                break;
            }
            case 32: {
                int[] nArray = new int[n5 * n6];
                for (int i13 = n6 - 1; i13 >= 0; --i13) {
                    for (int i14 = 0; i14 < n5; ++i14) {
                        nArray[i13 * n5 + i14] = this.readRGB24();
                        this.skipBytes(1);
                    }
                }
                memoryImageSource = new MemoryImageSource(n5, n6, nArray, 0, n5, null);
                break;
            }
            default: {
                String string = "Invalid BMP Bpp=" + n7;
                Logger.info(string);
                return null;
            }
        }
        object = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        return object;
    }

    private IndexColorModel getColorModel(int n2, int n3) throws IOException {
        if (n3 == 0) {
            n3 = 1 << n2;
        }
        byte[] byArray = new byte[4 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[4 * i2 + 2] = this.readByte();
            byArray[4 * i2 + 1] = this.readByte();
            byArray[4 * i2] = this.readByte();
            byArray[4 * i2 + 3] = -1;
            this.skipBytes(1);
        }
        IndexColorModel indexColorModel = new IndexColorModel(n2, n3, byArray, 0, true);
        return indexColorModel;
    }

    private void skipColorTable(int n2) throws IOException {
        this.skipBytes(n2 * 4);
    }
}

