/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.EmbeddedImage;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.text.Element;

public class DocumentImage
implements EmbeddedImage {
    private ImageIcon image;
    private String url;
    private Element elementToUpdate;

    public DocumentImage(Image image, Element element) {
        if (image != null) {
            this.image = new ImageIcon(image);
        }
        this.elementToUpdate = element;
    }

    public void removeChachedImage() {
        if (this.url != null) {
            this.image = null;
        }
    }

    public ImageIcon getImageData() {
        RemoteImage remoteImage;
        if (this.image != null) {
            return this.image;
        }
        if (ImageCache.isCacheReference(this.url) && (remoteImage = ImageCache.getStaticInstance().getImage(this.url, null, null)) != null && remoteImage.getContent() != null) {
            this.image = new ImageIcon(remoteImage.getContent());
        }
        return this.image;
    }

    public String getUrl() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
        InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.elementToUpdate.getDocument();
        if (string != null) {
            inetHtmlDocument.addAttribute(this.elementToUpdate.getAttributes(), (Object)HTML.Attribute.SRC, new UrlValue(string));
        } else {
            inetHtmlDocument.addAttribute(this.elementToUpdate.getAttributes(), (Object)HTML.Attribute.SRC, null);
        }
    }

    public void setRefElement(Element element) {
        this.elementToUpdate = element;
    }

    public String toString() {
        return "Image(" + (this.image != null ? "local" : "remote") + "): Location=" + this.url + " @ element=" + this.elementToUpdate;
    }
}

