/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.finder.GenericFinder;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.views.RenderContext;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ElementUtils {
    private static final int TEMP_ATTRIBUTES_COUNT = TemporaryStyle.Attribute.values().length;

    public static int getChildIndex(Element element, Element element2) {
        if (element2.getParentElement() != element) {
            return -1;
        }
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            if (element.getElement(i2) != element2) continue;
            return i2;
        }
        return -1;
    }

    public static Element[] getChildren(Element element, int n2, int n3) {
        if (n2 < element.getElementCount() && n3 > 0) {
            Element[] elementArray = new Element[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                elementArray[i2] = element.getElement(i2 + n2);
            }
            return elementArray;
        }
        return null;
    }

    public static Element[] getAllChildren(Element element) {
        int n2 = element.getElementCount();
        Element[] elementArray = new Element[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            elementArray[i2] = element.getElement(i2);
        }
        return elementArray;
    }

    public static AbstractDocument.ElementEdit removeChildren(Element element, int n2, int n3) {
        Element[] elementArray = ElementUtils.getChildren(element, n2, n3);
        if (elementArray != null) {
            Element[] elementArray2 = new Element[]{};
            ((AbstractDocument.BranchElement)element).replace(n2, n3, elementArray2);
            return new AbstractDocument.ElementEdit(element, n2, elementArray, elementArray2);
        }
        return null;
    }

    public static boolean isRelated(Element element, Element element2) {
        Element element3 = element;
        if (element == null || element2 == null) {
            return false;
        }
        while (element3 != null && element3 != element2) {
            if ((element3 = element3.getParentElement()) != element2) continue;
            return true;
        }
        return element3 == element2;
    }

    public static MutableAttributeSet removeNonessentialAttributes(AttributeSet attributeSet, Element element) {
        if (attributeSet == null) {
            return null;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        while (enumeration.hasMoreElements()) {
            AttributeFinder<AttributeValue> attributeFinder;
            Object obj = enumeration.nextElement();
            if (obj instanceof TemporaryStyle.Attribute) continue;
            Object object = attributeSet.getAttribute(obj);
            if (obj instanceof CSS.Attribute && (attributeFinder = GenericFinder.getFinder((CSS.Attribute)((Object)obj))) != null) {
                Object object2;
                if (attributeFinder.isInherited() || attributeFinder == AttributeFinder.TEXT_DECORATION) {
                    object2 = StyleResolver.getAttributeValue(element, attributeFinder);
                    if (object != null && object.equals(object2)) continue;
                    simpleAttributeSet.addAttribute(obj, object);
                } else if (attributeFinder == AttributeFinder.FONT_SIZE && (object2 = element.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) != null) {
                    float f2;
                    float f3 = RenderContext.getFontSize(element);
                    float f4 = f2 = object instanceof Float ? ((Float)object).floatValue() : ((FontSize)object).getValue(f3);
                    if (f3 == f2) continue;
                }
            }
            simpleAttributeSet.addAttribute(obj, object);
        }
        return simpleAttributeSet;
    }

    public static Element getLeafAt(Element element, int n2) {
        while (element != null && !element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n2));
        }
        return element;
    }

    public static Element getParagraphFor(Element element) {
        if (element.getParentElement() == null) {
            return element;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        while (displayValue != null && displayValue.getDisplay() == 2 && element.getParentElement() != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED) {
            element = element.getParentElement();
            displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        }
        return element;
    }

    public static void clearTemp(MutableAttributeSet mutableAttributeSet) {
        Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
        Object e2 = null;
        ArrayList arrayList = null;
        while (enumeration.hasMoreElements()) {
            e2 = enumeration.nextElement();
            if (!(e2 instanceof TemporaryStyle.Attribute)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList(TEMP_ATTRIBUTES_COUNT);
            }
            arrayList.add(e2);
        }
        if (arrayList != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                mutableAttributeSet.removeAttribute(arrayList.get(i2));
            }
        }
        mutableAttributeSet.removeAttribute(InetHtmlDocument.FLAG_INIT);
    }

    public static Element findSharedParent(int n2, int n3, Element element) {
        Element element2 = element;
        Element element3 = element2.getElement(element2.getElementIndex(n2));
        int n4 = n2 + n3;
        Element element4 = element2.getElement(element2.getElementIndex(n4));
        while (element3 == element4 && !element3.isLeaf()) {
            element2 = element3;
            element3 = element2.getElement(element2.getElementIndex(n2));
            element4 = element2.getElement(element2.getElementIndex(n4));
        }
        return element2;
    }

    public static Element findSharedParagraph(int n2, int n3, Element element) {
        Element element2 = element;
        Element element3 = element;
        int n4 = n2 + n3;
        Element element4 = element2.getElement(element2.getElementIndex(n2));
        Element element5 = element2.getElement(element2.getElementIndex(n4));
        while (element4 == element5 && !element4.isLeaf()) {
            element2 = element4;
            element4 = element2.getElement(element2.getElementIndex(n2));
            element5 = element2.getElement(element2.getElementIndex(n4));
            DisplayValue displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
            if (displayValue == null || displayValue.getDisplay() == 2 || element2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) continue;
            element3 = element2;
        }
        return element3;
    }

    public static Element findListItemParent(Element element) {
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        Element element2 = element;
        while ((displayValue == null || displayValue.getDisplay() != 4) && element2 != null) {
            if ((element2 = element2.getParentElement()) == null) continue;
            displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        }
        return element2;
    }

    public static Element findParentByTag(Element element, HTML.Tag tag) {
        while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
            element = element.getParentElement();
        }
        return element;
    }

    public static Element findListContainer(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getParentElement();
        Object object = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
        while (element2 != null && object != null && object != HTML.Tag.OL && object != HTML.Tag.UL) {
            if ((element2 = element2.getParentElement()) == null) continue;
            object = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
        }
        return element2;
    }

    public static Element findNextHigherBlock(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getParentElement();
        DisplayValue displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        while ((displayValue == null || displayValue.getDisplay() == 2) && element2 != null) {
            if ((element2 = element2.getParentElement()) == null) continue;
            displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        }
        return element2;
    }

    public static boolean isTablePart(Element element) {
        return ElementUtils.isTablePart(element, false);
    }

    public static boolean isTablePart(Element element, boolean bl2) {
        if (element == null) {
            return false;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (displayValue != null) {
            switch (displayValue.getDisplay()) {
                case 8: 
                case 9: {
                    if (bl2) {
                        return false;
                    }
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isBlockElement(Element element) {
        if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            return false;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (displayValue == null) {
            return false;
        }
        byte by2 = displayValue.getDisplay();
        switch (by2) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonolithic(HTML.Tag tag) {
        switch (tag) {
            case IMG: 
            case HR: 
            case INPUT: 
            case BR: 
            case META: 
            case PARAM: 
            case COL: {
                return true;
            }
        }
        return false;
    }

    public static boolean crossesTable(int n2, int n3, Element element) {
        DisplayValue displayValue;
        Object object;
        Element element2 = ElementUtils.getLeafAt(element, n2);
        if (element2 == null) {
            return true;
        }
        if (n3 >= element2.getStartOffset() && n3 < element2.getEndOffset()) {
            return false;
        }
        Element element3 = null;
        Element element4 = null;
        for (element2 = element2.getParentElement(); element2 != null; element2 = element2.getParentElement()) {
            object = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
            if (object == null) continue;
            if (((DisplayValue)object).getDisplay() == 12 && element4 == null) {
                element4 = element2;
                continue;
            }
            if (((DisplayValue)object).getDisplay() != 8) continue;
            element3 = element2;
            break;
        }
        if (element4 != null && n3 >= element4.getStartOffset() && n3 < element4.getEndOffset()) {
            return false;
        }
        if (!(element4 == null || element3 == null || n3 >= element4.getStartOffset() && n3 < element4.getEndOffset() || n2 == element3.getStartOffset() && n3 >= element3.getEndOffset())) {
            return true;
        }
        for (object = ElementUtils.getLeafAt(element, n3).getParentElement(); object != null && ((displayValue = StyleResolver.getAttributeValue((Element)object, AttributeFinder.DISPLAY)) == null || displayValue.getDisplay() != 12); object = object.getParentElement()) {
        }
        return object != null && (n2 < object.getStartOffset() || n2 >= object.getEndOffset());
    }

    public static boolean isContent(Element element) {
        if (element == null) {
            return false;
        }
        if (!element.isLeaf()) {
            return false;
        }
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet.containsAttribute("CR", Boolean.TRUE)) {
            return false;
        }
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object == HTML.Tag.CONTENT;
    }

    public static Element getPreviousContent(Element element) {
        Element element2;
        Element element3 = element.getParentElement();
        Element element4 = element;
        int n2 = 0;
        while ((n2 = ElementUtils.getChildIndex(element3, element4)) == 0) {
            element4 = element3;
            if ((element3 = element3.getParentElement()) != null) continue;
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        for (element2 = element3.getElement(n2 - 1); element2 != null && !element2.isLeaf(); element2 = element2.getElement(element2.getElementCount() - 1)) {
        }
        return element2;
    }

    public static Element getBodyElement(InetHtmlDocument inetHtmlDocument) {
        Element[] elementArray = inetHtmlDocument.getRootElements();
        Element element = null;
        for (Element element2 : elementArray) {
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HTML) continue;
            element = element2;
            break;
        }
        if (element == null) {
            return null;
        }
        for (Element element2 : ElementUtils.getAllChildren(element)) {
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
            return element2;
        }
        return null;
    }

    public static int getStartOffset(Element element) {
        if (element == null) {
            return -1;
        }
        while (!element.isLeaf()) {
            if (element.getElementCount() == 0) {
                return -1;
            }
            element = element.getElement(0);
        }
        return element.getStartOffset();
    }
}

