/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;

public class FontUtils {
    private static ArrayList<Font> unicodeFonts = new ArrayList();

    public static Font getFontFor(String string) {
        Font[] fontArray;
        if (unicodeFonts.size() > 0) {
            fontArray = unicodeFonts.iterator();
            while (fontArray.hasNext()) {
                Font font = (Font)fontArray.next();
                int n2 = font.canDisplayUpTo(string);
                if (n2 >= 0) continue;
                return font;
            }
        }
        if ((fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) != null) {
            for (int i2 = fontArray.length - 1; i2 >= 0; --i2) {
                Font font = fontArray[i2];
                if (font.canDisplayUpTo(string) >= 0) continue;
                unicodeFonts.add(font);
                return font;
            }
        }
        return null;
    }

    static {
        Font font = new Font("DejaVu Sans", 0, 1);
        if (!font.getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("Serif.plain", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("MS Gothic Sans", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
        if (!(font = new Font("Arial Unicode MS", 0, 1)).getFamily().equals("Dialog")) {
            unicodeFonts.add(font);
        }
    }
}

