/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.image.ImageCache;
import com.inet.html.parser.converter.SrcDataValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.Base64;
import com.inet.html.utils.Logger;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;

public class ImageInliner {
    private Map<URL, String> cache = new HashMap<URL, String>();
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();
    private static final List<Object> IMAGE_ATTRIBUTES = new ArrayList<Object>();

    public void inlineImages(InetHtmlDocument inetHtmlDocument) {
        this.crawl(inetHtmlDocument.getRootElements()[0]);
    }

    private void crawl(Element element) {
        if (element == null) {
            return;
        }
        this.replaceImages(element);
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            this.crawl(element.getElement(i2));
        }
    }

    private void replaceImages(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        for (Object object : IMAGE_ATTRIBUTES) {
            String string;
            if (!attributeSet.isDefined(object)) continue;
            Object object2 = attributeSet.getAttribute(object);
            String string2 = null;
            string2 = object2 instanceof UriValue ? ((UriValue)object2).getUrl() : (object2 instanceof UrlValue ? ((UrlValue)object2).getUrl() : (object2 != null ? object2.toString() : ""));
            URL uRL = this.getLocation(element, string2);
            if (uRL == null && !ImageCache.isCacheReference(string2) || (string = this.encodeFromTarget(uRL, string2)) == null) continue;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
            SrcDataValue srcDataValue = new SrcDataValue();
            srcDataValue.setRawData(string);
            srcDataValue.setCSSattribute(object instanceof TemporaryStyle.Attribute);
            simpleAttributeSet.addAttribute(object, srcDataValue);
            ((InetHtmlDocument)element.getDocument()).setElementAttributes(element, simpleAttributeSet, false);
        }
    }

    private String encodeFromTarget(URL uRL, String string) {
        if (this.cache.containsKey(uRL != null ? uRL : string)) {
            return this.cache.get(uRL != null ? uRL : string);
        }
        try {
            String string2;
            byte[] byArray;
            String string3 = "png";
            if (uRL != null) {
                byArray = this.getDataFromURL(uRL);
                string2 = uRL.getPath();
                if (string2.indexOf(46) >= 0) {
                    string3 = string2.substring(string2.lastIndexOf(46) + 1).toLowerCase();
                }
            } else {
                byArray = this.getDataFromImageCache(string);
            }
            if (byArray == null) {
                return null;
            }
            string2 = Base64.encodeBytes(byArray, 0, byArray.length, 0);
            String string4 = MIME_TYPES.get("png");
            if (MIME_TYPES.containsKey(string3)) {
                string4 = MIME_TYPES.get(string3);
            }
            string2 = "data:" + string4 + ";base64," + string2;
            this.cache.put(uRL, string2);
            return string2;
        }
        catch (Throwable throwable) {
            if (Logger.doesLog(1)) {
                Logger.error(throwable);
            }
            return null;
        }
    }

    private byte[] getDataFromImageCache(String string) {
        block4: {
            Image image = ImageCache.getStaticInstance().getCachedImage(string, null);
            if (image instanceof RenderedImage) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    if (ImageIO.write((RenderedImage)((Object)image), "PNG", byteArrayOutputStream)) {
                        return byteArrayOutputStream.toByteArray();
                    }
                }
                catch (IOException iOException) {
                    if (!Logger.doesLog(1)) break block4;
                    Logger.error(iOException);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getDataFromURL(URL uRL) {
        byte[] byArray;
        InputStream inputStream;
        block21: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            inputStream = null;
            try {
                inputStream = uRL.openStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[4096];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
                if (byteArrayOutputStream == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (Logger.doesLog(2)) {
                        Logger.warning(throwable.getMessage());
                    }
                    byte[] byArray3 = null;
                    return byArray3;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private URL getLocation(Element element, String string) {
        if (string == null) {
            return null;
        }
        URL uRL = ((InetHtmlDocument)element.getDocument()).getBase();
        try {
            if (uRL != null) {
                return new URL(uRL, string);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static {
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpe", "image/jpeg");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("tiff", "image/tiff");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("bmp", "image/bmp");
        MIME_TYPES.put("ico", "image/x-icon");
        IMAGE_ATTRIBUTES.add((Object)HTML.Attribute.SRC);
        IMAGE_ATTRIBUTES.add((Object)TemporaryStyle.Attribute.LIST_STYLE_IMAGE);
        IMAGE_ATTRIBUTES.add((Object)TemporaryStyle.Attribute.BACKGROUND_IMAGE);
    }
}

