/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;

public class JTimeoutTextPane
extends JTextPane {
    private int timeout;

    public JTimeoutTextPane(int n2) {
        this.timeout = n2;
        if (n2 < 0) {
            throw new IllegalArgumentException("The timeout has to be zero or positive");
        }
    }

    public void setPage(URL uRL) throws IOException {
        String string = uRL.getPath();
        string = string + (uRL.getQuery() != null ? "?" + uRL.getQuery() : "");
        string = string + (uRL.getRef() != null ? "#" + uRL.getRef() : "");
        URL uRL2 = new URL(uRL, string, new TimeoutHandler(this.timeout));
        super.setPage(uRL2);
    }

    public void setPage(String string) throws IOException {
        URL uRL = new URL(null, string, new TimeoutHandler(this.timeout));
        super.setPage(uRL);
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
        if (n2 < 0) {
            throw new IllegalArgumentException("The timeout has to be zero or positive");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpConnectionWrapper
    extends HttpURLConnection {
        private final HttpURLConnection con;
        private final URL origUrl;

        public HttpConnectionWrapper(HttpURLConnection httpURLConnection, URL uRL) {
            super(uRL);
            this.con = httpURLConnection;
            this.origUrl = uRL;
        }

        @Override
        public void disconnect() {
            this.con.disconnect();
        }

        @Override
        public boolean usingProxy() {
            return this.con.usingProxy();
        }

        @Override
        public void connect() throws IOException {
            this.con.connect();
        }

        @Override
        public void addRequestProperty(String string, String string2) {
            this.con.addRequestProperty(string, string2);
        }

        @Override
        public boolean getAllowUserInteraction() {
            return this.con.getAllowUserInteraction();
        }

        @Override
        public int getConnectTimeout() {
            return this.con.getConnectTimeout();
        }

        @Override
        public Object getContent() throws IOException {
            return this.con.getContent();
        }

        public Object getContent(Class[] classArray) throws IOException {
            return this.con.getContent(classArray);
        }

        @Override
        public String getContentEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public int getContentLength() {
            return this.con.getContentLength();
        }

        @Override
        public String getContentType() {
            return this.con.getContentType();
        }

        @Override
        public long getDate() {
            return this.con.getDate();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return this.con.getDefaultUseCaches();
        }

        @Override
        public boolean getDoInput() {
            return this.con.getDoInput();
        }

        @Override
        public boolean getDoOutput() {
            return this.con.getDoOutput();
        }

        @Override
        public InputStream getErrorStream() {
            return this.con.getErrorStream();
        }

        @Override
        public long getExpiration() {
            return this.con.getExpiration();
        }

        @Override
        public String getHeaderField(int n2) {
            return this.con.getHeaderField(n2);
        }

        @Override
        public String getHeaderField(String string) {
            return this.con.getHeaderField(string);
        }

        @Override
        public long getHeaderFieldDate(String string, long l2) {
            return this.con.getHeaderFieldDate(string, l2);
        }

        @Override
        public int getHeaderFieldInt(String string, int n2) {
            return this.con.getHeaderFieldInt(string, n2);
        }

        @Override
        public String getHeaderFieldKey(int n2) {
            return this.con.getHeaderFieldKey(n2);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.con.getHeaderFields();
        }

        @Override
        public long getIfModifiedSince() {
            return this.con.getIfModifiedSince();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.con.getInputStream();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return this.con.getInstanceFollowRedirects();
        }

        @Override
        public long getLastModified() {
            return this.con.getLastModified();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.con.getOutputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.con.getPermission();
        }

        @Override
        public int getReadTimeout() {
            return this.con.getReadTimeout();
        }

        @Override
        public String getRequestMethod() {
            return this.con.getRequestMethod();
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return this.con.getRequestProperties();
        }

        @Override
        public String getRequestProperty(String string) {
            return this.con.getRequestProperty(string);
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.con.getResponseCode();
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.con.getResponseMessage();
        }

        @Override
        public URL getURL() {
            return this.origUrl;
        }

        @Override
        public boolean getUseCaches() {
            return this.con.getUseCaches();
        }
    }

    private static class TimeoutHandler
    extends URLStreamHandler {
        private final int timeout;

        public TimeoutHandler(int n2) {
            this.timeout = n2;
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            URLConnection uRLConnection = new URL(uRL.toString()).openConnection();
            uRLConnection.setReadTimeout(this.timeout);
            if (uRLConnection instanceof HttpURLConnection) {
                return new HttpConnectionWrapper((HttpURLConnection)uRLConnection, uRL);
            }
            return uRLConnection;
        }
    }
}

