/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Logger {
    public static final int SILENT = -1;
    public static final int CRITICAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static int logLevel = 1;
    private static int errors = 0;
    private static int criticals = 0;
    private static int warnings = 0;
    private static JFrame auxDisplay;
    private static JTextPane console;
    private static boolean showTime;
    private static boolean showFrame;
    private static PrintStream errStream;
    private static PrintStream outStream;
    private static final String CRITICAL_PREFIX = "[CRITICAL] ";
    private static final String ERROR_PREFIX = "[ERROR   ] ";
    private static final String WARNING_PREFIX = "[WARNING ] ";
    private static final String INFO_PREFIX = "[info    ] ";
    private static final String DEBUG_PREFIX = "[debug   ] ";

    public static boolean doesLog(int n2) {
        return n2 <= logLevel;
    }

    public static final void critical(String string) {
        Logger.checkFrame();
        if (logLevel >= 0) {
            errStream.println(CRITICAL_PREFIX + string);
        }
        ++criticals;
    }

    public static final void critical(Throwable throwable) {
        Logger.checkFrame();
        if (logLevel >= 0) {
            outStream.println("[CRITICAL] EXCEPTION");
            throwable.printStackTrace(outStream);
        }
        ++criticals;
    }

    public static final void error(String string) {
        Logger.checkFrame();
        if (logLevel >= 1) {
            outStream.println(ERROR_PREFIX + string);
        }
        ++errors;
    }

    public static final void error(Throwable throwable) {
        Logger.checkFrame();
        if (logLevel >= 1) {
            outStream.println("[ERROR   ] EXCEPTION");
            throwable.printStackTrace(outStream);
        }
        ++errors;
    }

    public static final void warning(String string) {
        Logger.checkFrame();
        if (logLevel >= 2) {
            outStream.println(WARNING_PREFIX + string);
        }
        ++warnings;
    }

    public static final void info(String string) {
        Logger.checkFrame();
        if (logLevel >= 3) {
            outStream.println(INFO_PREFIX + string);
        }
    }

    public static final void debug(String string) {
        Logger.checkFrame();
        if (logLevel >= 4) {
            outStream.println(DEBUG_PREFIX + string);
        }
    }

    public static void setLogLevel(int n2) {
        logLevel = n2;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void reset() {
        errors = 0;
        criticals = 0;
        warnings = 0;
    }

    public static int getCriticals() {
        return criticals;
    }

    public static int getErrors() {
        return errors;
    }

    public static int getWarnings() {
        return warnings;
    }

    private static void checkFrame() {
        if (showFrame && auxDisplay == null) {
            Logger.setAuxConsoleMode(true);
        }
    }

    public static void setAuxConsoleMode(boolean bl2) {
        if (bl2) {
            if (auxDisplay != null) {
                auxDisplay.setVisible(true);
                return;
            }
            auxDisplay = new JFrame("Logger AUX");
            auxDisplay.setLayout(new BorderLayout());
            auxDisplay.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    showFrame = false;
                }
            });
            console = new JTextPane();
            console.setEditable(false);
            auxDisplay.add((Component)new JScrollPane(console), "Center");
            JPanel jPanel = new JPanel(new FlowLayout(2));
            auxDisplay.add((Component)jPanel, "South");
            JCheckBox jCheckBox = new JCheckBox(new AbstractAction("Show Time"){

                public void actionPerformed(ActionEvent actionEvent) {
                    showTime = !showTime;
                }
            });
            jCheckBox.setSelected(showTime);
            jPanel.add(jCheckBox);
            final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Silent", "Critical", "Error", "Warning", "Info", "Debug"});
            jPanel.add(jComboBox);
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Logger.setLogLevel(jComboBox.getSelectedIndex() - 1);
                }
            });
            jComboBox.setSelectedIndex(Logger.getLogLevel() + 1);
            jPanel.add(new JButton(new AbstractAction("Clear"){

                public void actionPerformed(ActionEvent actionEvent) {
                    console.setText("");
                }
            }));
            outStream = errStream = new PrintStream(new FrameStream());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    auxDisplay.setSize(400, 400);
                    auxDisplay.setVisible(true);
                }
            });
        } else {
            if (auxDisplay == null) {
                return;
            }
            errStream = System.err;
            outStream = System.out;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    auxDisplay.setVisible(false);
                    auxDisplay.dispose();
                    auxDisplay = null;
                }
            });
        }
    }

    static {
        showFrame = false;
        errStream = System.err;
        outStream = System.out;
        try {
            String string = System.getProperty("jwebengine.debug");
            if (string != null && "true".equalsIgnoreCase(string.toString())) {
                logLevel = 4;
            }
            if ((string = System.getProperty("showLogFrame")) != null && "true".equalsIgnoreCase(string.toString())) {
                showFrame = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class FrameStream
    extends OutputStream {
        private DateFormat format = DateFormat.getTimeInstance(2);

        private FrameStream() {
        }

        public void write(int n2) throws IOException {
            Document document = console.getDocument();
            try {
                document.insertString(document.getLength(), new String(new char[]{(char)n2}), null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            Document document = console.getDocument();
            try {
                String string = new String(byArray, n2, n3);
                SimpleAttributeSet simpleAttributeSet = null;
                if (string.startsWith(Logger.CRITICAL_PREFIX)) {
                    simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(simpleAttributeSet, Color.RED);
                    StyleConstants.setBold(simpleAttributeSet, true);
                }
                if (string.startsWith(Logger.ERROR_PREFIX)) {
                    simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(simpleAttributeSet, Color.RED);
                }
                if (string.startsWith(Logger.WARNING_PREFIX)) {
                    simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(simpleAttributeSet, Color.ORANGE);
                }
                if (string.startsWith(Logger.DEBUG_PREFIX)) {
                    simpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setForeground(simpleAttributeSet, Color.GRAY);
                }
                if (showTime && n3 > Logger.CRITICAL_PREFIX.length()) {
                    document.insertString(document.getLength(), this.format.format(new Date()), simpleAttributeSet);
                }
                document.insertString(document.getLength(), string, simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

