/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftEntry> hash = new HashMap<K, SoftEntry>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public synchronized V get(Object object) {
        V v2 = null;
        SoftReference softReference = this.hash.get(object);
        if (softReference != null && (v2 = (V)softReference.get()) == null) {
            this.hash.remove(object);
        }
        return v2;
    }

    private synchronized void processQueue() {
        SoftEntry softEntry;
        while ((softEntry = (SoftEntry)this.queue.poll()) != null) {
            this.hash.remove(softEntry.key);
        }
    }

    @Override
    public synchronized V put(K k2, V v2) {
        this.processQueue();
        if (v2 == null) {
            return this.remove(k2);
        }
        SoftEntry softEntry = this.hash.put(k2, new SoftEntry(k2, v2, this.queue));
        if (softEntry != null) {
            return (V)softEntry.get();
        }
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        this.processQueue();
        SoftEntry softEntry = this.hash.remove(object);
        if (softEntry != null) {
            return (V)softEntry.get();
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public synchronized int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (SoftEntry softEntry : this.hash.values()) {
            hashSet.add(softEntry);
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftEntry
    extends SoftReference<V>
    implements Map.Entry<K, V> {
        private final K key;

        public SoftEntry(K k2, V v2, ReferenceQueue<V> referenceQueue) {
            super(v2, referenceQueue);
            this.key = k2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V v2) {
            throw new UnsupportedOperationException("SoftReferenced values cannot be updated!");
        }
    }
}

