/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class URLUtils {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static URI encode(String string) {
        block4: {
            if (string != null) {
                String string2 = null;
                int n2 = string.indexOf(35);
                if (n2 >= 0 && n2 < string.length() - 1) {
                    string2 = string.substring(n2 + 1);
                    string = string.substring(0, n2);
                }
                try {
                    return new URI(null, string, string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!Logger.doesLog(4)) break block4;
                    Logger.debug(uRISyntaxException.getMessage());
                }
            }
        }
        return null;
    }

    private static char[] charToHex(int n2) {
        char[] cArray;
        if (n2 < 256) {
            cArray = new char[]{'0', '0'};
        } else if (n2 < 65536) {
            cArray = new char[]{'0', '0', '%', '0', '0'};
        } else {
            return new char[]{'0'};
        }
        int n3 = cArray.length - 1;
        while (n2 != 0 && n2 != -1) {
            cArray[n3] = HEX[n2 & 0xF];
            n2 >>= 4;
            if (--n3 != 2) continue;
            n3 = 1;
        }
        return cArray;
    }

    private static String decode(String string) {
        block3: {
            if (string != null) {
                try {
                    return URLDecoder.decode(string, ENCODING_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!Logger.doesLog(1)) break block3;
                    Logger.error(unsupportedEncodingException);
                }
            }
        }
        return string;
    }

    public static String safeEncode(String string) {
        if (string == null) {
            return null;
        }
        if (!string.equals(URLUtils.decode(string))) {
            return string;
        }
        URI uRI = URLUtils.encode(string.replace('\\', '/'));
        if (uRI != null) {
            return uRI.toString();
        }
        return string;
    }

    public static URL safeEncode(URL uRL) {
        block5: {
            if (uRL == null) {
                return null;
            }
            String string = uRL.toString();
            String string2 = URLUtils.decode(string);
            if (string.indexOf(92) < 0 && !string.equals(string2)) {
                return uRL;
            }
            URI uRI = URLUtils.encode(string.replace('\\', '/'));
            if (uRI != null && !string.equals(uRI.toString())) {
                try {
                    return uRI.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!Logger.doesLog(2)) break block5;
                    Logger.warning("Could not encode the URL '" + uRL + "'. This may lead to unresolved links or images!");
                }
            }
        }
        return uRL;
    }

    public static URI safeDecode(String string) {
        if (string == null) {
            return null;
        }
        string = URLUtils.decode(string);
        try {
            return new URI(null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (Logger.doesLog(1)) {
                Logger.error(uRISyntaxException);
            }
            return null;
        }
    }

    public static String transcode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ' || c2 > '\u007f') {
                byte[] byArray = String.valueOf(c2).getBytes(string2);
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    stringBuilder.append("%");
                    stringBuilder.append(URLUtils.charToHex(byArray[i3]));
                }
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

