/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.utils.BMPDecoder;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class UrlBMPDecoder
extends BMPDecoder {
    private URL location;
    private InputStream input;
    private byte[] intArray = new byte[4];
    private byte[] rgb24Array = new byte[3];
    private byte[] shortArray = new byte[2];
    private byte[] byteArray = new byte[1];
    private int readLen;
    private long skipLen;

    public UrlBMPDecoder(URL uRL) {
        this.location = uRL;
    }

    public Image decodeImage(int n2, int n3) throws IOException {
        URLConnection uRLConnection = this.location.openConnection();
        uRLConnection.connect();
        this.input = uRLConnection.getInputStream();
        Image image = super.decodeImage(n2, n3);
        this.input.close();
        return image;
    }

    private void doRead(byte[] byArray) throws IOException {
        if (this.input == null) {
            throw new IOException("Socket not yet open.");
        }
        this.readLen = this.input.read(byArray, 0, byArray.length);
        if (this.readLen < byArray.length) {
            int n2 = this.input.read(byArray, this.readLen, byArray.length - this.readLen);
            while (n2 >= 0 && this.readLen < byArray.length) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.readLen += n2;
                if (byArray.length <= this.readLen) continue;
                n2 = this.input.read(byArray, this.readLen, byArray.length - this.readLen);
            }
        }
        if (this.readLen < byArray.length) {
            throw new IOException("Premature end of image data.");
        }
    }

    protected byte readByte() throws IOException {
        this.doRead(this.byteArray);
        return this.byteArray[0];
    }

    protected int readInt() throws IOException {
        this.doRead(this.intArray);
        int n2 = (this.intArray[0] & 0xFF) + ((this.intArray[1] & 0xFF) << 8) + ((this.intArray[2] & 0xFF) << 16) + (this.intArray[3] << 24);
        return n2;
    }

    protected int readShort() throws IOException {
        this.doRead(this.shortArray);
        int n2 = (this.shortArray[0] & 0xFF) + (this.shortArray[1] << 8);
        return n2;
    }

    protected int readRGB24() throws IOException {
        this.doRead(this.rgb24Array);
        int n2 = 0xFF000000 | this.rgb24Array[0] & 0xFF | (this.rgb24Array[1] & 0xFF) << 8 | (this.rgb24Array[2] & 0xFF) << 16;
        return n2;
    }

    protected void skipBytes(int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.skipLen = this.input.skip(n2);
        if (this.skipLen < (long)n2) {
            throw new IOException("Premature end of image data.");
        }
    }
}

