/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.BackgroundPosition;
import com.inet.html.parser.converter.BackgroundRepeat;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBackgroundPainter;
import com.inet.html.views.RenderContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.Element;

public class BackgroundPainter
implements IBackgroundPainter {
    private BoxView view;
    private final Element elem;
    private ColorValue backgroundValue;
    private boolean initDone = false;
    private int refX = Integer.MIN_VALUE;
    private int refY = Integer.MIN_VALUE;
    private ImageData imageData = null;
    private Rectangle lastPaint = new Rectangle();
    private RemoteImage fetcher;
    private RenderContext renderContext;

    public BackgroundPainter(Element element, RenderContext renderContext) {
        this.elem = element;
        this.renderContext = renderContext;
        this.init(true);
    }

    public BackgroundPainter(Element element, BoxView boxView) {
        this.view = boxView;
        this.elem = element;
        this.renderContext = boxView != null ? boxView.getRenderContext() : null;
        this.init(false);
    }

    private void init(boolean bl2) {
        UriValue uriValue = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_IMAGE);
        if (uriValue != null && !uriValue.isNone()) {
            this.imageData = new ImageData();
            this.imageData.backgroundImage = uriValue;
            BackgroundRepeat backgroundRepeat = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_REPEAT);
            if (backgroundRepeat != null) {
                this.imageData.repeat = backgroundRepeat.getRepeatType();
            }
            this.imageData.bgPosition = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_POSITION);
            this.loadImage();
        }
        this.backgroundValue = StyleResolver.getAttributeValue(this.elem, AttributeFinder.BACKGROUND_COLOR);
    }

    public void paintBackground(Graphics graphics, int n2, int n3, int n4, int n5, BoxView boxView) {
        Object object;
        ColorValue colorValue;
        if (this.view == null) {
            this.view = boxView;
        }
        if (this.refX == Integer.MIN_VALUE && this.refY == Integer.MIN_VALUE) {
            this.view = boxView;
        }
        if (this.view != null && this.view.getElement() == boxView.getElement() && this.view.getStartOffset() == boxView.getStartOffset()) {
            this.refX = n2;
            this.refY = n3;
        }
        if ((colorValue = this.backgroundValue) != null && !colorValue.isTransparent()) {
            object = colorValue.getValue();
            graphics.setColor((Color)object);
            graphics.fillRect(n2, n3, n4, n5);
        }
        object = graphics.getClip();
        if (this.imageData != null && this.imageData.image != null) {
            this.lastPaint.setBounds(new Rectangle(n2, n3, n4, n5));
            if (this.imageData.image != null && this.imageData.image.getWidth(this.imageData.imageObserver) > 0 && this.imageData.image.getHeight(this.imageData.imageObserver) > 0) {
                Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
                Rectangle rectangle2 = graphics.getClipBounds();
                if (rectangle2 != null) {
                    rectangle = rectangle.intersection(rectangle2);
                }
                if (rectangle.height <= 0 || rectangle.getHeight() <= 0.0 || rectangle.width <= 0) {
                    return;
                }
                graphics.setClip(rectangle);
                int n6 = this.imageData.image.getWidth(this.imageData.imageObserver);
                int n7 = this.imageData.image.getHeight(this.imageData.imageObserver);
                int n8 = this.refX;
                int n9 = this.refY;
                if (this.imageData.bgPosition != null) {
                    n8 = (int)((float)n8 + this.imageData.bgPosition.getPercentX().calculateValue(n4 - n6, this.getReferenceView()));
                    n9 = (int)((float)n9 + this.imageData.bgPosition.getPercentY().calculateValue(n5 - n7, this.getReferenceView()));
                }
                int n10 = Math.min(n2 + n4, rectangle.x + rectangle.width);
                int n11 = Math.min(n3 + n5, rectangle.y + rectangle.height);
                int n12 = n2 - (n2 - n8) % n6;
                n12 += (rectangle.x - n12) / n6 * n6;
                int n13 = n3 - (n3 - n9) % n7;
                n13 += (rectangle.y - n13) / n7 * n7;
                switch (this.imageData.repeat) {
                    case 0: {
                        for (n8 = n12; n8 < n10; n8 += n6) {
                            for (n9 = n13; n9 < n11; n9 += n7) {
                                graphics.drawImage(this.imageData.image, n8, n9, this.imageData.imageObserver);
                            }
                        }
                        break;
                    }
                    case 1: {
                        while (n8 < n10) {
                            graphics.drawImage(this.imageData.image, n8, n9, this.imageData.imageObserver);
                            n8 += n6;
                        }
                        break;
                    }
                    case 2: {
                        while (n9 < n11) {
                            graphics.drawImage(this.imageData.image, n8, n9, this.imageData.imageObserver);
                            n9 += n7;
                        }
                        break;
                    }
                    case 3: {
                        graphics.drawImage(this.imageData.image, n8, n9, this.imageData.imageObserver);
                    }
                }
            }
        }
        graphics.setClip((Shape)object);
    }

    private void loadImage() {
        if (this.imageData == null) {
            this.imageData = new ImageData();
        }
        if (this.imageData.backgroundImage != null) {
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.elem.getDocument();
            URL uRL = inetHtmlDocument.getBase();
            try {
                RenderContext renderContext;
                if (uRL == null) {
                    uRL = new File("./bin/").toURI().toURL();
                }
                if (this.imageData.backgroundImage.getBaseURL() != null) {
                    uRL = this.imageData.backgroundImage.getBaseURL();
                }
                URL uRL2 = new URL(uRL, this.imageData.backgroundImage.getUrl());
                this.imageData.imageObserver = new ImageHandler(inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
                this.fetcher = ImageCache.getStaticInstance().getImage(uRL2.toString(), uRL, this.imageData.imageObserver);
                RenderContext renderContext2 = renderContext = this.renderContext != null ? this.renderContext : this.view.getRenderContext();
                if (this.fetcher != null && this.fetcher.getStatus() <= 1) {
                    renderContext.notifyImageLoad(this.fetcher);
                }
                if (this.imageData.image != null) {
                    this.imageData.image.getHeight(this.imageData.imageObserver);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    protected String getImageSrc() {
        if (this.elem.getAttributes().isDefined((Object)HTML.Attribute.BACKGROUND)) {
            return this.elem.getAttributes().getAttribute((Object)HTML.Attribute.BACKGROUND).toString();
        }
        if (this.elem.getAttributes().isDefined((Object)HTML.Attribute.BACKGROUND)) {
            return this.elem.getAttributes().getAttribute((Object)HTML.Attribute.BACKGROUND).toString();
        }
        return null;
    }

    private void repaint(long l2) {
        Container container;
        if (this.view != null && (container = this.view.getContainer()) != null && !this.lastPaint.isEmpty()) {
            container.repaint(l2, this.lastPaint.x, this.lastPaint.y, this.lastPaint.width, this.lastPaint.height);
        }
    }

    public BoxView getReferenceView() {
        return this.view;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public void setInitDone() {
        this.initDone = true;
    }

    public ColorValue getBackgroundValue() {
        return this.backgroundValue;
    }

    public void setBackgroundValue(ColorValue colorValue) {
        this.backgroundValue = colorValue;
    }

    public void setReferenceView(BoxView boxView) {
        this.view = boxView;
    }

    public Element getElement() {
        return this.elem;
    }

    public Rectangle getLastPaint() {
        return this.lastPaint;
    }

    public void setLastPaint(Rectangle rectangle) {
        this.lastPaint = rectangle;
    }

    public boolean isRelevant() {
        return this.isBackgroundOpaque();
    }

    public boolean isBackgroundOpaque() {
        if (this.backgroundValue != null && !this.backgroundValue.isTransparent()) {
            return true;
        }
        return this.imageData != null && this.imageData.backgroundImage != null && !this.imageData.backgroundImage.isNone();
    }

    private class ImageHandler
    implements AnimationObserver {
        private final boolean doAnimate;

        public ImageHandler(boolean bl2) {
            this.doAnimate = bl2;
        }

        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            if (image != null) {
                BackgroundPainter.this.imageData.image = image;
            }
            if (BackgroundPainter.this.view == null || BackgroundPainter.this.view.getParent() == null) {
                return false;
            }
            if ((n2 & 0xC0) != 0) {
                BackgroundPainter.this.getReferenceView().getRenderContext().notifyImageLoadDone(BackgroundPainter.this.fetcher);
                BackgroundPainter.this.imageData.image = null;
                return false;
            }
            if ((n2 & 0x30) != 0) {
                BackgroundPainter.this.getReferenceView().getRenderContext().notifyImageLoadDone(BackgroundPainter.this.fetcher);
                BackgroundPainter.this.repaint(10L);
            } else if ((n2 & 8) != 0) {
                BackgroundPainter.this.repaint(100L);
            }
            return (n2 & 0x20) == 0;
        }

        public boolean doAnimate() {
            return this.doAnimate;
        }
    }

    private class ImageData {
        private AnimationObserver imageObserver;
        private Image image;
        private UriValue backgroundImage;
        private int repeat;
        private BackgroundPosition bgPosition;

        private ImageData() {
        }
    }
}

