/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.BackgroundPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.IBoxPainter;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.text.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxPainter
extends BackgroundPainter
implements IBoxPainter {
    private final BoxView view;
    private Insets padding;
    private Insets borderInsets;
    private Insets borderStyles;
    private Insets margins;
    private ColorValue borderTopColor;
    private ColorValue borderLeftColor;
    private ColorValue borderRightColor;
    private ColorValue borderBottomColor;
    private boolean hasRelativePadding = false;
    private boolean hasRelativeMargin = false;
    private static final int MODE_BORDER = 0;
    private static final int MODE_PADDING = 1;
    private static final int MODE_MARGIN = 2;
    private boolean relevant = true;

    protected BoxPainter(BoxView boxView) {
        super(boxView != null ? boxView.getElement() : null, boxView);
        this.view = boxView;
        this.init(true);
    }

    protected BoxPainter(BoxView boxView, Element element) {
        super(element, boxView);
        this.view = boxView;
        this.init(false);
    }

    public static IBoxPainter createBoxPainter(ContentView contentView, Element element) {
        IBoxPainter iBoxPainter;
        if (element != null) {
            iBoxPainter = contentView.getBoxPainter(element);
            if (iBoxPainter == null && (iBoxPainter = new BoxPainter(contentView, element)).isRelevant()) {
                contentView.addBoxPainter(element, iBoxPainter);
            }
        } else {
            iBoxPainter = new BoxPainter(contentView);
        }
        if (!iBoxPainter.isRelevant()) {
            return contentView.getRenderContext().getEmptyBoxPainter();
        }
        return iBoxPainter;
    }

    public static IBoxPainter createBoxPainter(BoxView boxView, ContentView contentView, Element element) {
        if (element != null) {
            IBoxPainter iBoxPainter = boxView.getBoxPainter(element);
            if (iBoxPainter == null) {
                iBoxPainter = new BoxPainter(boxView, element);
                iBoxPainter.setReferenceView(contentView);
                boxView.addBoxPainter(element, iBoxPainter);
            }
            return iBoxPainter;
        }
        BoxPainter boxPainter = new BoxPainter(boxView);
        boxPainter.setReferenceView(contentView);
        return boxPainter;
    }

    protected static IBoxPainter createRootPainter(BoxView boxView) {
        return new BoxPainter(boxView);
    }

    public static IBoxPainter createBoxPainter(BoxView boxView) {
        BoxPainter boxPainter = new BoxPainter(boxView);
        if (!boxPainter.isRelevant()) {
            return boxView.getRenderContext().getEmptyBoxPainter();
        }
        return boxPainter;
    }

    private void init(boolean bl2) {
        this.borderInsets = this.getInsets(0);
        Element element = this.getElement();
        BorderStyleValue borderStyleValue = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_TOP_STYLE);
        BorderStyleValue borderStyleValue2 = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_LEFT_STYLE);
        BorderStyleValue borderStyleValue3 = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_BOTTOM_STYLE);
        BorderStyleValue borderStyleValue4 = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_RIGHT_STYLE);
        this.borderStyles = new Insets(borderStyleValue != null ? borderStyleValue.getStyle() : 0, borderStyleValue2 != null ? borderStyleValue2.getStyle() : 0, borderStyleValue3 != null ? borderStyleValue3.getStyle() : 0, borderStyleValue4 != null ? borderStyleValue4.getStyle() : 0);
        if (this.borderStyles.equals(EMPTY_INSETS)) {
            this.borderStyles = EMPTY_INSETS;
        }
        if (this.isInVisibleStyle(this.borderStyles.top)) {
            this.borderInsets.top = 0;
        } else {
            this.borderTopColor = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_TOP_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.left)) {
            this.borderInsets.left = 0;
        } else {
            this.borderLeftColor = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_LEFT_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.bottom)) {
            this.borderInsets.bottom = 0;
        } else {
            this.borderBottomColor = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_BOTTOM_COLOR);
        }
        if (this.isInVisibleStyle(this.borderStyles.right)) {
            this.borderInsets.right = 0;
        } else {
            this.borderRightColor = StyleResolver.getAttributeValue(element, AttributeFinder.BORDER_RIGHT_COLOR);
        }
        this.padding = this.getInsets(1);
        this.margins = bl2 ? this.getInsets(2) : EMPTY_INSETS;
        this.relevant = this.isRelevant();
    }

    private Insets getInsets(int n2) {
        return this.getInsets(n2, 0);
    }

    private Insets getInsets(int n2, int n3) {
        Element element = this.getElement();
        Insets insets = null;
        switch (n2) {
            case 0: {
                insets = new Insets(this.getLengthInt(element, AttributeFinder.BORDER_TOP_WIDTH, n2, n3), this.getLengthInt(element, AttributeFinder.BORDER_LEFT_WIDTH, n2, n3), this.getLengthInt(element, AttributeFinder.BORDER_BOTTOM_WIDTH, n2, n3), this.getLengthInt(element, AttributeFinder.BORDER_RIGHT_WIDTH, n2, n3));
                break;
            }
            case 1: {
                insets = new Insets(this.getLengthInt(element, AttributeFinder.PADDING_TOP, n2, n3), this.getLengthInt(element, AttributeFinder.PADDING_LEFT, n2, n3), this.getLengthInt(element, AttributeFinder.PADDING_BOTTOM, n2, n3), this.getLengthInt(element, AttributeFinder.PADDING_RIGHT, n2, n3));
                break;
            }
            case 2: {
                insets = new Insets(this.getLengthInt(element, AttributeFinder.MARGIN_TOP, n2, n3), this.getLengthInt(element, AttributeFinder.MARGIN_LEFT, n2, n3), this.getLengthInt(element, AttributeFinder.MARGIN_BOTTOM, n2, n3), this.getLengthInt(element, AttributeFinder.MARGIN_RIGHT, n2, n3));
            }
        }
        if (insets == null || EMPTY_INSETS.equals(insets)) {
            return EMPTY_INSETS;
        }
        return insets;
    }

    @Override
    public void updateRelativeValues(int n2) {
        if (this.hasRelativeMargin) {
            this.margins = this.getInsets(2, n2);
        }
        if (this.hasRelativePadding) {
            this.padding = this.getInsets(1, n2);
        }
    }

    private int getLengthInt(Element element, AttributeFinder<?> attributeFinder, int n2, int n3) {
        LengthUnit lengthUnit = (LengthUnit)StyleResolver.getAttributeValue(element, attributeFinder);
        if (lengthUnit == null || lengthUnit.getType() == -1) {
            return 0;
        }
        if (lengthUnit.getType() == 1) {
            this.hasRelativeMargin |= n2 == 2;
            this.hasRelativePadding |= n2 == 1;
        }
        if (lengthUnit.getType() == 2) {
            n3 = (int)this.getView().getFontSize();
            this.hasRelativeMargin |= n2 == 2;
            this.hasRelativePadding |= n2 == 1;
        }
        float f2 = lengthUnit.calculateValue(n3, this.view);
        return Math.round(f2);
    }

    protected boolean isInVisibleStyle(int n2) {
        return n2 == 0 || n2 == 9;
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public Insets getMargins() {
        return this.margins;
    }

    @Override
    public Insets getBorderInsets() {
        return this.borderInsets;
    }

    @Override
    public Insets getBorderStyles() {
        return this.borderStyles;
    }

    @Override
    public int getTotalWidthGain() {
        int n2 = this.getBorderInsets().left + this.getBorderInsets().right;
        int n3 = this.getPadding().left + this.getPadding().right;
        int n4 = this.getMargins().left + this.getMargins().right;
        return n2 + n3 + n4;
    }

    @Override
    public int getTotalHeightGain() {
        int n2 = this.getBorderInsets().top + this.getBorderInsets().bottom;
        int n3 = this.getPadding().top + this.getPadding().bottom;
        int n4 = this.getMargins().top + this.getMargins().bottom;
        return n2 + n3 + n4;
    }

    @Override
    public int getLeftBorderPadding() {
        return this.getBorderInsets().left + this.getPadding().left;
    }

    @Override
    public int getTopBorderPadding() {
        return this.getBorderInsets().top + this.getPadding().top;
    }

    @Override
    public int getBottomBorderPadding() {
        return this.getBorderInsets().bottom + this.getPadding().bottom;
    }

    @Override
    public int getRightBorderPadding() {
        return this.getBorderInsets().right + this.getPadding().right;
    }

    @Override
    public int getTotalLeftGain() {
        return this.getBorderInsets().left + this.getPadding().left + this.getMargins().left;
    }

    @Override
    public int getTotalTopGain() {
        return this.getBorderInsets().top + this.getPadding().top + this.getMargins().top;
    }

    protected static void drawBorderLine(Graphics2D graphics2D, float f2, float f3, float f4, float f5, int n2, float f6) {
        BasicStroke basicStroke;
        float f7 = f2 + f4;
        float f8 = f3 + f5;
        switch (n2) {
            case 0: 
            case 9: {
                return;
            }
            case 6: {
                float f9 = 3.0f * f6;
                float f10 = Math.max(f4, f5) - f9;
                int n3 = (int)(f10 / (2.0f * f9));
                float f11 = n3 == 0 ? 0.0f : (f10 - f9 * (float)n3) / (float)n3;
                float[] fArray = new float[]{f9, f11};
                basicStroke = new BasicStroke(f6, 0, 2, 10.0f, fArray, 0.0f);
                break;
            }
            case 5: {
                float f9 = Math.max(f4, f5) - f6;
                int n4 = (int)(f9 / (2.0f * f6));
                float f12 = n4 == 0 ? 0.0f : (f9 - f6 * (float)n4) / (float)n4;
                float[] fArray = new float[]{f6, f12};
                basicStroke = new BasicStroke(f6, 0, 2, 10.0f, fArray, 0.0f);
                break;
            }
            default: {
                basicStroke = new BasicStroke(f6, 0, 2);
            }
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(new Line2D.Float(f2, f3, f7, f8));
        graphics2D.setStroke(stroke);
    }

    @Override
    public void paint(Graphics graphics, Rectangle rectangle, int n2, BoxView boxView) {
        this.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2, boxView);
    }

    @Override
    public void paint(Graphics graphics, int n2, int n3, int n4, int n5, int n6, BoxView boxView) {
        Area area;
        Polygon polygon;
        float f2;
        int n7;
        int n8;
        ColorValue colorValue;
        if (!this.relevant) {
            return;
        }
        if (n6 != 4) {
            this.paintBackground(graphics, n2, n3, n4, n5, boxView);
        }
        Shape shape = graphics.getClip();
        Area area2 = null;
        Insets insets = null;
        if (n6 != 0 && n6 != 4) {
            insets = (Insets)this.borderInsets.clone();
            switch (n6) {
                case 1: {
                    this.borderInsets.right = 0;
                    break;
                }
                case 2: {
                    this.borderInsets.right = 0;
                    this.borderInsets.left = 0;
                    break;
                }
                case 3: {
                    this.borderInsets.left = 0;
                }
            }
        }
        if (this.borderInsets.top > 0) {
            colorValue = this.borderTopColor;
            if (colorValue == null) {
                colorValue = AttributeFinder.COLOR.getAttributeValue(this.view);
            }
            graphics.setColor(colorValue.getValue());
            n8 = this.borderStyles.top;
            n7 = this.borderInsets.top;
            f2 = n7;
            polygon = new Polygon();
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2 + n4, n3);
            polygon.addPoint(n2 + n4 - this.borderInsets.right, n3 + n7);
            polygon.addPoint(n2 + this.borderInsets.left, n3 + n7);
            area = new Area(polygon);
            if (shape != null) {
                area2 = new Area(shape);
                area.intersect(area2);
            }
            graphics.setClip(area);
            if (n8 == 8) {
                BoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)n3 + (f2 /= 3.0f) * 2.5f, n4, 0.0f, n8, f2 * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)n3 + f2 * 0.5f, n4, 0.0f, n8, f2 * 1.01f);
        }
        if (this.borderInsets.left > 0) {
            colorValue = this.borderLeftColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n8 = this.borderStyles.left;
            n7 = this.borderInsets.left;
            f2 = n7;
            polygon = new Polygon();
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2, n3 + n5);
            polygon.addPoint(n2 + n7, n3 + n5 - this.borderInsets.bottom);
            polygon.addPoint(n2 + n7, n3 + this.borderInsets.top);
            area = new Area(polygon);
            if (shape != null) {
                if (area2 == null) {
                    area2 = new Area(shape);
                }
                area.intersect(area2);
            }
            graphics.setClip(area);
            if (n8 == 8) {
                BoxPainter.drawBorderLine((Graphics2D)graphics, (float)n2 + (f2 /= 3.0f) * 2.5f, n3, 0.0f, n5, n8, f2 * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)graphics, (float)n2 + f2 * 0.5f, n3, 0.0f, n5, n8, f2 * 1.01f);
        }
        if (this.borderInsets.bottom > 0) {
            colorValue = this.borderBottomColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n8 = this.borderStyles.bottom;
            n7 = this.borderInsets.bottom;
            f2 = n7;
            polygon = new Polygon();
            polygon.addPoint(n2, n3 + n5);
            polygon.addPoint(n2 + n4, n3 + n5);
            polygon.addPoint(n2 + n4 - this.borderInsets.right, n3 + n5 - n7);
            polygon.addPoint(n2 + this.borderInsets.left, n3 + n5 - n7);
            area = new Area(polygon);
            if (shape != null) {
                if (area2 == null) {
                    area2 = new Area(shape);
                }
                area.intersect(area2);
            }
            graphics.setClip(area);
            if (n8 == 8) {
                BoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)(n3 + n5) - (f2 /= 3.0f) * 2.5f, n4, 0.0f, n8, f2 * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)graphics, n2, (float)(n3 + n5) - f2 * 0.5f, n4, 0.0f, n8, f2 * 1.01f);
        }
        if (this.borderInsets.right > 0) {
            colorValue = this.borderRightColor;
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.COLOR);
            }
            graphics.setColor(colorValue.getValue());
            n8 = this.borderStyles.right;
            n7 = this.borderInsets.right;
            f2 = n7;
            polygon = new Polygon();
            polygon.addPoint(n2 + n4, n3);
            polygon.addPoint(n2 + n4, n3 + n5);
            polygon.addPoint(n2 + n4 - n7, n3 + n5 - this.borderInsets.bottom);
            polygon.addPoint(n2 + n4 - n7, n3 + this.borderInsets.top);
            area = new Area(polygon);
            if (shape != null) {
                if (area2 == null) {
                    area2 = new Area(shape);
                }
                area.intersect(area2);
            }
            graphics.setClip(area);
            if (n8 == 8) {
                BoxPainter.drawBorderLine((Graphics2D)graphics, (float)(n2 + n4) - (f2 /= 3.0f) * 2.5f, n3, 0.0f, n5, n8, f2 * 1.01f);
            }
            BoxPainter.drawBorderLine((Graphics2D)graphics, (float)(n2 + n4) - f2 * 0.5f, n3, 0.0f, n5, n8, f2 * 1.01f);
        }
        if (n6 != 0 && n6 != 4) {
            this.borderInsets = insets;
        }
        if (area2 != null || shape == null) {
            graphics.setClip(shape);
        }
    }

    @Override
    public BoxView getView() {
        return this.view;
    }

    @Override
    public ColorValue getBorderTopColor() {
        return this.borderTopColor;
    }

    @Override
    public ColorValue getBorderLeftColor() {
        return this.borderLeftColor;
    }

    @Override
    public ColorValue getBorderRightColor() {
        return this.borderRightColor;
    }

    @Override
    public ColorValue getBorderBottomColor() {
        return this.borderBottomColor;
    }

    @Override
    public void setBorderBottomColor(ColorValue colorValue) {
        this.borderBottomColor = colorValue;
    }

    @Override
    public void setBorderLeftColor(ColorValue colorValue) {
        this.borderLeftColor = colorValue;
    }

    @Override
    public void setBorderRightColor(ColorValue colorValue) {
        this.borderRightColor = colorValue;
    }

    @Override
    public void setBorderTopColor(ColorValue colorValue) {
        this.borderTopColor = colorValue;
    }

    @Override
    public boolean isRelevant() {
        if (super.isRelevant()) {
            return true;
        }
        if (!EMPTY_INSETS.equals(this.margins)) {
            return true;
        }
        if (!EMPTY_INSETS.equals(this.padding)) {
            return true;
        }
        if (this.isBorderVisible(this.borderLeftColor, this.borderInsets.left, this.borderStyles.left)) {
            return true;
        }
        if (this.isBorderVisible(this.borderTopColor, this.borderInsets.top, this.borderStyles.top)) {
            return true;
        }
        if (this.isBorderVisible(this.borderRightColor, this.borderInsets.right, this.borderStyles.right)) {
            return true;
        }
        return this.isBorderVisible(this.borderBottomColor, this.borderInsets.bottom, this.borderStyles.bottom);
    }

    private boolean isBorderVisible(ColorValue colorValue, int n2, int n3) {
        return n2 != 0 && n3 != 0 && colorValue != null && !colorValue.isTransparent();
    }

    @Override
    public void updateRelevance() {
        this.relevant = this.isRelevant();
    }

    @Override
    public void setBorderStyles(Insets insets) {
        this.borderStyles = insets;
    }

    @Override
    public void setBorderInsets(Insets insets) {
        this.borderInsets = insets;
    }

    @Override
    public void setPadding(Insets insets) {
        this.padding = insets;
    }

    @Override
    public void setMargins(Insets insets) {
        this.margins = insets;
    }

    @Override
    public Insets setBorderInsets() {
        if (this.borderInsets == EMPTY_INSETS) {
            this.borderInsets = new Insets(0, 0, 0, 0);
        }
        return this.borderInsets;
    }

    @Override
    public Insets setBorderStyles() {
        if (this.borderStyles == EMPTY_INSETS) {
            this.borderStyles = new Insets(0, 0, 0, 0);
        }
        return this.borderStyles;
    }

    @Override
    public Insets setMargins() {
        if (this.margins == EMPTY_INSETS) {
            this.margins = new Insets(0, 0, 0, 0);
        }
        return this.margins;
    }

    @Override
    public Insets setPadding() {
        if (this.padding == EMPTY_INSETS) {
            this.padding = new Insets(0, 0, 0, 0);
        }
        return this.padding;
    }

    @Override
    public boolean useDefaultLookAndFeelBorder() {
        return this.borderStyles != null && this.borderStyles.left == 10 && this.borderStyles.right == 10 && this.borderStyles.top == 10 && this.borderStyles.bottom == 10;
    }
}

