/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ClearValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.Direction;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListStyleType;
import com.inet.html.parser.converter.Overflow;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.parser.converter.UnicodeBidi;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.VerticalAlign;
import com.inet.html.parser.converter.VisibilityValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.CSSRules;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import com.inet.html.views.TableBoxPainter;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public abstract class BoxView
extends View {
    private IBoxPainter box;
    private LengthUnit widthUnit;
    private LengthUnit heightUnit;
    private int contentWidth = 0;
    private int contentHeight = 0;
    private int outerWidth = 0;
    private int outerHeight = 0;
    private int contentVerticalOffset = 0;
    private float fontSize = 12.0f;
    private int offset;
    private int length = -1;
    private boolean isMarker = false;
    private boolean isBreak;
    private byte visibility = 0;
    private LengthUnit lineHeight;
    private byte vAlign = 1;
    private Boolean isListItemWithMarker = null;
    private byte justification;
    private short firstLineBaseLine = 0;
    private byte whiteSpace = 0;
    private byte autoMarginJustify = (byte)-1;
    private byte clear;
    private byte overflow = 0;
    private byte display = (byte)3;
    private byte position = 0;
    private byte floatValue = 0;
    private byte direction = 0;
    private byte bidi = 0;
    private boolean isNativeLTR = true;
    private boolean preset;
    private HashMap<Element, IBoxPainter> childPainters;
    public static final int BASELINE = 2;
    public static final int STATUS_UPTODATE = 0;
    public static final int STATUS_REQ_LAYOUT = 1;
    public static final int STATUS_REQ_PRELAYOUT = 2;
    private int status = 2;
    private ViewPainter painter;
    private HtmlRootView root;
    private RenderContext renderContext;
    private Object elementName;

    public BoxView(Element element) {
        super(element);
        if (element == null) {
            return;
        }
        this.elementName = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        this.isBreak = this.elementName == HTML.Tag.BR;
        Document document = element.getDocument();
        if (document instanceof InetHtmlDocument) {
            ((InetHtmlDocument)document).checkInit(element);
        }
        this.painter = null;
    }

    public BoxView(Element element, ViewPainter viewPainter) {
        this(element);
        this.painter = viewPainter;
    }

    public IBoxPainter getBox() {
        return this.box;
    }

    public void setParent(View view) {
        if (this.getParent() != null && this.getParent() == view) {
            return;
        }
        super.setParent(view);
        if (view != null) {
            this.renderContext = this.getHTMLRoot().getRenderContext();
            this.setPropertiesFromAttributes(false);
        }
    }

    protected final void changeOnlyParent(View view) {
        super.setParent(view);
    }

    public void factoryPreset(byte by2, byte by3, byte by4) {
        this.floatValue = by2;
        this.display = by3;
        this.position = by4;
        this.preset = true;
    }

    protected void setPropertiesFromAttributes(boolean bl2) {
        Object object;
        VerticalAlign verticalAlign;
        if (this.getParent() == null) {
            return;
        }
        WhiteSpace whiteSpace = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.WHITE_SPACE);
        if (whiteSpace != null) {
            this.whiteSpace = whiteSpace.getValue();
        }
        if ((verticalAlign = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VERTICAL_ALIGN)) != null) {
            this.vAlign = verticalAlign.getAlign();
        }
        if (this.elementName != HTML.Tag.CONTENT) {
            VisibilityValue visibilityValue;
            object = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.CLEAR);
            if (object != null) {
                this.clear = ((ClearValue)object).getClear();
            }
            if ((visibilityValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VISIBILITY)) != null) {
                this.visibility = visibilityValue.getVisibility();
            }
            this.setBlockProperties();
        }
        if ((object = this.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) == null) {
            if (this.getParent() instanceof BoxView) {
                this.fontSize = ((BoxView)this.getParent()).getFontSize();
            }
        } else {
            this.fontSize = object.getClass() == Float.class ? ((Float)object).floatValue() : ((FontSize)object).getValue(this);
        }
        this.lineHeight = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.LINE_HEIGHT);
        this.box = this.createBoxPainter();
    }

    protected IBoxPainter createBoxPainter() {
        if (this.display == 12) {
            return new TableBoxPainter(this);
        }
        return BoxPainter.createBoxPainter(this);
    }

    protected void setBlockProperties() {
        SingleAttributeValue singleAttributeValue;
        SingleAttributeValue singleAttributeValue2;
        TextAlign textAlign;
        this.widthUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.WIDTH);
        this.heightUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.HEIGHT);
        Overflow overflow = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.OVERFLOW);
        if (overflow != null) {
            this.overflow = overflow.getOverflow();
        }
        if ((textAlign = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TEXT_ALIGN)) != null) {
            this.justification = textAlign.getJustification();
        }
        if (!this.preset) {
            this.display = this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT ? (byte)2 : (byte)((singleAttributeValue2 = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.DISPLAY)) != null ? (int)((DisplayValue)singleAttributeValue2).getDisplay() : 3);
            singleAttributeValue2 = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT);
            if (singleAttributeValue2 != null) {
                this.floatValue = ((FloatValue)singleAttributeValue2).getFloat();
            }
            if (this.position == 0 && (singleAttributeValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.POSITION)) != null) {
                this.position = ((Position)singleAttributeValue).getPosition();
            }
        }
        if ((singleAttributeValue2 = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.DIRECTION)) != null) {
            this.direction = ((Direction)singleAttributeValue2).getValue();
        }
        if ((singleAttributeValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.UNICODEBIDI)) != null) {
            this.bidi = ((UnicodeBidi)singleAttributeValue).getValue();
        }
        if (this.isBlock()) {
            LengthUnit lengthUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_LEFT);
            LengthUnit lengthUnit2 = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_RIGHT);
            if (lengthUnit != null && lengthUnit.isAuto()) {
                this.autoMarginJustify = lengthUnit2 != null && lengthUnit2.isAuto() ? (byte)1 : (byte)2;
            } else if (lengthUnit2 != null && lengthUnit2.isAuto()) {
                this.autoMarginJustify = 0;
            }
        }
    }

    public void setJustification(byte by2) {
        this.justification = by2;
    }

    public boolean isWidthSet() {
        return this.widthUnit != null;
    }

    public void setSize(float f2, float f3) {
        this.outerWidth = (int)f2;
        this.outerHeight = (int)f3;
        int n2 = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int n3 = this.box.getPadding().left + this.box.getPadding().right;
        this.contentWidth = this.outerWidth - n2 - n3;
        n2 = this.box.getBorderInsets().top + this.box.getBorderInsets().bottom;
        n3 = this.box.getPadding().top + this.box.getPadding().bottom;
        this.contentHeight = this.outerHeight - n2 - n3;
    }

    public void setSizeContent(float f2, float f3) {
        this.contentWidth = (int)f2;
        this.contentHeight = (int)f3;
        int n2 = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int n3 = this.box.getPadding().left + this.box.getPadding().right;
        this.outerWidth = this.contentWidth + n2 + n3;
        n2 = this.box.getBorderInsets().top + this.box.getBorderInsets().bottom;
        n3 = this.box.getPadding().top + this.box.getPadding().bottom;
        this.outerHeight = this.contentHeight + n2 + n3;
    }

    public void setContentWidth(float f2) {
        this.contentWidth = (int)f2;
        if (this instanceof ILayouted) {
            ((ILayouted)((Object)this)).predictWidth((int)f2);
        }
        int n2 = this.box.getBorderInsets().left + this.box.getBorderInsets().right;
        int n3 = this.box.getPadding().left + this.box.getPadding().right;
        this.outerWidth = this.contentWidth + n2 + n3;
    }

    public LengthUnit getWidthUnit() {
        return this.widthUnit;
    }

    public LengthUnit getHeightUnit() {
        return this.heightUnit;
    }

    public int getJustification() {
        if (this.justification == -1) {
            return this.isLTR() ? 0 : 2;
        }
        return this.justification;
    }

    public int getAutoMarginJustify() {
        return this.autoMarginJustify;
    }

    public float getAlignment(int n2) {
        if (n2 == 0) {
            switch (this.getJustification()) {
                case 0: {
                    return 0.0f;
                }
                case 2: {
                    return 1.0f;
                }
            }
            return 0.5f;
        }
        return this.vAlign;
    }

    public int getSwingAlign(int n2) {
        if (n2 == 0) {
            switch (this.getJustification()) {
                case 0: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
        switch (this.vAlign) {
            case 3: 
            case 6: 
            case 8: {
                return 3;
            }
            case 4: 
            case 5: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    public int getResizeWeight(int n2) {
        LengthUnit lengthUnit = n2 == 0 ? this.widthUnit : this.heightUnit;
        if (lengthUnit != null && lengthUnit.isAbsolute()) {
            return 0;
        }
        return 1;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight > 1 ? this.contentHeight : 1;
    }

    public int getOuterHeight() {
        return this.outerHeight > 1 ? this.outerHeight : 1;
    }

    public int getOuterWidth() {
        return this.outerWidth;
    }

    public int getCompleteHight() {
        return this.getContentHeight();
    }

    public int getLeftInset() {
        return this.box.getPadding().left + this.box.getBorderInsets().left;
    }

    public int getRightInset() {
        return this.box.getPadding().right + this.box.getBorderInsets().right;
    }

    public int getTopInset() {
        return this.box.getPadding().top + this.box.getBorderInsets().top;
    }

    public int getBottomInset() {
        return this.box.getPadding().bottom + this.box.getBorderInsets().bottom;
    }

    public Insets getMargins() {
        return this.box.getMargins();
    }

    public int getViewIndex(int n2, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --n2;
        }
        return this.getViewIndex(n2);
    }

    public int getViewIndex(int n2) {
        for (int i2 = 0; i2 < this.getViewCount(); ++i2) {
            View view = this.getView(i2);
            if (n2 < view.getStartOffset() || n2 >= view.getEndOffset()) continue;
            return i2;
        }
        return -1;
    }

    public int getStartOffset() {
        return super.getStartOffset() + this.offset;
    }

    public int getEndOffset() {
        return this.length >= 0 ? super.getStartOffset() + this.offset + this.length : super.getEndOffset();
    }

    public void setStartAndEndOffset(int n2, int n3) {
        this.offset = n2 - super.getStartOffset();
        this.length = n3 - n2;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isCanceledByPainter(graphics, shape)) {
            return;
        }
        Rectangle rectangle = (Rectangle)shape;
        this.box.paint(graphics, rectangle, 0, this);
    }

    protected boolean isCanceledByPainter(Graphics graphics, Shape shape) {
        ViewPainter viewPainter = this.getPainter();
        return viewPainter != null && this.getViewCount() == 0 && !viewPainter.paint(graphics, shape);
    }

    public boolean isInFlow() {
        return CSSRules.isInFlow(this.position, this.floatValue);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public LengthUnit getLineHeight() {
        return this.lineHeight;
    }

    public boolean isBlock() {
        Object object = this.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.IMPLIED) {
            return true;
        }
        return CSSRules.isBlock(this.position, this.floatValue, this.display);
    }

    public boolean isBlockFormattingContext() {
        return this.isBlock() && (this.overflow != 1 || this.isFloating() || this.isAbsolutePositioned());
    }

    public int getClear() {
        return this.clear;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void performPreLayout() {
        int n2 = this.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            BoxView boxView = (BoxView)this.getView(i2);
            if (boxView == null || boxView.getStatus() != 2) continue;
            boxView.performPreLayout();
        }
    }

    public abstract void performLayoutWidth();

    public abstract Rectangle performLayout(boolean var1);

    public abstract void performLayoutVAlign(int var1);

    public void forceLayout() {
        View view = this.getParent();
        if (view != null) {
            ((BoxView)view).forceLayout();
        }
    }

    public void forceLayout(long l2) {
        if (this.getParent() != null) {
            ((BoxView)this.getParent()).forceLayout(l2);
        }
    }

    public void setContentVerticalOffset(int n2) {
        this.contentVerticalOffset = n2;
    }

    public int getContentVerticalOffset() {
        return this.contentVerticalOffset;
    }

    public boolean isMarker() {
        return this.isMarker;
    }

    public void setMarker(boolean bl2) {
        this.isMarker = bl2;
    }

    public ColorValue getBackgroundValue() {
        return this.box.getBackgroundValue();
    }

    public ColorValue getBorderTopColor() {
        return this.box.getBorderTopColor();
    }

    public ColorValue getBorderLeftColor() {
        return this.box.getBorderLeftColor();
    }

    public ColorValue getBorderRightColor() {
        return this.box.getBorderRightColor();
    }

    public ColorValue getBorderBottomColor() {
        return this.box.getBorderBottomColor();
    }

    public void setBorderBottomColor(ColorValue colorValue) {
        this.box.setBorderBottomColor(colorValue);
    }

    public void setBorderLeftColor(ColorValue colorValue) {
        this.box.setBorderLeftColor(colorValue);
    }

    public void setBorderRightColor(ColorValue colorValue) {
        this.box.setBorderRightColor(colorValue);
    }

    public void setBorderTopColor(ColorValue colorValue) {
        this.box.setBorderTopColor(colorValue);
    }

    public void setBackgroundValue(ColorValue colorValue) {
        this.box.setBackgroundValue(colorValue);
    }

    public int getFirstLineBaseLine() {
        return this.firstLineBaseLine;
    }

    public void setFirstLineBaseLine(short s2) {
        this.firstLineBaseLine = s2;
    }

    public boolean isBreak() {
        return this.isBreak;
    }

    public boolean isListItemWithMarker() {
        if (this.isListItemWithMarker != null) {
            return this.isListItemWithMarker;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.DISPLAY);
        FloatValue floatValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT);
        if (displayValue != null && displayValue.getDisplay() == 4 && (floatValue == null || floatValue.getFloat() == 0)) {
            ListStyleType listStyleType = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.LIST_STYLE_TYPE);
            UriValue uriValue = AttributeFinder.LIST_STYLE_IMAGE.getAttributeValue(this);
            if (listStyleType != null && listStyleType.getType() != 18 || uriValue != null && !uriValue.isNone()) {
                this.isListItemWithMarker = Boolean.TRUE;
                return true;
            }
        }
        this.isListItemWithMarker = Boolean.FALSE;
        return false;
    }

    public void addBoxPainter(Element element, IBoxPainter iBoxPainter) {
        if (iBoxPainter != null && element != null) {
            if (this.childPainters == null) {
                this.childPainters = new HashMap();
            }
            this.childPainters.put(element, iBoxPainter);
        }
    }

    public IBoxPainter getBoxPainter(Element element) {
        if (this.childPainters != null) {
            return this.childPainters.get(element);
        }
        return null;
    }

    public int getWhiteSpace() {
        return this.whiteSpace;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        if (n2 != 0) {
            this.getHTMLRoot().blockOnLayoutRunning();
            this.propagateStatus(n2);
        } else {
            this.status = n2;
        }
    }

    private void propagateStatus(int n2) {
        BoxView boxView;
        this.status = n2;
        View view = this.getParent();
        if (view instanceof BoxView && (boxView = (BoxView)view).getStatus() < n2) {
            boxView.setStatus(n2);
        }
    }

    public void setStatusLocal(int n2) {
        this.status = n2;
    }

    public ViewPositionInfo getViewForPosition(Point point, Rectangle rectangle) {
        Layout layout;
        if (this instanceof ILayouted && (layout = ((ILayouted)((Object)this)).getLayout()) != null) {
            return layout.getViewForPosition(point, rectangle);
        }
        return null;
    }

    public HtmlRootView getHTMLRoot() {
        if (this.root == null) {
            View view = this.getParent();
            this.root = ((BoxView)view).getHTMLRoot();
        }
        return this.root;
    }

    public void setRoot(HtmlRootView htmlRootView) {
        this.root = htmlRootView;
    }

    public ViewPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ViewPainter viewPainter) {
        this.painter = viewPainter;
    }

    public boolean isBreakable() {
        return true;
    }

    public int getDisplay() {
        return this.display;
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public boolean isTableCell() {
        return this.display == 12;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public boolean isFloating() {
        return CSSRules.isFloating(this.position, this.floatValue);
    }

    public int getFloat() {
        return this.floatValue;
    }

    public int getPosition() {
        return this.position;
    }

    protected void setPosition(byte by2) {
        this.position = by2;
    }

    public boolean isAbsolutePositioned() {
        return this.position >= 2;
    }

    public Rectangle getSpan() {
        return new Rectangle(0, 0, this.getOuterWidth(), this.getOuterHeight());
    }

    public int getDirection() {
        return this.direction;
    }

    public int getUnicodeBidi() {
        return this.bidi;
    }

    public boolean isLTR() {
        return this.bidi == 0 && this.isNativeLTR || this.direction == 0;
    }

    public void setIsNativeLTR(boolean bl2) {
        this.isNativeLTR = bl2;
    }

    public boolean isNativeLTR() {
        return this.isNativeLTR;
    }
}

