/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.ViewPainter;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.views.ContentView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BulletView
extends ContentView {
    private int height = 16;
    private int width = 8;
    private int offset = 0;
    private final int listType;
    private Color textColor;
    private static final Stroke CIRCLE_STROKE = new BasicStroke(1.0f, 1, 1);

    public BulletView(Element element, int n2) {
        super(element);
        this.listType = n2;
    }

    public BulletView(Element element, int n2, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.listType = n2;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null) {
            return;
        }
        super.performPreLayout();
        this.height = (int)new LengthUnit("11pt").getValue();
        float f2 = this.getFontSize();
        if ((float)this.height < super.getPreferredSpan(1)) {
            this.height = (int)f2;
        }
        switch (this.listType) {
            case 1: {
                this.width = (int)new LengthUnit("6pt").getValue();
                break;
            }
            default: {
                this.width = (int)new LengthUnit("5.5pt").getValue();
            }
        }
        ListPositionValue listPositionValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.LIST_STYLE_POSITION);
        if (listPositionValue != null && listPositionValue.getType() == 1) {
            this.offset += (int)new LengthUnit("6pt").getValue();
        }
        this.setContentWidth(this.width + this.offset);
        ColorValue colorValue = AttributeFinder.COLOR.getAttributeValue(this);
        this.textColor = colorValue != null ? colorValue.getValue() : Color.BLACK;
        this.setSizeContent(this.width + this.offset, this.height);
    }

    public Rectangle performLayout(boolean bl2) {
        return null;
    }

    public void performLayoutVAlign(int n2) {
    }

    public void performLayoutWidth() {
    }

    public void performPreLayout() {
    }

    public float getPreferredSpan(int n2) {
        if (n2 == 0) {
            return this.width + this.offset;
        }
        if (n2 == 2) {
            return super.getPreferredSpan(n2);
        }
        return super.getPreferredSpan(n2);
    }

    public float getMinimumSpan(int n2) {
        return this.getPreferredSpan(n2);
    }

    public boolean isMarker() {
        return true;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        if (graphics.getClip() != null && !graphics.getClip().intersects(rectangle)) {
            return;
        }
        if (this.isCanceledByPainter(graphics, shape)) {
            return;
        }
        int n2 = rectangle.x;
        int n3 = (int)this.getPreferredSpan(2) - this.width - 2;
        int n4 = (this.height - this.width) / 2 + 1;
        int n5 = rectangle.y + Math.max(n3, n4);
        graphics.setColor(this.textColor);
        boolean bl2 = false;
        Object object = null;
        if (graphics instanceof Graphics2D) {
            object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setStroke(CIRCLE_STROKE);
            bl2 = true;
        }
        switch (this.listType) {
            case 2: {
                graphics.fillRect(n2, n5, this.width, this.width);
                break;
            }
            case 1: {
                graphics.drawOval(n2, n5, this.width, this.width);
                break;
            }
            default: {
                graphics.fillOval(n2, n5, this.width, this.width);
            }
        }
        if (bl2) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object != null ? object : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        return null;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        return -1;
    }

    protected String getText() throws BadLocationException {
        return null;
    }
}

