/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.utils.Logger;
import com.inet.html.views.ContentView;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class ContentPainter {
    private ContentView view;
    private boolean charOffsetsSet;
    private float[] charOffsets;
    private float width = -1.0f;
    private int ascend;
    private int descend;
    private boolean isReversed;
    private int height;
    private static final Font FALLBACK_FONT = new Font("Sans Serif", 0, 12);

    public ContentPainter(ContentView contentView) {
        this.view = contentView;
    }

    public void setView(ContentView contentView) {
        this.view = contentView;
    }

    public float getSpan() {
        if (this.charOffsetsSet) {
            if (this.charOffsets != null) {
                return this.charOffsets[this.charOffsets.length - 1];
            }
            return 0.0f;
        }
        if (this.width < 0.0f) {
            this.width = this.calculateWidth();
        }
        return this.width;
    }

    protected float calculateWidth() {
        try {
            Segment segment = this.view.getSegment();
            return this.view.getFont().getStringBounds((char[])segment.array, (int)segment.offset, (int)(segment.offset + segment.count), (FontRenderContext)this.view.getRenderContext().getFontRenderContext()).getBounds().width;
        }
        catch (Throwable throwable) {
            if (Logger.doesLog(1)) {
                Logger.error(throwable);
            }
            return 1.0f;
        }
    }

    public int getAscent() {
        return this.ascend;
    }

    public int getDescent() {
        return this.descend;
    }

    public int getHeight() {
        return this.height;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fontMetrics;
        Font font = this.view.getFont();
        JEditorPane jEditorPane = this.view.getRenderContext().getTextContainer();
        FontMetrics fontMetrics2 = fontMetrics = jEditorPane != null ? ((Component)jEditorPane).getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics.getHeight() == 0 && font.getSize() > 0) {
            font = FALLBACK_FONT.deriveFont(font.getSize2D()).deriveFont(font.getStyle());
            fontMetrics = jEditorPane != null ? ((Component)jEditorPane).getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
        return fontMetrics;
    }

    public void paint(Graphics graphics, Shape shape, int n2, int n3, int n4) {
        try {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4;
            Segment segment = this.view.getSegment();
            graphics.setFont(this.view.getFont());
            graphics.drawString(segment.toString().substring(n2, n2 + n3), n5, n6);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Shape modelToView(int n2, Position.Bias bias, Shape shape) throws BadLocationException {
        float[] fArray = this.getCharOffsets();
        Rectangle rectangle = shape.getBounds();
        int n3 = this.view.getStartOffset();
        if (fArray == null || fArray.length == 0) {
            if (!this.view.isNativeLTR() && bias == Position.Bias.Forward || this.view.isNativeLTR() && bias == Position.Bias.Backward) {
                rectangle.x += rectangle.width;
            }
            if (rectangle.width == 0) {
                rectangle.width = 1;
            }
            return rectangle;
        }
        rectangle.x = (int)((float)rectangle.x + fArray[n2 - n3]);
        rectangle.width = 0;
        return rectangle;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        int n2;
        Rectangle rectangle = shape.getBounds();
        if (f2 < (float)rectangle.x) {
            return this.view.isNativeLTR() ? this.view.getStartOffset() : this.view.getEndOffset();
        }
        if (f2 > (float)rectangle.x + this.getSpan()) {
            return this.view.isNativeLTR() ? this.view.getEndOffset() : this.view.getStartOffset();
        }
        float[] fArray = this.getCharOffsets();
        int n3 = this.view.getStartOffset();
        if (fArray == null || fArray.length == 0) {
            return n3;
        }
        float f4 = fArray[0];
        float f5 = fArray[0];
        if (this.view.isNativeLTR()) {
            for (n2 = 1; f5 + (float)rectangle.x <= f2 && n2 < fArray.length; ++n2) {
                f4 = f5;
                f5 = fArray[n2];
                float f6 = f5 - f4;
                if (!(f5 + (float)rectangle.x >= f2)) continue;
                if (f4 + (float)rectangle.x + f6 / 2.0f >= f2) {
                    biasArray[0] = Position.Bias.Forward;
                    return n2 + n3 - 1;
                }
                biasArray[0] = Position.Bias.Backward;
                return n2 + n3;
            }
        } else {
            while (f5 + (float)rectangle.x >= f2 && n2 < fArray.length) {
                f4 = f5;
                f5 = fArray[n2];
                float f7 = f5 - f4;
                if (f5 + (float)rectangle.x < f2) {
                    if (f4 + (float)rectangle.x + f7 / 2.0f < f2) {
                        biasArray[0] = Position.Bias.Forward;
                        return n2 + n3 - 1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                    return n2 + n3;
                }
                ++n2;
            }
        }
        if (n2 == fArray.length) {
            return n2 + n3 - 1;
        }
        return n3;
    }

    public void sync() {
        FontMetrics fontMetrics = this.getFontMetrics();
        this.ascend = fontMetrics.getAscent();
        this.descend = fontMetrics.getDescent();
        this.height = fontMetrics.getHeight();
        this.width = -1.0f;
        this.charOffsetsSet = false;
    }

    protected void calculateCharOffsets(Segment segment) {
        float[] fArray = new float[segment.count + 1];
        fArray[0] = 0.0f;
        Font font = this.view.getFont();
        FontRenderContext fontRenderContext = this.view.getRenderContext().getFontRenderContext();
        for (int i2 = 1; i2 <= segment.count; ++i2) {
            fArray[i2] = font.getStringBounds((char[])segment.array, (int)segment.offset, (int)(segment.offset + i2), (FontRenderContext)fontRenderContext).getBounds().width;
        }
        this.setCharOffsets(fArray);
    }

    public float[] getCharOffsets() {
        if (!this.charOffsetsSet) {
            this.charOffsetsSet = true;
            try {
                Segment segment = this.view.getSegment();
                if (segment.count == 0) {
                    return new float[]{0.0f};
                }
                this.calculateCharOffsets(segment);
            }
            catch (BadLocationException badLocationException) {
                Logger.error(badLocationException);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Logger.error(stringIndexOutOfBoundsException);
            }
        }
        return this.charOffsets;
    }

    public void setCharOffsets(float[] fArray) {
        this.charOffsetsSet = true;
        if (this.isReversed) {
            float[] fArray2 = new float[fArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray2[fArray.length - i2 - 1] = fArray[i2];
            }
            fArray = fArray2;
        }
        this.charOffsets = fArray;
    }

    public boolean isCharOffsetsSet() {
        return this.charOffsetsSet;
    }

    public ContentPainter copy(ContentView contentView) {
        ContentPainter contentPainter = new ContentPainter(contentView);
        return contentPainter;
    }

    public void setReversed() {
        this.isReversed = true;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public void reset() {
        this.charOffsetsSet = false;
        this.width = -1.0f;
    }
}

