/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.parser.converter.TextDecoration;
import com.inet.html.utils.FontUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentPainter;
import com.inet.html.views.IBoxPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ContentView
extends BoxView
implements Cloneable {
    private Font font;
    private BoxPainter[] painters;
    private boolean useSymbolTransform = false;
    private ColorValue underLineColor;
    private ColorValue overLineColor;
    private ColorValue throughLineColor;
    private char[] symbolContent = null;
    private String symbolContentString = null;
    private Color textColor;
    private boolean isBreakable = false;
    private int cjkType = 0;
    public static final int CJK_TYPE_NONE = 0;
    public static final int CJK_TYPE_PUNCTUATION = 1;
    public static final int CJK_TYPE_CHARACTER = 2;
    private ContentPainter painter;
    private int baseline;

    public ContentView(Element element) {
        super(element);
        this.painter = new ContentPainter(this);
    }

    public ContentView(Element element, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.painter = new ContentPainter(this);
    }

    public ContentView(Element element, ViewPainter viewPainter, ContentPainter contentPainter) {
        super(element, viewPainter);
        this.painter = contentPainter;
        contentPainter.setView(this);
    }

    public void setParent(View view) {
        SingleAttributeValue singleAttributeValue;
        Object object;
        Element element;
        if (this.getParent() != null && this.getParent() == view) {
            return;
        }
        super.setParent(view);
        if (view == null) {
            this.font = null;
            this.painters = null;
            this.overLineColor = null;
            this.underLineColor = null;
            this.throughLineColor = null;
            this.painter.reset();
            return;
        }
        this.setStatusLocal(0);
        Element element2 = this.getElement();
        if (!((CssDocument)this.getDocument()).readStylesOfVirtualTags() && element2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            element2 = element2.getParentElement();
        }
        if ((element = view.getElement()).getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
            element = element.getParentElement();
        }
        ArrayList<Object> arrayList = null;
        while (element2 != element && element2 != null) {
            object = BoxPainter.createBoxPainter((BoxView)view, this, element2);
            if (object.isRelevant()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(object);
            }
            if ((singleAttributeValue = StyleResolver.getAttributeValue(element2, AttributeFinder.TEXT_DECORATION)) != null && ((TextDecoration)singleAttributeValue).getDecoration() != 0) {
                ColorValue colorValue = StyleResolver.getAttributeValue(element2, AttributeFinder.COLOR);
                int n2 = ((TextDecoration)singleAttributeValue).getDecoration();
                if ((n2 & 4) != 0) {
                    ColorValue colorValue2 = this.throughLineColor = this.throughLineColor == null ? colorValue : this.throughLineColor;
                }
                if ((n2 & 1) != 0) {
                    ColorValue colorValue3 = this.underLineColor = this.underLineColor == null ? colorValue : this.underLineColor;
                }
                if ((n2 & 2) != 0) {
                    this.overLineColor = this.overLineColor == null ? colorValue : this.overLineColor;
                }
            }
            element2 = element2.getParentElement();
        }
        object = StyleResolver.getAttributeValue(element, AttributeFinder.TEXT_DECORATION);
        if (object != null && ((TextDecoration)object).getDecoration() != 0) {
            singleAttributeValue = StyleResolver.getAttributeValue(element, AttributeFinder.COLOR);
            int n3 = ((TextDecoration)object).getDecoration();
            if ((n3 & 4) != 0) {
                SingleAttributeValue singleAttributeValue2 = this.throughLineColor = this.throughLineColor == null ? singleAttributeValue : this.throughLineColor;
            }
            if ((n3 & 1) != 0) {
                SingleAttributeValue singleAttributeValue3 = this.underLineColor = this.underLineColor == null ? singleAttributeValue : this.underLineColor;
            }
            if ((n3 & 2) != 0) {
                SingleAttributeValue singleAttributeValue4 = this.overLineColor = this.overLineColor == null ? singleAttributeValue : this.overLineColor;
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            this.painters = new BoxPainter[arrayList.size()];
            arrayList.toArray(this.painters);
        }
    }

    protected void setPropertiesFromAttributes(boolean bl2) {
        FontFamily fontFamily;
        if (this.getParent() == null) {
            return;
        }
        super.setPropertiesFromAttributes(true);
        if (this.font == null) {
            this.font = this.getRenderContext().getFont(this);
        }
        if ((fontFamily = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FONT_FAMILY)) != null) {
            this.useSymbolTransform = fontFamily.isSymbolic() && this.getRenderContext().isFontFallbackAllowed();
        }
        this.getContentPainter().sync();
        ColorValue colorValue = AttributeFinder.COLOR.getAttributeValue(this);
        this.textColor = colorValue != null ? colorValue.getValue() : Color.BLACK;
    }

    protected void setBlockProperties() {
    }

    public void setSize(float f2, float f3) {
    }

    public void setSizeContent(float f2, float f3) {
    }

    public View createFragment(int n2, int n3) {
        try {
            ContentView contentView;
            block13: {
                contentView = (ContentView)this.clone();
                contentView.setStartAndEndOffset(n2, n3);
                if (this.getRenderContext().isRefreshFontRequiredOnSplit()) {
                    contentView.font = this.getRenderContext().getFont(contentView);
                }
                try {
                    String string = contentView.getText();
                    if (string != null && (contentView.useSymbolTransform || contentView.font.canDisplayUpTo(string) >= 0 && this.getRenderContext().isFontFallbackAllowed())) {
                        contentView.symbolContent = string.toCharArray();
                        FontFamily.translateSymbolic(contentView.symbolContent);
                        if (contentView.font.canDisplayUpTo(contentView.symbolContent, 0, contentView.symbolContent.length) >= 0) {
                            Font font = FontUtils.getFontFor(string);
                            if (font != null) {
                                contentView.symbolContent = null;
                                int n4 = (int)this.getFontSize();
                                contentView.font = font.deriveFont(this.font.getStyle(), n4);
                            } else {
                                contentView.symbolContentString = new String(contentView.symbolContent);
                                font = FontUtils.getFontFor(contentView.symbolContentString);
                                if (font != null) {
                                    int n5 = (int)this.getFontSize();
                                    contentView.font = font.deriveFont(this.font.getStyle(), n5);
                                } else {
                                    contentView.symbolContent = null;
                                    contentView.symbolContentString = null;
                                }
                            }
                        } else {
                            contentView.symbolContentString = new String(contentView.symbolContent);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block13;
                    Logger.error(badLocationException);
                }
            }
            contentView.setPropertiesFromAttributes(true);
            contentView.performPreLayout();
            return contentView;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (Logger.doesLog(1)) {
                Logger.error(cloneNotSupportedException);
            }
            return this;
        }
    }

    public float getPreferredSpan(int n2) {
        switch (n2) {
            case 0: {
                return this.getContentWidth();
            }
            case 2: {
                return this.baseline;
            }
        }
        return this.getContentHeight();
    }

    public void performPreLayout() {
        this.getContentPainter().sync();
        this.baseline = this.getContentPainter().getAscent();
        super.setSizeContent(this.getContentPainter().getSpan(), this.getContentPainter().getHeight());
    }

    public float getMinimumSpan(int n2) {
        if (n2 == 0) {
            if (this.getCJKType() == 2) {
                return this.getTextLength() > 0 ? this.getContentPainter().getCharOffsets()[1] : 0.0f;
            }
            return this.getPreferredSpan(n2);
        }
        return super.getMinimumSpan(n2);
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.getContentPainter().modelToView(n2, bias, shape);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        return this.getContentPainter().viewToModel(f2, f3, shape, biasArray);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle rectangle = (Rectangle)shape;
        if (graphics.getClip() != null && !graphics.getClip().intersects(rectangle)) {
            return;
        }
        if (this.isCanceledByPainter(graphics, shape)) {
            return;
        }
        try {
            Object object;
            if (this.painters != null && this.painters.length > 0) {
                for (int i2 = this.painters.length - 1; i2 >= 0; --i2) {
                    BoxPainter boxPainter = this.painters[i2];
                    rectangle.y -= boxPainter.getTopBorderPadding();
                    rectangle.height += boxPainter.getTopBorderPadding() + boxPainter.getBottomBorderPadding();
                    boxPainter.paint(graphics, rectangle, i2 == 0 ? this.getTopPainterType() : 2, this);
                    rectangle.y += boxPainter.getTopBorderPadding();
                    rectangle.height -= boxPainter.getTopBorderPadding() + boxPainter.getBottomBorderPadding();
                }
            }
            JEditorPane jEditorPane = this.getRenderContext().getTextContainer();
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            int n4 = -1;
            int n5 = -1;
            if (!this.isMarker() && (n4 = this.getRenderContext().getSelectionStart()) == (n5 = this.getRenderContext().getSelectionEnd())) {
                n4 = -1;
                n5 = -1;
            }
            Color color = null;
            if (jEditorPane != null && !this.isMarker()) {
                object = jEditorPane.getHighlighter();
                if (object instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n2, n3, shape, jEditorPane, this);
                }
                color = jEditorPane.getSelectedTextColor();
            }
            object = this.getText();
            int n6 = (int)this.getPreferredSpan(2);
            if (object != null) {
                Object object2;
                graphics.setFont(this.font);
                Shape shape2 = null;
                if (n4 < n3 && n5 >= n2 && color != null && this.getRenderContext().paintSelection() && color.getRGB() != this.textColor.getRGB()) {
                    shape2 = graphics.getClip();
                    object2 = this.getContentPainter().getCharOffsets();
                    int n7 = this.getTextLength();
                    int n8 = n2 < n4 ? n4 - n2 : 0;
                    int n9 = n3 > n5 ? n5 - n2 : n7;
                    Object object3 = object2[n8];
                    Object object4 = object2[n9];
                    Rectangle rectangle2 = null;
                    Rectangle rectangle3 = null;
                    Rectangle rectangle4 = null;
                    rectangle3 = new Rectangle(rectangle.x + Math.round(Math.min((float)object3, (float)object4)), rectangle.y, Math.round(Math.abs((float)(object4 - object3))), rectangle.height);
                    if (shape2 != null) {
                        rectangle3 = rectangle3.intersection(shape2.getBounds());
                    }
                    if (n8 > 0) {
                        rectangle2 = new Rectangle(rectangle.x, rectangle.y, Math.round(Math.min((float)object4, (float)object3)), rectangle.height);
                        if (shape2 != null) {
                            rectangle2 = rectangle2.intersection(shape2.getBounds());
                        }
                    }
                    if (n9 < n7) {
                        int n10 = Math.round(Math.max((float)object3, (float)object4));
                        rectangle4 = new Rectangle(rectangle.x + n10, rectangle.y, (int)(object2[n7] - (float)n10), rectangle.height);
                        if (shape2 != null) {
                            rectangle4 = rectangle4.intersection(shape2.getBounds());
                        }
                    }
                    graphics.setColor(color);
                    graphics.setClip(rectangle3);
                    if (n4 > n2 || n5 < n3) {
                        this.drawTextDecorations(graphics, n6 + rectangle.y, rectangle3.x, rectangle3.width, color);
                    }
                    this.getContentPainter().paint(graphics, rectangle, 0, ((String)object).length(), n6);
                    if (rectangle2 != null && rectangle4 != null) {
                        graphics.setColor(this.textColor);
                        graphics.setClip(rectangle2);
                        this.getContentPainter().paint(graphics, shape, 0, ((String)object).length(), n6);
                        if (this.getRenderContext().paintSelection()) {
                            this.drawTextDecorations(graphics, rectangle.y + n6, rectangle2.x, rectangle2.width, null);
                        }
                        graphics.setClip(rectangle4);
                    } else {
                        graphics.setClip(rectangle2 != null ? rectangle2 : rectangle4);
                    }
                }
                if (shape2 == null || n4 > n2 || n5 < n3) {
                    graphics.setColor(this.textColor);
                    this.getContentPainter().paint(graphics, shape, 0, ((String)object).length(), n6);
                    object2 = shape2 != null ? graphics.getClipBounds() : shape.getBounds();
                    this.drawTextDecorations(graphics, rectangle.y + n6, ((Rectangle)object2).x, ((Rectangle)object2).width, null);
                }
                if (n4 <= n2 && n5 >= n3 && color != null && this.getRenderContext().paintSelection()) {
                    this.drawTextDecorations(graphics, rectangle.y + n6, rectangle.x, rectangle.width, color);
                }
                if (shape2 != null) {
                    graphics.setClip(shape2);
                }
            } else if (n4 <= n2 && n5 >= n3 && color != null && this.getRenderContext().paintSelection()) {
                this.drawTextDecorations(graphics, rectangle.y + n6, rectangle.x, rectangle.width, color);
            } else {
                this.drawTextDecorations(graphics, rectangle.y + n6, rectangle.x, rectangle.width, null);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public int getTextLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    private void drawTextDecorations(Graphics graphics, int n2, float f2, float f3, Color color) {
        if (!(this.overLineColor == null && this.underLineColor == null && this.throughLineColor == null || this.getTopPainterType() != 2 && this.getTopPainterType() != 0)) {
            float f4;
            float f5;
            float f6;
            LineMetrics lineMetrics = this.font.getLineMetrics(" ", this.getRenderContext().getFontRenderContext());
            if (this.overLineColor != null) {
                f6 = lineMetrics.getAscent();
                f5 = lineMetrics.getUnderlineThickness();
                f4 = (float)n2 - f6;
                graphics.setColor(color == null ? this.overLineColor.getValue() : color);
                BoxPainter.drawBorderLine((Graphics2D)graphics, f2, f4, f3, 0.0f, 7, f5);
            }
            if (this.throughLineColor != null) {
                f6 = lineMetrics.getAscent();
                f5 = lineMetrics.getStrikethroughThickness();
                f4 = (float)n2 + lineMetrics.getStrikethroughOffset();
                graphics.setColor(color == null ? this.throughLineColor.getValue() : color);
                BoxPainter.drawBorderLine((Graphics2D)graphics, f2, f4, f3, 0.0f, 7, f5);
            }
            if (this.underLineColor != null) {
                f5 = lineMetrics.getUnderlineThickness();
                f4 = (float)n2 + lineMetrics.getUnderlineOffset();
                graphics.setColor(color == null ? this.underLineColor.getValue() : color);
                BoxPainter.drawBorderLine((Graphics2D)graphics, f2, f4, f3, 0.0f, 7, f5);
            }
        }
    }

    protected int getTopPainterType() {
        return 2;
    }

    protected String getText() throws BadLocationException {
        if (this.symbolContentString == null) {
            Document document = this.getDocument();
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            return document.getText(n2, n3 - n2);
        }
        return this.symbolContentString;
    }

    protected Segment getSegment() throws BadLocationException {
        if (this.symbolContent == null) {
            Document document = this.getDocument();
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            Segment segment = new Segment();
            document.getText(n2, n3 - n2, segment);
            return segment;
        }
        return new Segment(this.symbolContent, 0, this.symbolContent.length);
    }

    public int getLeftInset() {
        return 0;
    }

    public boolean isBlock() {
        return false;
    }

    public int getRightInset() {
        return 0;
    }

    public int getTopInset() {
        return 0;
    }

    public int getBottomInset() {
        return 0;
    }

    public Insets getMargins() {
        return this.getBox().getMargins();
    }

    public String paramString() {
        return "Content(" + (this.getElement() != null ? this.getElement().toString() : "No Element").trim() + ") " + this.getStartOffset() + "," + this.getEndOffset();
    }

    public Rectangle performLayout(boolean bl2) {
        return null;
    }

    public void performLayoutWidth() {
    }

    public void performLayoutVAlign(int n2) {
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, viewFactory);
        if (Logger.doesLog(4)) {
            Logger.debug("ContentView:insertUpdate");
        }
        int n2 = documentEvent.getOffset();
        int n3 = n2 + documentEvent.getLength();
        int n4 = this.getStartOffset();
        int n5 = this.getEndOffset();
        if (Logger.doesLog(4) && (n2 >= n4 && n2 < n5 || n3 > n4 && n3 < n5)) {
            Logger.debug("Change in View " + this);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        ContentView contentView = (ContentView)super.clone();
        contentView.symbolContent = null;
        contentView.symbolContentString = null;
        contentView.changeOnlyParent(this.getParent());
        if (this.getPainter() != null) {
            contentView.setPainter((ViewPainter)this.getPainter().clone());
        }
        contentView.painter = this.painter.copy(contentView);
        return contentView;
    }

    public boolean isBreakable() {
        return this.isBreakable || this.isBreak();
    }

    public void setBreakable(boolean bl2) {
        this.isBreakable = bl2;
    }

    public Font getFont() {
        return this.font;
    }

    public void setIsNativeLTR(boolean bl2) {
        super.setIsNativeLTR(bl2);
        if (!bl2) {
            this.getContentPainter().setReversed();
            try {
                int n2;
                Segment segment = this.getSegment();
                boolean bl3 = false;
                for (n2 = segment.getBeginIndex(); n2 < segment.getEndIndex(); ++n2) {
                    if (!Character.isMirrored(segment.array[n2])) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    this.symbolContent = new char[segment.getEndIndex() - segment.getBeginIndex()];
                    if (bl3) {
                        for (n2 = segment.getBeginIndex(); n2 < segment.getEndIndex(); ++n2) {
                            this.symbolContent[n2 - segment.getBeginIndex()] = ViewUtils.getMirroredCharacter(segment.array[n2]);
                        }
                    }
                    this.symbolContentString = new String(this.symbolContent);
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.error(badLocationException);
            }
        }
    }

    public String toString() {
        try {
            return "Content(" + this.getStartOffset() + ":" + this.getEndOffset() + "): " + this.getText();
        }
        catch (BadLocationException badLocationException) {
            return "Content: " + this.getStartOffset() + ":" + this.getEndOffset();
        }
    }

    public ContentPainter getContentPainter() {
        return this.painter;
    }

    public int getCJKType() {
        return this.cjkType;
    }

    public void setCJKType(int n2) {
        this.cjkType = n2;
    }

    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createBoxPainter(this, this.getElement());
    }
}

