/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.layouts.ControlLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.sun.java.swing.plaf.motif.MotifButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ControlView
extends BoxView
implements ILayouted {
    public static final int TYPE_BUTTON = 0;
    public static final int TYPE_TEXTFIELD = 1;
    public static final int TYPE_TEXTAREA = 2;
    public static final int TYPE_RADIOBUTTON = 3;
    public static final int TYPE_CHECKBOX = 4;
    public static final int TYPE_SELECT = 5;
    public static final int TYPE_MENU = 6;
    public static final int TYPE_HIDDEN = 7;
    private JComponent control;
    private boolean controlCreated = false;
    private Font font;
    private Color color;
    private ControlLayout layout;
    private int type;
    private boolean isSubmit = false;
    private boolean isReset;
    private static final String DEFAULT_BUTTON_TEXT = "Button";

    public ControlView(Element element) {
        super(element);
    }

    public ControlView(Element element, ViewPainter viewPainter) {
        super(element, viewPainter);
    }

    public void setParent(View view) {
        Container container;
        if (this.getParent() != null && this.getParent() == view && view != null) {
            return;
        }
        if (this.control != null && (container = this.control.getParent()) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                container.remove(this.control);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        container.remove(ControlView.this.control);
                    }
                });
            }
        }
        if (view == null) {
            this.getRenderContext().deregisterControl(this);
            return;
        }
        super.setParent(view);
        this.font = this.getRenderContext().getFont(this);
        this.layout = new ControlLayout(this);
        this.setStatus(2);
    }

    private synchronized JComponent getControlComponent() {
        if (!this.controlCreated) {
            Container container;
            this.controlCreated = true;
            this.control = this.createControl();
            if (this.control != null && (container = this.getContainer()) != null) {
                container.add(this.control);
            }
            this.getHTMLRoot().getRenderContext().registerControl(this);
            this.layout.preLayout();
        }
        return this.control;
    }

    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    protected JComponent createControl() {
        JComponent jComponent = null;
        AttributeSet attributeSet = this.getElement().getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.INPUT) {
            Object object2 = attributeSet.getAttribute((Object)HTML.Attribute.VALUE);
            Object object3 = attributeSet.getAttribute((Object)HTML.Attribute.TYPE);
            if (object3 != null) {
                object3 = object3.toString().toLowerCase();
            }
            if (object3 != null && !object3.equals("text") && !object3.equals("password")) {
                if (object3.equals("image")) {
                    URL uRL = this.getImageURL();
                    jComponent = new JButton(DEFAULT_BUTTON_TEXT);
                    final WeakReference<JComponent> weakReference = new WeakReference<JComponent>(jComponent);
                    if (uRL != null) {
                        ImageCache.getStaticInstance().getImage(uRL.toString(), uRL, new AnimationObserver(){

                            public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
                                JComponent jComponent = (JComponent)weakReference.get();
                                if (jComponent instanceof JButton) {
                                    JButton jButton = (JButton)jComponent;
                                    if ((n2 & 0x20) != 0) {
                                        if (jButton.getText() == ControlView.DEFAULT_BUTTON_TEXT) {
                                            jButton.setText("");
                                        }
                                        jButton.setIcon(new ImageIcon(image));
                                    }
                                }
                                return (n2 & 0xE0) == 0;
                            }

                            public boolean doAnimate() {
                                return false;
                            }
                        });
                    }
                    ((JButton)jComponent).setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                    ((JButton)jComponent).setContentAreaFilled(false);
                    ((JButton)jComponent).setUI(new MotifButtonUI());
                    ((JButton)jComponent).setHorizontalAlignment(this.getSwingAlign(0));
                    ((JButton)jComponent).setVerticalAlignment(this.getSwingAlign(1));
                    if (object2 != null) {
                        ((JButton)jComponent).setText(object2.toString());
                    }
                    this.persistSize(jComponent);
                    this.type = 0;
                    this.isSubmit = true;
                } else if (object3.equals("button")) {
                    jComponent = new JButton(DEFAULT_BUTTON_TEXT);
                    ((JButton)jComponent).setOpaque(true);
                    if (object2 != null) {
                        ((JButton)jComponent).setText(object2.toString());
                    }
                    this.persistSize(jComponent);
                    this.type = 0;
                } else if (object3.equals("submit")) {
                    String string = UIManager.getString("FormView.submitButtonText");
                    jComponent = new JButton(string != null ? string : "OK");
                    ((JButton)jComponent).setOpaque(true);
                    if (object2 != null) {
                        ((JButton)jComponent).setText(object2.toString());
                    }
                    this.persistSize(jComponent);
                    this.type = 0;
                    this.isSubmit = true;
                } else if (object3.equals("reset")) {
                    String string = UIManager.getString("FormView.resetButtonText");
                    jComponent = new JButton(string != null ? string : "Reset");
                    ((JButton)jComponent).setOpaque(true);
                    if (object2 != null) {
                        ((JButton)jComponent).setText(object2.toString());
                    }
                    this.persistSize(jComponent);
                    this.type = 0;
                    this.isSubmit = true;
                    this.isReset = true;
                } else if (object3.equals("hidden")) {
                    this.type = 7;
                } else if (object3.equals("radio")) {
                    jComponent = new JRadioButton();
                    jComponent.setFont(new Font("Arial", 0, 2));
                    ((JRadioButton)jComponent).setOpaque(false);
                    ((JRadioButton)jComponent).setBorderPainted(false);
                    if (object2 != null && object2.toString().trim().equalsIgnoreCase("on")) {
                        ((JRadioButton)jComponent).setSelected(true);
                    }
                    this.persistSize(jComponent);
                    this.type = 3;
                } else if (object3.equals("checkbox")) {
                    jComponent = new JCheckBox();
                    jComponent.setFont(new Font("Arial", 0, 2));
                    ((JCheckBox)jComponent).setOpaque(false);
                    ((JCheckBox)jComponent).setBorderPainted(false);
                    if (attributeSet.isDefined((Object)HTML.Attribute.CHECKED)) {
                        ((JCheckBox)jComponent).setSelected(true);
                    }
                    this.persistSize(jComponent);
                    this.type = 4;
                }
            } else {
                jComponent = this.createTextField(attributeSet, object3 != null && object3.equals("password"));
                this.type = 1;
            }
        } else if (object == HTML.Tag.SELECT) {
            jComponent = this.createSelectControl();
            this.type = 5;
        } else if (object == HTML.Tag.TEXTAREA) {
            int n2 = this.getIntegerValue(attributeSet, (Object)HTML.Attribute.ROWS, 3);
            int n3 = this.getIntegerValue(attributeSet, (Object)HTML.Attribute.COLS, 15);
            jComponent = this.createTextArea(n2, n3);
            this.type = 2;
        }
        return jComponent;
    }

    private URL getImageURL() {
        UrlValue urlValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.SRC);
        String string = null;
        if (urlValue != null) {
            string = urlValue.getUrl();
        }
        if (string != null) {
            string = string.trim();
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.getDocument();
            URL uRL = inetHtmlDocument.getBase();
            try {
                if (uRL == null) {
                    Logger.warning("Missing base URL for image '" + string + "'. This image may not load.");
                }
                return new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void persistSize(JComponent jComponent) {
        this.setControlAttributes(jComponent);
        Dimension dimension = jComponent.getPreferredSize();
        if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto()) {
            dimension.height = (int)this.getHeightUnit().calculateValue(dimension.height, this);
        }
        if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
            dimension.width = (int)this.getWidthUnit().calculateValue(dimension.width, this);
        }
        this.layout.setPreferredSize(dimension.width, dimension.height);
        jComponent.setSize(dimension);
    }

    private int getIntegerValue(AttributeSet attributeSet, Object object, int n2) {
        Object object2 = attributeSet.getAttribute(object);
        int n3 = n2;
        if (object2 != null) {
            try {
                n3 = Integer.parseInt(object2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n3;
    }

    private JComponent createTextField(AttributeSet attributeSet, boolean bl2) {
        int n2 = this.getIntegerValue(attributeSet, (Object)HTML.Attribute.SIZE, 10);
        JTextField jTextField = null;
        if (bl2) {
            jTextField = new JPasswordField(n2);
            jTextField.setUI(new BasicPasswordFieldUI());
            ((JPasswordField)jTextField).setEchoChar('*');
        } else {
            jTextField = new JTextField(n2);
            jTextField.setUI(new BasicTextFieldUI());
        }
        Object object = attributeSet.getAttribute((Object)HTML.Attribute.VALUE);
        if (object != null) {
            jTextField.setText(object.toString());
        }
        try {
            jTextField.setDragEnabled(true);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        jTextField.setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextField, "Center");
        if (!this.getBox().useDefaultLookAndFeelBorder()) {
            jTextField.setBorder(null);
        }
        this.persistSize(jPanel);
        jPanel.doLayout();
        return jPanel;
    }

    private JComponent createTextArea(int n2, int n3) {
        JScrollPane jScrollPane;
        block9: {
            Insets insets = new Insets(0, 0, 0, 0);
            jScrollPane = new JScrollPane();
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(new EmptyBorder(insets));
            jTextArea.setMargin(insets);
            try {
                jTextArea.setDragEnabled(true);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (this.font != null) {
                jTextArea.setFont(this.font);
            }
            jTextArea.setRows(n2);
            jTextArea.setColumns(n3);
            Dimension dimension = jTextArea.getPreferredSize();
            jTextArea.setRows(1);
            jTextArea.setColumns(1);
            if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto()) {
                dimension.height = (int)this.getHeightUnit().calculateValue(dimension.height, this);
            }
            if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
                dimension.width = (int)this.getWidthUnit().calculateValue(dimension.width, this);
            }
            jScrollPane.setViewportBorder(new EmptyBorder(insets));
            jScrollPane.setMinimumSize(dimension);
            jScrollPane.setPreferredSize(dimension);
            jScrollPane.setMaximumSize(dimension);
            jScrollPane.setViewportView(jTextArea);
            jScrollPane.setOpaque(false);
            try {
                int n4 = this.getElement().getStartOffset();
                int n5 = this.getElement().getEndOffset();
                if (n4 < n5 - 1) {
                    jTextArea.setText(this.getDocument().getText(n4, n5 - n4 - 1));
                }
            }
            catch (Exception exception) {
                if (!Logger.doesLog(1)) break block9;
                Logger.error(exception);
            }
        }
        jScrollPane.setBorder(new BevelBorder(1, ColorUtils.get3DLight(), ColorUtils.get3DDark()));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setOpaque(false);
        if (!this.getBox().useDefaultLookAndFeelBorder()) {
            jScrollPane.setBorder(null);
        }
        this.persistSize(jPanel);
        jPanel.doLayout();
        jScrollPane.doLayout();
        jScrollPane.getViewport().doLayout();
        return jPanel;
    }

    private JComponent createSelectControl() {
        Object object;
        int n2;
        Object object2;
        Vector<String> vector = new Vector<String>();
        Element element = this.getElement();
        Document document = this.getDocument();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            object2 = element.getElement(i2);
            if (object2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.OPTION) continue;
            n2 = object2.getStartOffset();
            int n3 = object2.getEndOffset();
            try {
                object = document.getText(n2, n3 - n2);
                if (object2.getAttributes().isDefined((Object)HTML.Attribute.SELECTED)) {
                    arrayList.add(vector.size());
                }
                vector.add((String)object);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            vector.add("");
        }
        IntegerValue integerValue = AttributeFinder.SIZE.getAttributeValue(this);
        object2 = this.getControlComponent();
        if (integerValue == null || integerValue.getInt() == 1) {
            object2 = new JComboBox(vector);
            if (arrayList.size() > 0) {
                ((JComboBox)object2).setSelectedIndex((Integer)arrayList.get(arrayList.size() - 1));
            }
        } else {
            n2 = element.getAttributes().isDefined((Object)HTML.Attribute.MULTIPLE) ? 1 : 0;
            JList jList = new JList(vector);
            jList.setVisibleRowCount(integerValue.getInt());
            if (arrayList.size() > 0) {
                object = new int[arrayList.size()];
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    object[i3] = (Integer)arrayList.get(i3);
                }
                jList.setSelectedIndices((int[])object);
            }
            jList.setSelectionMode(n2 != 0 ? 2 : 0);
            object2 = new JScrollPane(jList);
        }
        this.persistSize((JComponent)object2);
        ((Container)object2).invalidate();
        ((Container)object2).doLayout();
        return object2;
    }

    private JComponent getInnerControl(JComponent jComponent) {
        if (jComponent instanceof JPanel) {
            jComponent = (JComponent)jComponent.getComponent(0);
        }
        if (jComponent instanceof JScrollPane) {
            jComponent = (JComponent)((JScrollPane)jComponent).getViewport().getComponent(0);
        }
        return jComponent;
    }

    private void setControlAttributes(JComponent jComponent) {
        if (this.getParent() == null) {
            return;
        }
        this.color = AttributeFinder.COLOR.getAttributeValue(this).getValue();
        if (jComponent != null) {
            JComponent jComponent2 = this.getInnerControl(jComponent);
            if (!this.getBox().useDefaultLookAndFeelBorder()) {
                jComponent.setBorder(new CSSBorder(this));
            } else {
                Serializable serializable;
                if (jComponent instanceof JButton) {
                    serializable = jComponent.getBorder().getBorderInsets(jComponent);
                    Dimension dimension = jComponent.getPreferredSize();
                    Insets insets = this.getBox().getPadding();
                    dimension.height += Math.max(insets.top - ((Insets)serializable).top, 0) + Math.max(insets.bottom - ((Insets)serializable).bottom, 0);
                    dimension.width += Math.max(insets.left - ((Insets)serializable).left, 0) + Math.max(insets.right - ((Insets)serializable).right, 0);
                    jComponent.setMinimumSize(dimension);
                    jComponent.setPreferredSize(dimension);
                    jComponent.setSize(dimension);
                    Dimension dimension2 = jComponent.getMaximumSize();
                    dimension2.width = Math.max(dimension2.width, dimension.width);
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                    jComponent.setMaximumSize(dimension2);
                }
                if (jComponent2 instanceof JTextComponent) {
                    serializable = (JTextComponent)jComponent2;
                    ((JTextComponent)serializable).setMargin(this.getBox().getPadding());
                }
            }
            if (this.color != null) {
                jComponent2.setForeground(this.color);
            }
            if (this.getBox().isBackgroundOpaque()) {
                jComponent2.setOpaque(false);
                jComponent.setOpaque(false);
                if (this.getBackgroundValue() != null && this.getBackgroundValue().getValue().getAlpha() > 0) {
                    jComponent2.setOpaque(true);
                    jComponent2.setBackground(this.getBackgroundValue().getValue());
                    jComponent.setOpaque(false);
                    jComponent.setBackground(this.getBackgroundValue().getValue());
                } else {
                    jComponent2.setBackground(null);
                    jComponent.setBackground(null);
                }
            }
            if (this.font != null) {
                jComponent2.setFont(this.font);
            }
            jComponent.setVisible(false);
        }
    }

    public float getPreferredSpan(int n2) {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null && this.layout != null) {
            if (n2 == 2) {
                return this.getFirstLineBaseLine();
            }
            return this.layout.getPreferredSpan(n2);
        }
        return 0.0f;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        if (n2 >= this.getStartOffset() && n2 <= this.getEndOffset()) {
            return shape;
        }
        return null;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isCanceledByPainter(graphics, shape)) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        rectangle = rectangle.intersection(shape.getBounds());
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        int n2 = shape.getBounds().x;
        int n3 = shape.getBounds().y;
        int n4 = shape.getBounds().width;
        int n5 = shape.getBounds().height;
        this.getBox().paintBackground(graphics, n2, n3, n4, n5, this);
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null) {
            jComponent.setSize(n4, n5);
            jComponent.setVisible(true);
            jComponent.setBounds(shape.getBounds());
            jComponent.setVisible(true);
            if (jComponent.getParent() == null) {
                Graphics graphics2 = graphics.create(n2, n3, n4, n5);
                graphics2.setClip(0, 0, n4, n5);
                jComponent.print(graphics2);
            }
        }
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        return this.getStartOffset();
    }

    public Rectangle performLayout(boolean bl2) {
        if (bl2 || this.getStatus() != 0) {
            return this.layout.layout(bl2);
        }
        return null;
    }

    public int getControlWidth() {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null) {
            return jComponent.getMinimumSize().width;
        }
        return 0;
    }

    public int getControlHeight() {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null) {
            return jComponent.getMinimumSize().height;
        }
        return 0;
    }

    public void performLayoutWidth() {
        if (this.layout != null) {
            this.layout.layoutWidth();
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void performPreLayout() {
        if (this.layout != null) {
            this.layout.preLayout();
        }
    }

    public void predictWidth(int n2) {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null) {
            this.setSizeContent(n2, jComponent.getHeight() - this.getBox().getTopBorderPadding() - this.getBox().getBottomBorderPadding());
        }
    }

    public String toString() {
        JComponent jComponent = this.getControlComponent();
        return "ControlView: " + this.getElement().toString() + " -> " + (jComponent != null ? jComponent.getClass().getSimpleName() : "NULL");
    }

    public JComponent getControl() {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null && jComponent instanceof JScrollPane) {
            return (JComponent)((JScrollPane)jComponent).getViewport().getComponent(0);
        }
        return jComponent;
    }

    public JComponent getControlPanel() {
        return this.getControlComponent();
    }

    public void performLayoutVAlign(int n2) {
        this.layout.layoutVerticalAlign((int)this.getAlignment(1), n2);
    }

    public int getFirstLineBaseLine() {
        JComponent jComponent = this.getControlComponent();
        if (jComponent != null) {
            if (jComponent instanceof JPanel && ((JPanel)jComponent).getComponentCount() == 1) {
                jComponent = (JComponent)((JPanel)jComponent).getComponent(0);
            }
            if (jComponent instanceof JScrollPane) {
                jComponent = (JComponent)((JScrollPane)jComponent).getViewport().getView();
            }
            try {
                Object object;
                Method method = JComponent.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                if (method != null && (object = method.invoke((Object)jComponent, this.getOuterWidth(), this.getOuterHeight())) != null && object instanceof Integer && (Integer)object >= 0) {
                    return (Integer)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (int)this.layout.getPreferredSpan(2);
    }

    public int getType() {
        return this.type;
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public Object getValue() {
        JComponent jComponent = this.getInnerControl(this.getControl());
        if (jComponent != null && jComponent instanceof JToggleButton) {
            String string = this.getValueAttribute();
            if (string == null) {
                string = ((JToggleButton)jComponent).isSelected() ? "on" : "off";
            }
            return string;
        }
        if (jComponent != null && jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (jComponent != null && jComponent instanceof JTextArea) {
            return ((JTextArea)jComponent).getText();
        }
        if (jComponent != null && jComponent instanceof JComboBox) {
            Object object = ((JComboBox)jComponent).getSelectedItem();
            return object != null ? object.toString() : null;
        }
        if (jComponent != null && jComponent instanceof JList) {
            return ((JList)jComponent).getSelectedValues();
        }
        return this.getValueAttribute();
    }

    private String getValueAttribute() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        if (attributeSet.isDefined((Object)HTML.Attribute.VALUE)) {
            return attributeSet.getAttribute((Object)HTML.Attribute.VALUE).toString();
        }
        return null;
    }

    public String getName() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        if (attributeSet.isDefined((Object)HTML.Attribute.NAME)) {
            return attributeSet.getAttribute((Object)HTML.Attribute.NAME).toString();
        }
        return null;
    }

    public boolean isSuccessful(ControlView controlView) {
        String string = this.getName();
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if (this.type == 7) {
            return true;
        }
        if (this.type == 0) {
            return this == controlView;
        }
        JComponent jComponent = this.getInnerControl(this.getControl());
        if (jComponent != null && jComponent instanceof JToggleButton) {
            return ((JToggleButton)jComponent).isSelected();
        }
        if (jComponent != null && jComponent instanceof JTextField) {
            return true;
        }
        if (jComponent != null && jComponent instanceof JTextArea) {
            return true;
        }
        if (jComponent != null && jComponent instanceof JList) {
            return ((JList)jComponent).getSelectedIndices().length > 0;
        }
        if (jComponent != null && jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem() != null;
        }
        return false;
    }

    private static class CSSBorder
    implements Border {
        private final BoxView view;

        public CSSBorder(BoxView boxView) {
            this.view = boxView;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
            this.view.getBox().paint(graphics, rectangle, 4, this.view);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = this.view.getBox().getBorderInsets();
            Insets insets2 = this.view.getBox().getPadding();
            return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
        }

        public boolean isBorderOpaque() {
            Insets insets = this.view.getBox().getBorderStyles();
            return this.isOpaqueStyle(insets.top) && this.isOpaqueStyle(insets.left) && this.isOpaqueStyle(insets.right) && this.isOpaqueStyle(insets.bottom);
        }

        private boolean isOpaqueStyle(int n2) {
            return n2 != 6 && n2 != 5 && n2 != 8;
        }
    }
}

