/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.ViewPainter;
import com.inet.html.actions.BeginEndLineAction;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.RenderContext;
import com.inet.html.views.form.FormRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HtmlRootView
extends BlockView
implements Cloneable {
    private boolean mustRebuild = true;
    private boolean initiated = false;
    private boolean layouted = false;
    private float oldWidth;
    private float oldHeight;
    private long nextLayout;
    private Shape lastCursor;
    private int lastCursorPos = Integer.MAX_VALUE;
    private Position.Bias lastCursorBias;
    private boolean updateCaret = false;
    private final String update_sync_lock = "updateSync";
    private boolean widthSet;
    private Insets containerInsets = new Insets(0, 0, 0, 0);
    public static final int IMAGE_LOAD_TIMEOUT = 30000;
    private final RenderContext renderContext;
    private boolean layoutRunning;
    private Thread layoutThread;
    private Rectangle span;
    private boolean isForcedReloadPending = false;

    public HtmlRootView(Element element) {
        super(element);
        this.renderContext = new RenderContext(element != null ? element.getDocument() : null, new FormRegistry(), null);
    }

    public HtmlRootView(Element element, ViewPainter viewPainter, InetHtmlFontFactory inetHtmlFontFactory) {
        super(element, viewPainter);
        this.renderContext = new RenderContext(element != null ? element.getDocument() : null, new FormRegistry(), inetHtmlFontFactory);
    }

    public void forceLayout() {
        this.forceLayout(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLayout(long l2) {
        if (this.renderContext.isBlockOnImageLoad()) {
            if (Logger.doesLog(4)) {
                Logger.debug("Forcelayout blocked, cause: blocking render mode.");
            }
            return;
        }
        if (Logger.doesLog(4)) {
            Logger.debug("Forcelayout in " + l2 + "ms");
        }
        if (l2 == 0L) {
            this.initLayout(true, true);
            return;
        }
        long l3 = System.currentTimeMillis();
        HtmlRootView htmlRootView = this;
        synchronized (htmlRootView) {
            if (l3 > this.nextLayout && !this.isForcedReloadPending) {
                this.isForcedReloadPending = true;
                new Thread(new Runnable(){

                    public void run() {
                        while (System.currentTimeMillis() < HtmlRootView.this.nextLayout) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                        if (HtmlRootView.this.initiated) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    HtmlRootView.this.isForcedReloadPending = false;
                                    HtmlRootView.this.initLayout(true, false);
                                    Container container = HtmlRootView.this.getContainer();
                                    if (container != null) {
                                        container.repaint(100L);
                                    }
                                }
                            });
                        }
                    }
                }).start();
            }
        }
        this.nextLayout = l3 + l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(View view) {
        Object object = "updateSync";
        synchronized ("updateSync") {
            block12: {
                CssDocument cssDocument = (CssDocument)this.getDocument();
                int n2 = cssDocument.getRevision();
                int n3 = cssDocument.getSiteCount();
                try {
                    super.setParent(view);
                    if (view == null) {
                        if (this.getViewCount() > 0) {
                            for (int i2 = 0; i2 < this.getViewCount(); ++i2) {
                                this.getView(i2).setParent(null);
                            }
                            this.removeAll();
                        }
                        this.initiated = false;
                        this.layouted = false;
                        this.mustRebuild = true;
                        this.renderContext.resetImageTimeout();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (view instanceof BoxView) {
                        throw new IllegalArgumentException("The tag HTML must not be used within the pages content!");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    EditorKit editorKit = this.renderContext.getTextContainerKit();
                    if (!(editorKit == null || n2 == cssDocument.getRevision() && n3 == cssDocument.getSiteCount() && editorKit instanceof InetHtmlEditorKit)) {
                        this.getContainer().invalidate();
                    }
                    if (this.renderContext.getTextContainerDocument() != cssDocument) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (!Logger.doesLog(1)) break block12;
                    Logger.error(exception);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if ((this.getBackgroundValue() == null || this.getBackgroundValue().isTransparent()) && this.getViewCount() > 0) {
                object = (BoxView)this.getView(0);
                this.getBox().setBackgroundValue(((BoxView)object).getBackgroundValue());
                this.getBox().updateRelevance();
            }
            this.checkForBidiContent();
            this.setStatus(2);
            this.mustRebuild = false;
            return;
        }
    }

    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    private void checkForBidiContent() {
        if (this.getUnicodeBidi() == 2) {
            this.renderContext.notifiyBidi(this.getDirection() == 0 ? 0 : 1, true);
        }
        if (this.getViewCount() > 0) {
            int n2 = this.getView(0).getStartOffset();
            int n3 = this.getView(this.getViewCount() - 1).getEndOffset();
            Segment segment = new Segment();
            try {
                this.getDocument().getText(n2, n3 - n2, segment);
            }
            catch (BadLocationException badLocationException) {
                Logger.error(badLocationException);
            }
            if (Bidi.requiresBidi(segment.array, segment.getBeginIndex(), segment.getEndIndex())) {
                this.renderContext.notifiyBidi(2, true);
            } else {
                this.renderContext.notifiyBidi(0, true);
            }
        }
    }

    protected Rectangle getVisibleRect() {
        Container container = this.getContainer();
        if (container instanceof JComponent) {
            return ((JComponent)container).getVisibleRect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setSize(float f2, float f3) {
        boolean bl2;
        block20: {
            int n2;
            Object object;
            block19: {
                int n3;
                Container container = this.getContainer();
                Rectangle rectangle = this.getVisibleRect();
                if (container instanceof JComponent && rectangle != null) {
                    float f4 = rectangle.width;
                    object = ((JComponent)container).getInsets();
                    if (object != null) {
                        this.containerInsets = object;
                        f4 -= (float)(((Insets)object).left + ((Insets)object).right);
                    }
                    if (container instanceof JEditorPane) {
                        this.renderContext.setTextContainer((JEditorPane)container);
                    }
                    if (f4 <= 0.0f) {
                        if (this.oldWidth != 0.0f) {
                            f2 = this.oldWidth;
                        }
                    } else {
                        f2 = f4;
                    }
                }
                if (this.getRenderContext().isLayoutOnHeightChange() && (n3 = this.getRenderContext().getViewportHeight()) > 0) {
                    f3 = n3;
                }
                n2 = 0;
                try {
                    if (this.getLayout() != null) {
                        n2 = (int)this.getMinimumSpan(0);
                    }
                }
                catch (Exception exception) {
                    if (!Logger.doesLog(1)) break block19;
                    Logger.error(exception.getMessage());
                }
            }
            if (Logger.doesLog(4) && f2 != this.oldWidth) {
                Logger.debug("" + f2 + " : " + n2);
            }
            this.checkReBuild();
            if (!this.initiated) {
                object = "updateSync";
                // MONITORENTER : "updateSync"
                this.performPreLayout();
                // MONITOREXIT : object
                this.initiated = true;
            }
            if ((int)f2 == Integer.MAX_VALUE) {
                try {
                    f2 = this.getPreferredSpan(0);
                }
                catch (Exception exception) {
                    if (!Logger.doesLog(1)) break block20;
                    Logger.error(exception);
                }
            }
        }
        final boolean bl3 = this.getRenderContext().isLayoutOnHeightChange() && this.oldHeight != f3;
        boolean bl4 = bl2 = this.oldWidth != f2;
        if (!bl2) {
            if (!bl3) return;
        }
        super.setSize(f2, f3);
        this.layouted = false;
        this.widthSet = true;
        this.initLayout(false, bl3);
        if (this.getParent() != null) {
            final View view = this.getParent();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (view != null) {
                        view.preferenceChanged(HtmlRootView.this, bl2, bl3);
                    }
                }
            });
        }
        this.oldWidth = f2;
        this.oldHeight = f3;
    }

    private void resetAllStatus(BoxView boxView) {
        boxView.setStatus(2);
        if (boxView.getViewCount() > 0) {
            for (int i2 = 0; i2 < boxView.getViewCount(); ++i2) {
                this.resetAllStatus((BoxView)boxView.getView(i2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPreLayout() {
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: PreLayout requested");
        }
        this.renderContext.checkImageLoading();
        this.layoutThread = Thread.currentThread();
        this.layoutRunning = true;
        try {
            if (Logger.doesLog(4)) {
                Logger.debug("RootView: PreLayout starting");
            }
            super.performPreLayout();
        }
        finally {
            this.layoutThread = null;
            this.layoutRunning = false;
        }
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: PreLayout done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle performLayout(boolean bl2) {
        if (Logger.doesLog(4)) {
            Logger.debug("RootView: Layout starting");
        }
        this.layoutRunning = true;
        this.layoutThread = Thread.currentThread();
        String string = "updateSync";
        synchronized ("updateSync") {
            Rectangle rectangle;
            try {
                rectangle = super.performLayout(bl2);
            }
            finally {
                this.layoutThread = null;
                this.layoutRunning = false;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            this.layouted = true;
            if (Logger.doesLog(4)) {
                Logger.debug("RootView: Layout done");
            }
            return rectangle != null ? rectangle : new Rectangle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performLayoutWidth() {
        String string = "updateSync";
        synchronized ("updateSync") {
            this.layoutThread = Thread.currentThread();
            this.layoutRunning = true;
            try {
                super.performLayoutWidth();
            }
            finally {
                this.layoutThread = null;
                this.layoutRunning = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.layouted = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkReBuild() {
        if (!this.mustRebuild || this.layoutRunning || this.getParent() == null) return;
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:reBuild");
        }
        this.mustRebuild = false;
        View view = this.getParent();
        String string = "updateSync";
        synchronized ("updateSync") {
            CssDocument cssDocument = this.getCssDocument();
            int n2 = cssDocument.getRevision();
            int n3 = cssDocument.getSiteCount();
            try {
                this.setParent(null);
                this.renderContext.clearForms();
                this.setParent(view);
            }
            catch (Exception exception) {
                if (n2 != cssDocument.getRevision() || n3 != cssDocument.getSiteCount()) {
                    this.getContainer().invalidate();
                }
                if (this.renderContext.getTextContainerDocument() != cssDocument) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                if (Logger.doesLog(1)) {
                    Logger.error(exception);
                }
                this.mustRebuild = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLayout(boolean bl2, boolean bl3) {
        String string = "updateSync";
        synchronized ("updateSync") {
            block10: {
                CssDocument cssDocument = this.getCssDocument();
                int n2 = cssDocument.getRevision();
                int n3 = cssDocument.getSiteCount();
                try {
                    if (this.getStatus() == 2 || bl2) {
                        this.performPreLayout();
                        this.initiated = true;
                    }
                    if (!this.widthSet) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    this.performLayoutWidth();
                    this.span = this.performLayout(bl3);
                    this.updateCaret = true;
                    int n4 = this.getOuterWidth();
                    int n5 = this.getOuterHeight();
                    if (this.oldWidth != (float)n4 || this.oldHeight != (float)n5) {
                        super.setSize(n4, n5);
                        if (this.getParent() != null) {
                            final boolean bl4 = this.oldHeight != (float)n5;
                            final boolean bl5 = this.oldWidth != (float)n4;
                            final View view = this.getParent();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (view != null) {
                                        view.preferenceChanged(HtmlRootView.this, bl5, bl4);
                                    } else if (HtmlRootView.this.getParent() != null) {
                                        HtmlRootView.this.getParent().preferenceChanged(HtmlRootView.this, bl5, bl4);
                                    }
                                }
                            });
                        }
                        this.oldWidth = n4;
                        this.oldHeight = n5;
                    }
                }
                catch (Exception exception) {
                    if (n2 != cssDocument.getRevision() || n3 != cssDocument.getSiteCount()) break block10;
                    if (this.renderContext.getTextContainerDocument() != cssDocument || !(this.renderContext.getTextContainerKit() instanceof InetHtmlEditorKit)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    if (!Logger.doesLog(1)) break block10;
                    Logger.error(exception);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkLayout() {
        if (!this.layouted) {
            this.renderContext.checkImageLoading();
            this.initLayout(false, false);
            return;
        }
        this.renderContext.checkImageLoading();
        if (this.layoutRunning && this.renderContext.isBlockOnImageLoad()) {
            String string = "updateSync";
            // MONITORENTER : "updateSync"
            // MONITOREXIT : string
        }
        if (!this.renderContext.isBlockOnImageLoad()) return;
        if (this.getStatus() == 0) return;
        this.initLayout(false, false);
    }

    public float getPreferredSpan(int n2) {
        this.checkReBuild();
        this.checkLayout();
        if (n2 == 0) {
            return this.span != null ? (float)((int)this.span.getMaxX()) : (float)this.getOuterWidth();
        }
        return this.span != null ? (float)((int)this.span.getMaxY()) : (float)this.getOuterHeight();
    }

    public float getMinimumSpan(int n2) {
        this.checkReBuild();
        this.checkLayout();
        if (n2 == 0) {
            Insets insets;
            int n3 = 0;
            JEditorPane jEditorPane = this.renderContext.getTextContainer();
            if (jEditorPane != null && (insets = jEditorPane.getInsets()) != null) {
                n3 += insets.left + jEditorPane.getInsets().right;
            }
            float f2 = (float)(this.span != null ? this.span.getMaxX() - 2.0 : (double)(super.getMinimumSpan(n2) - (float)n3));
            return f2;
        }
        return (float)(this.span != null ? this.span.getMaxY() : (double)this.getOuterHeight());
    }

    public void paint(Graphics graphics, Shape shape) {
        Object object;
        Object object2;
        if (graphics instanceof Graphics2D) {
            this.renderContext.updateTargetDevice(((Graphics2D)graphics).getDeviceConfiguration().getDevice());
            object2 = this.renderContext.getFontRenderContext();
            object = ((Graphics2D)graphics).getFontRenderContext();
            if (!((FontRenderContext)object2).equals((FontRenderContext)object) && ViewUtils.isFRCChangeRelevantToFontSizes((FontRenderContext)object2, (FontRenderContext)object)) {
                this.renderContext.setFontRenderContext((FontRenderContext)object);
                if (this.initiated) {
                    this.resetAllStatus(this);
                    this.initiated = false;
                    this.layouted = false;
                    this.initLayout(true, false);
                }
            }
        }
        if (this.layouted) {
            boolean bl2;
            Object object3;
            block12: {
                this.checkLayout();
                object2 = null;
                if (graphics instanceof Graphics2D) {
                    object = (Graphics2D)graphics;
                    object2 = ((Graphics2D)object).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.renderContext.getTextAntiAliasHint());
                }
                object = shape.getBounds();
                object3 = graphics.getClip() != null ? graphics.getClip().getBounds() : object;
                Rectangle rectangle = this.getVisibleRect();
                if (rectangle != null) {
                    shape = rectangle;
                }
                bl2 = false;
                if (!((Rectangle)object).contains((Rectangle)object3)) {
                    graphics.setClip(((Rectangle)object3).intersection((Rectangle)object));
                    bl2 = true;
                }
                int n2 = Math.max(this.getOuterWidth(), shape.getBounds().width + shape.getBounds().x);
                int n3 = Math.max(this.getOuterHeight(), shape.getBounds().height + shape.getBounds().y);
                Rectangle rectangle2 = new Rectangle(this.containerInsets.left, this.containerInsets.top, n2, n3);
                CssDocument cssDocument = this.getCssDocument();
                int n4 = cssDocument.getRevision();
                int n5 = cssDocument.getSiteCount();
                try {
                    super.paint(graphics, rectangle2);
                }
                catch (Exception exception) {
                    if (n4 != cssDocument.getRevision() || n5 != cssDocument.getSiteCount() || this.renderContext.getTextContainerKit() instanceof InetHtmlEditorKit) {
                        this.getContainer().invalidate();
                    }
                    if (!Logger.doesLog(1)) break block12;
                    Logger.error(exception);
                }
            }
            if (bl2) {
                graphics.setClip((Shape)object3);
            }
            if (object2 != null && object2 != this.renderContext.getTextAntiAliasHint()) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:changedUpdate(" + documentEvent.getOffset() + ":" + documentEvent.getLength() + ")");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        if (documentEvent.getOffset() == 0 && documentEvent.getLength() >= this.getDocument().getLength() && documentEvent.getChange(this.getElement()) != null) {
            this.mustRebuild = true;
            this.checkReBuild();
        } else {
            try {
                object = "updateSync";
                synchronized ("updateSync") {
                    super.changedUpdate(documentEvent, shape, viewFactory);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this.initLayout(false, false);
                }
            }
            catch (Exception exception) {
                this.mustRebuild = true;
                this.checkReBuild();
            }
        }
        {
            object = this.getContainer();
            if (object != null) {
                ((Component)object).repaint();
            }
            this.updateCaret = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:insertUpdate");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        try {
            object = "updateSync";
            synchronized ("updateSync") {
                if (documentEvent.getChange(this.getElement()) != null) {
                    this.setPropertiesFromAttributes(false);
                }
                super.insertUpdate(documentEvent, shape, viewFactory);
                if (documentEvent.getChange(this.getElement()) != null && (this.getBackgroundValue() == null || this.getBackgroundValue().toString().equals("transparent")) && this.getViewCount() > 0) {
                    BoxView boxView = (BoxView)this.getView(0);
                    this.setBackgroundValue(boxView.getBackgroundValue());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.initLayout(false, false);
            }
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
            this.mustRebuild = true;
            this.checkReBuild();
        }
        {
            object = this.getContainer();
            if (object != null) {
                ((Component)object).repaint();
            }
            this.updateCaret = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        if (Logger.doesLog(4)) {
            Logger.debug("HtmlRootView:removeUpdate");
        }
        this.oldHeight = this.getOuterHeight();
        this.oldWidth = this.getOuterWidth();
        try {
            object = "updateSync";
            synchronized ("updateSync") {
                super.removeUpdate(documentEvent, shape, viewFactory);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.initLayout(false, false);
            }
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error("Exception while updating views:");
            }
            exception.printStackTrace();
            this.mustRebuild = true;
            this.checkReBuild();
        }
        {
            object = this.getContainer();
            if (object != null) {
                ((Component)object).repaint();
            }
            this.updateCaret = true;
            return;
        }
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        try {
            return super.viewToModel(f2, f3, shape, biasArray);
        }
        catch (Exception exception) {
            if (Logger.doesLog(2)) {
                Logger.warning("HtmlRootView.viewToModel:" + exception.getMessage());
            }
            return 0;
        }
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.nativeModelToView(n2, shape, bias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shape nativeModelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        try {
            Shape shape2;
            boolean bl2;
            ((AbstractDocument)this.getDocument()).readLock();
            boolean bl3 = bl2 = n2 > this.lastCursorPos;
            if (this.lastCursorPos != n2 || this.lastCursorBias != bias || this.updateCaret || this.lastCursor == null) {
                this.updateCaret = false;
                shape2 = shape.getBounds();
                this.lastCursorPos = n2;
                this.lastCursorBias = bias;
                boolean bl4 = false;
                do {
                    this.lastCursor = super.modelToView(n2, shape2, bias);
                    if (this.lastCursor != null) continue;
                    if (bl2) {
                        if (++n2 <= this.getDocument().getLength()) continue;
                        if (bl4) {
                            if (this.lastCursor == null) {
                                if (Logger.doesLog(4)) {
                                    Logger.debug("modelToView " + n2 + " # " + shape + " # " + bias + " FAILED");
                                }
                                Shape shape3 = shape;
                                return shape3;
                            }
                            Shape shape4 = this.lastCursor;
                            return shape4;
                        }
                        --n2;
                        bl2 = false;
                        bl4 = true;
                        continue;
                    }
                    if (--n2 > 1) continue;
                    if (bl4) {
                        if (this.lastCursor == null) {
                            if (Logger.doesLog(4)) {
                                Logger.debug("modelToView " + n2 + " # " + shape + " # " + bias + " FAILED");
                            }
                            Shape shape5 = shape;
                            return shape5;
                        }
                        Shape shape6 = this.lastCursor;
                        return shape6;
                    }
                    ++n2;
                    bl2 = true;
                    bl4 = true;
                } while (this.lastCursor == null && n2 > 1 && n2 <= this.getDocument().getLength());
            }
            if (this.lastCursor == null) {
                if (Logger.doesLog(4)) {
                    Logger.debug("modelToView " + n2 + " # " + shape + " # " + bias + " FAILED");
                }
                shape2 = shape;
                return shape2;
            }
            shape2 = this.lastCursor;
            return shape2;
        }
        finally {
            ((AbstractDocument)this.getDocument()).readUnlock();
        }
    }

    public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        switch (n3) {
            case 1: 
            case 5: {
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                if (n2 == -1 || jTextComponent == null) {
                    return n3 == 1 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                }
                Shape shape2 = this.nativeModelToView(n2, shape, bias);
                int n4 = shape2 == null ? 0 : shape2.getBounds().x;
                int n5 = HtmlRootView.getPositionAboveBelow(jTextComponent, n2, n4, n3 == 1);
                if (n5 >= this.getDocument().getLength()) {
                    n5 = super.getNextVisualPositionFrom(n5, bias, shape, 3, biasArray);
                }
                return n5;
            }
            case 3: 
            case 7: {
                int n6 = super.getNextVisualPositionFrom(n2, bias, shape, n3, biasArray);
                Shape shape3 = super.modelToView(n6, shape, Position.Bias.Forward);
                if (n6 > this.getDocument().getLength()) {
                    return n2;
                }
                int n7 = n6 - 1;
                int n8 = 0;
                while (shape3 == null && n6 >= 0 && n6 < this.getDocument().getLength() && n7 != n6) {
                    n7 = n6;
                    n6 = super.getNextVisualPositionFrom(n6, bias, shape, n3, biasArray);
                    shape3 = super.modelToView(n6, new Rectangle(0, 0, 0, 0), Position.Bias.Forward);
                    if (n8++ < 100000) continue;
                }
                return n6;
            }
        }
        return super.getNextVisualPositionFrom(n2, bias, shape, n3, biasArray);
    }

    private static final int getPositionAboveBelow(JTextComponent jTextComponent, int n2, int n3, boolean bl2) throws BadLocationException {
        int n4 = jTextComponent.getDocument().getLength();
        int n5 = 0;
        int n6 = bl2 ? -1 : 1;
        if ((n2 = BeginEndLineAction.getRowBeginEnd(jTextComponent, n2, bl2) + n6) < 0) {
            return -1;
        }
        int n7 = Integer.MAX_VALUE;
        Rectangle rectangle = jTextComponent.modelToView(n2);
        if (rectangle == null) {
            return -1;
        }
        int n8 = rectangle.y;
        int n9 = n8 + rectangle.height;
        do {
            int n10;
            if ((n10 = Math.abs(n3 - (rectangle != null ? rectangle.x : 0))) > n7) {
                return n2 - n6;
            }
            n7 = n10;
            n2 = bl2 ? --n2 : ++n2;
            Rectangle rectangle2 = rectangle = n2 <= n4 && n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        } while (n5++ < 100000 && (rectangle != null && n9 > rectangle.y && n8 < rectangle.y + rectangle.height || rectangle == null && n2 <= n4 && n2 >= 0));
        return n2 - n6;
    }

    public HtmlRootView getHTMLRoot() {
        return this;
    }

    public void setAntiAlias(boolean bl2) {
        this.renderContext.setAntiAlias(bl2);
    }

    public void setFraction(boolean bl2) {
        this.renderContext.setFraction(bl2);
    }

    private CssDocument getCssDocument() {
        return (CssDocument)this.getDocument();
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public void blockOnLayoutRunning() {
        if (this.layoutThread == Thread.currentThread() || !this.layoutRunning) {
            return;
        }
        for (int i2 = 1000; this.layoutRunning && i2 > 0; --i2) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public boolean isPositionRoot() {
        return true;
    }
}

