/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.MinMaxControl;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ImageView
extends BoxView {
    private static final int DEFAULT_SIZE = 32;
    private Image image;
    private RemoteImage fetcher;
    private Rectangle lastPaint = new Rectangle();
    private boolean loadComplete = false;
    private final AnimationObserver imageObserver;
    private String predictSource;
    private URL baseURL;
    private Dimension imageSize = new Dimension(32, 32);
    private Dimension calculatedSize = null;
    private Dimension displaySize = null;
    private static Icon pendingImage;
    private static Icon missingImage;
    private BoxView listItemFallback;
    private boolean listItemFallBackActive;
    private URL url;
    private static Font ALT_TEXT_FONT;
    private Rectangle gifDeltaBounds = null;
    private MinMaxControl minMaxControl;
    private MinMaxControl sizeLimitControl;
    private boolean showZoomIcon = false;

    public ImageView(Element element) {
        super(element);
        this.imageObserver = new ImageHandler(element.getDocument().getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
    }

    public ImageView(Element element, ViewPainter viewPainter) {
        super(element, viewPainter);
        this.imageObserver = new ImageHandler(element.getDocument().getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
    }

    public int getContentWidth() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getContentWidth();
        }
        int n2 = super.getContentWidth();
        if (n2 <= 0) {
            return 32;
        }
        return n2;
    }

    public int getContentHeight() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getContentHeight();
        }
        int n2 = super.getContentHeight();
        if (n2 <= 0) {
            return 32;
        }
        return n2;
    }

    public int getOuterHeight() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getOuterHeight();
        }
        int n2 = super.getOuterHeight();
        if (n2 <= 0) {
            return 32 + this.getTopInset() + this.getBottomInset();
        }
        return n2;
    }

    public int getOuterWidth() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getOuterWidth();
        }
        int n2 = super.getOuterWidth();
        if (n2 <= 0) {
            return 32 + this.getLeftInset() + this.getRightInset();
        }
        return n2;
    }

    public float getPreferredSpan(int n2) {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getPreferredSpan(n2);
        }
        if (n2 == 0) {
            return this.getContentWidth() + this.getLeftInset() + this.getRightInset();
        }
        if (n2 == 2) {
            if (this.listItemFallback != null && this.listItemFallBackActive) {
                return this.listItemFallback.getPreferredSpan(2) + (float)this.getTopInset();
            }
            return this.getOuterHeight();
        }
        return this.getContentHeight() + this.getTopInset() + this.getBottomInset();
    }

    public int getResizeWeight(int n2) {
        return 0;
    }

    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        if (n2 >= n3 && n2 <= n4) {
            Rectangle rectangle = shape.getBounds();
            if (n2 == n4) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f2 < (float)(rectangle.x + rectangle.width)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public void paint(Graphics graphics, Shape shape) {
        int n2;
        JTextComponent jTextComponent;
        Object object;
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = (Rectangle)shape;
        if (rectangle != null && !rectangle.intersects(rectangle2)) {
            return;
        }
        if (this.isCanceledByPainter(graphics, shape)) {
            return;
        }
        Rectangle rectangle3 = null;
        if (this.gifDeltaBounds != null && (this.gifDeltaBounds.x != 0 || this.gifDeltaBounds.y != 0 || this.gifDeltaBounds.width != this.getContentWidth() || this.gifDeltaBounds.height != this.getContentHeight())) {
            rectangle3 = ((Graphics2D)graphics).getClipBounds();
            ((Graphics2D)graphics).setClip(rectangle2.x + this.getLeftInset() + this.gifDeltaBounds.x, rectangle2.y + this.getTopInset() + this.gifDeltaBounds.y, this.gifDeltaBounds.width, this.gifDeltaBounds.height);
        }
        this.getBox().paint(graphics, rectangle2, 0, this);
        this.lastPaint.setBounds(rectangle2);
        Container container = this.getContainer();
        boolean bl2 = false;
        if (container instanceof JTextComponent && !this.isMarker() && (object = (jTextComponent = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            int n3 = this.getStartOffset();
            n2 = this.getEndOffset();
            ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n3, n2, shape, jTextComponent, this);
            for (Highlighter.Highlight object2 : object.getHighlights()) {
                if (object2.getEndOffset() <= n3 || object2.getStartOffset() >= n2) continue;
                bl2 = true;
            }
        }
        boolean bl3 = false;
        object = this.getImage();
        try {
            bl3 = object != null && ((Image)object).getWidth(this.imageObserver) > 0 && ((Image)object).getHeight(this.imageObserver) > 0 && this.isLoadComplete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (bl3) {
            if (this.gifDeltaBounds == null) {
                graphics.drawImage((Image)object, rectangle2.x + this.getLeftInset(), rectangle2.y + this.getTopInset(), this.getContentWidth(), this.getContentHeight(), this.imageObserver);
            } else {
                graphics.drawImage((Image)object, rectangle2.x + this.getLeftInset() + this.gifDeltaBounds.x, rectangle2.y + this.getTopInset() + this.gifDeltaBounds.y, this.gifDeltaBounds.width, this.gifDeltaBounds.height, this.imageObserver);
            }
            if (this.showZoomIcon) {
                graphics.setColor(this.sizeLimitControl != null ? Color.RED : Color.GREEN);
                graphics.fillRect(rectangle2.x + this.getLeftInset(), rectangle2.y + this.getTopInset(), 20, 20);
            }
        } else {
            if (this.listItemFallback != null && this.listItemFallBackActive) {
                this.listItemFallback.paint(graphics, shape);
                return;
            }
            Icon icon = object == null ? ImageView.getMissingImage() : ImageView.getPendingImage();
            n2 = rectangle2.y + this.getTopInset();
            int n4 = rectangle2.x + this.getLeftInset();
            int n5 = n4 + this.getContentWidth();
            int n6 = n2 + this.getContentHeight();
            String string = this.getAltText();
            if (icon != null || string != null) {
                Shape shape2 = graphics.getClip();
                if (shape2 != null) {
                    graphics.setClip(new Rectangle(n4, n2, n5 - n4, n6 - n2).intersection(shape2.getBounds()));
                }
                int n3 = 0;
                if (icon != null) {
                    n3 += icon.getIconWidth();
                    icon.paintIcon(this.getContainer(), graphics, rectangle2.x + this.getLeftInset(), rectangle2.y + this.getTopInset());
                }
                if (string != null) {
                    graphics.setFont(ALT_TEXT_FONT);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    if (bl2 && this.getRenderContext().getTextContainer() != null) {
                        graphics.setColor(this.getRenderContext().getTextContainer().getSelectedTextColor());
                    } else {
                        graphics.setColor(AttributeFinder.COLOR.getAttributeValue(this).getValue());
                    }
                    graphics.drawString(string, n4 + n3, n2 + fontMetrics.getHeight());
                }
                graphics.setClip(shape2);
            }
            graphics.setColor(ColorUtils.get3DDark());
            graphics.drawLine(n4, n2, n5, n2);
            graphics.drawLine(n4, n2, n4, n6);
            graphics.setColor(ColorUtils.get3DLight());
            graphics.drawLine(n4, n6, n5, n6);
            graphics.drawLine(n5, n2, n5, n6);
        }
        if (bl2) {
            JTextComponent jTextComponent2 = (JTextComponent)container;
            Color color = jTextComponent2.getSelectionColor();
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
            graphics.setColor(color2);
            graphics.fillRect(rectangle2.x + this.getLeftInset(), rectangle2.y + this.getTopInset(), this.getContentWidth(), this.getContentHeight());
        }
        if (rectangle3 != null) {
            ((Graphics2D)graphics).setClip(rectangle3);
        }
    }

    public boolean isLoadComplete() {
        return this.loadComplete;
    }

    protected void setPropertiesFromAttributes(boolean bl2) {
        LengthUnit lengthUnit;
        HtmlAttribute htmlAttribute;
        if (this.getParent() == null) {
            return;
        }
        super.setPropertiesFromAttributes(false);
        this.loadImage();
        IntegerValue integerValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VSPACE);
        IntegerValue integerValue2 = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.HSPACE);
        if (integerValue != null) {
            htmlAttribute = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_TOP);
            if (htmlAttribute == null || ((LengthUnit)htmlAttribute).getValue() == 0.0f) {
                this.getBox().setMargins().top = integerValue.getInt();
            }
            if ((lengthUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_BOTTOM)) == null || lengthUnit.getValue() == 0.0f) {
                this.getBox().setMargins().bottom = integerValue.getInt();
            }
        }
        if (integerValue2 != null) {
            htmlAttribute = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_LEFT);
            if (htmlAttribute == null || ((LengthUnit)htmlAttribute).getValue() == 0.0f) {
                this.getBox().setMargins().left = integerValue2.getInt();
            }
            if ((lengthUnit = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_RIGHT)) == null || lengthUnit.getValue() == 0.0f) {
                this.getBox().setMargins().right = integerValue2.getInt();
            }
        }
        this.performLayoutWidth();
        htmlAttribute = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT_ALIGN);
        if (htmlAttribute != null && ((FloatValue)htmlAttribute).getFloat() == 1) {
            this.setJustification((byte)1);
        }
        this.minMaxControl = new MinMaxControl(this);
        if (!this.minMaxControl.hasWHConstraint()) {
            this.minMaxControl = null;
        }
    }

    private URL getBaseUrl() {
        if (this.baseURL != null) {
            return this.baseURL;
        }
        InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.getDocument();
        return inetHtmlDocument.getBase();
    }

    private void loadImage() {
        DocumentImage documentImage;
        if (this.getImage() != null) {
            return;
        }
        String string = this.getImageSrc();
        string = string != null ? string.trim() : null;
        URL uRL = this.getBaseUrl();
        if (this.getAttributes().isDefined(StyleConstants.IconAttribute) && (documentImage = (DocumentImage)this.getAttributes().getAttribute(StyleConstants.IconAttribute)) != null && documentImage.getImageData() != null) {
            Image image = documentImage.getImageData().getImage();
            if (!ImageCache.isCacheReference(documentImage.getUrl())) {
                if (documentImage.getUrl() != null) {
                    string = documentImage.getUrl();
                    if (image != null) {
                        documentImage.removeChachedImage();
                        ImageCache.getStaticInstance().addImage(string, uRL, image);
                        this.setImage(image);
                        return;
                    }
                } else {
                    if (image != null) {
                        String string2 = ImageCache.getStaticInstance().registerImage(image);
                        documentImage.setURL(string2);
                        this.setImage(image);
                        return;
                    }
                    if (Logger.doesLog(2)) {
                        Logger.warning("Image load failed: empty document image.");
                    }
                }
            } else {
                if (image != null) {
                    this.setImage(image);
                    return;
                }
                string = documentImage.getUrl();
            }
        }
        if (string != null) {
            this.fetcher = ImageCache.getStaticInstance().getImage(string, uRL, this.imageObserver);
            if (this.fetcher != null && this.fetcher.getStatus() <= 1) {
                this.getRenderContext().notifyImageLoad(this.fetcher);
            }
        } else {
            this.setImage(null);
        }
    }

    protected String getImageSrc() {
        if (this.predictSource != null) {
            return this.predictSource;
        }
        UrlValue urlValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.SRC);
        if (urlValue != null) {
            return urlValue.getUrl();
        }
        return null;
    }

    private String getAltText() {
        if (this.getAttributes().isDefined((Object)HTML.Attribute.ALT)) {
            return this.getAttributes().getAttribute((Object)HTML.Attribute.ALT).toString();
        }
        return null;
    }

    void repaint(boolean bl2) {
        if (bl2) {
            this.setStatus(2);
            this.performLayoutWidth();
            this.forceLayout(500L);
        } else {
            if (this.lastPaint == null) {
                return;
            }
            Container container = this.getContainer();
            if (container != null) {
                container.repaint(this.lastPaint.x, this.lastPaint.y, this.lastPaint.width, this.lastPaint.height);
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    private synchronized void setImage(Image image) {
        this.image = image;
        boolean bl2 = this.loadComplete = image != null;
        if (image == null) {
            if (this.listItemFallback == null) {
                if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
                    return;
                }
                String string = this.getAltText();
                if (string != null) {
                    FontMetrics fontMetrics = this.getFontMetrics();
                    int n2 = fontMetrics.stringWidth(string);
                    int n3 = ImageView.getMissingImage() != null ? ImageView.getMissingImage().getIconWidth() : 0;
                    int n4 = Math.max(32, n2 + n3 + 1);
                    this.setContentWidth(n4);
                    this.imageSize.width = n4;
                    if (n4 != 32) {
                        this.repaint(true);
                    }
                }
            }
        } else {
            this.listItemFallBackActive = false;
            this.listItemFallback = null;
            try {
                this.imageSize = new Dimension(image.getWidth(this.imageObserver), image.getHeight(this.imageObserver));
            }
            catch (SecurityException securityException) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to display image '" + this.getImageSrc() + "' due to security restrictions");
                }
                this.setImage(null);
            }
        }
    }

    private FontMetrics getFontMetrics() {
        JEditorPane jEditorPane = this.getRenderContext().getTextContainer();
        return jEditorPane != null ? ((Component)jEditorPane).getFontMetrics(ALT_TEXT_FONT) : Toolkit.getDefaultToolkit().getFontMetrics(ALT_TEXT_FONT);
    }

    public void performPreLayout() {
        this.setStatusLocal(1);
        this.setStatus(1);
    }

    public Rectangle performLayout(boolean bl2) {
        this.setStatusLocal(0);
        this.displaySize = new Dimension(this.calculatedSize != null ? this.calculatedSize : this.imageSize);
        if (this.minMaxControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            this.displaySize = this.minMaxControl.getMinMaxValues(false, this.displaySize.width, this.displaySize.height);
        }
        if (this.sizeLimitControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            this.displaySize = this.sizeLimitControl.getMinMaxValues(false, this.displaySize.width, this.displaySize.height);
        }
        this.setFirstLineBaseLine((short)this.displaySize.height);
        this.setSizeContent(this.displaySize.width, this.displaySize.height);
        return new Rectangle(this.displaySize);
    }

    public void performLayoutWidth() {
        Dimension dimension;
        if (this.getParent() == null) {
            return;
        }
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            this.setSizeContent((int)this.listItemFallback.getPreferredSpan(0), (int)this.listItemFallback.getPreferredSpan(1));
            return;
        }
        this.calculatedSize = new Dimension(this.imageSize);
        ILayouted iLayouted = (ILayouted)((Object)this.getParent());
        if (iLayouted == null) {
            return;
        }
        Layout layout = iLayouted.getLayout();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto() && layout != null) {
            this.calculatedSize.width = (int)this.getWidthUnit().calculateValue(layout.getCurrentWidth(), this);
            bl2 = true;
        }
        if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto() && layout != null) {
            this.calculatedSize.height = (int)this.getHeightUnit().calculateValue(layout.getCurrentHeight(), this);
            bl3 = true;
        }
        if (bl2 && !bl3 && this.imageSize.width > 0 && this.calculatedSize.width > 0) {
            this.calculatedSize.height = this.calculatedSize.width * this.calculatedSize.height / this.imageSize.width;
        }
        if (bl3 && !bl2 && this.imageSize.height > 0 && this.calculatedSize.height > 0) {
            this.calculatedSize.width = this.calculatedSize.width * this.calculatedSize.height / this.imageSize.height;
        }
        this.displaySize = new Dimension(this.calculatedSize.width < 0 ? 32 : this.calculatedSize.width, this.calculatedSize.height < 0 ? 32 : this.calculatedSize.height);
        if (this.minMaxControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            dimension = this.minMaxControl.getMinMaxValues(true, this.displaySize.width, this.displaySize.height);
            this.displaySize.width = dimension.width;
        }
        if (this.sizeLimitControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            dimension = this.sizeLimitControl.getMinMaxValues(true, this.displaySize.width, this.displaySize.height);
            this.displaySize.width = dimension.width;
        }
        this.setFirstLineBaseLine((short)this.displaySize.height);
        this.setSizeContent(this.displaySize.width, this.displaySize.height);
    }

    public String toString() {
        return "IMG: " + this.getImageSrc();
    }

    private static Icon getMissingImage() {
        if (missingImage == null) {
            try {
                missingImage = (Icon)UIManager.getLookAndFeelDefaults().get("html.missingImage");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return missingImage;
    }

    private static Icon getPendingImage() {
        if (pendingImage == null) {
            try {
                pendingImage = (Icon)UIManager.getLookAndFeelDefaults().get("html.pendingImage");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pendingImage;
    }

    public void performLayoutVAlign(int n2) {
        int n3;
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return;
        }
        int n4 = this.getContentHeight();
        Image image = this.getImage();
        int n5 = 32;
        if (image != null) {
            try {
                n5 = image.getHeight(this.imageObserver);
            }
            catch (SecurityException securityException) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to display image '" + this.getImageSrc() + "' due to security restrictions");
                }
                this.setImage(null);
            }
        }
        if ((n3 = n4 - n5) > 0) {
            switch ((int)this.getAlignment(1)) {
                case 8: {
                    this.setContentVerticalOffset(n3);
                    break;
                }
                case 2: {
                    this.setContentVerticalOffset(n3 / 2);
                    break;
                }
                case 7: {
                    this.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.setContentVerticalOffset(0);
        }
    }

    public void predictSource(String string) {
        this.predictSource = string;
    }

    public void setBase(URL uRL) {
        this.baseURL = uRL;
    }

    public void setListItemFallback(BoxView boxView) {
        this.listItemFallback = boxView;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null && this.fetcher != null) {
            this.fetcher.removeObserver(this.imageObserver);
        }
        if (view != null && this.listItemFallback != null && this.image == null) {
            this.listItemFallback.setParent(this);
            this.listItemFallBackActive = true;
        }
    }

    public void setAutoScaleMode(boolean bl2) {
        this.sizeLimitControl = bl2 ? new MinMaxControl(this, new LengthUnit("100%"), new LengthUnit("100%")) : null;
        if (this.getParent() != null) {
            this.repaint(true);
        }
    }

    public boolean isAutoScaleMode() {
        return this.sizeLimitControl != null;
    }

    public void setZoomIconVisible(boolean bl2) {
        this.showZoomIcon = bl2;
        this.repaint(false);
    }

    static {
        ALT_TEXT_FONT = new Font("Sans Serif", 0, 10);
    }

    private class ImageHandler
    implements AnimationObserver {
        private final boolean doAnimate;

        public ImageHandler(boolean bl2) {
            this.doAnimate = bl2;
        }

        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            boolean bl2;
            boolean bl3;
            Image image2 = ImageView.this.getImage();
            boolean bl4 = (n2 & 1) != 0;
            boolean bl5 = bl3 = (n2 & 2) != 0;
            if (image != null && image2 != image) {
                Dimension dimension = ImageView.this.imageSize;
                ImageView.this.setImage(image);
                if (!dimension.equals(ImageView.this.imageSize)) {
                    ImageView.this.repaint(true);
                    bl3 = false;
                    bl4 = false;
                }
            }
            if (ImageView.this.getParent() == null) {
                return false;
            }
            boolean bl6 = bl2 = bl4 && n5 != ((ImageView)ImageView.this).imageSize.width || bl3 && n6 != ((ImageView)ImageView.this).imageSize.height;
            if ((bl4 || bl3) && bl2) {
                ImageView.this.imageSize = new Dimension(bl4 ? n5 : ((ImageView)ImageView.this).imageSize.width, bl3 ? n6 : ((ImageView)ImageView.this).imageSize.height);
                ImageView.this.repaint(true);
            }
            if ((n2 & 0xC0) != 0) {
                ImageView.this.loadComplete = false;
                ImageView.this.getRenderContext().notifyImageLoadDone(ImageView.this.fetcher);
                ImageView.this.setImage(null);
                return false;
            }
            if ((n2 & 0x30) != 0) {
                if (n3 == 0 && n4 == 0) {
                    ImageView.this.gifDeltaBounds = null;
                    if (bl2) {
                        ImageView.this.imageSize = new Dimension(bl4 ? n5 : ((ImageView)ImageView.this).imageSize.width, bl3 ? n6 : ((ImageView)ImageView.this).imageSize.height);
                    }
                    ImageView.this.repaint(bl2);
                } else {
                    Container container;
                    ImageView.this.gifDeltaBounds = new Rectangle(n3, n4, n5, n6);
                    if (ImageView.this.lastPaint != null && (container = ImageView.this.getContainer()) != null) {
                        container.repaint(((ImageView)ImageView.this).lastPaint.x + n3, ((ImageView)ImageView.this).lastPaint.y + n4, n5, n6);
                    }
                }
                ImageView.this.getRenderContext().notifyImageLoadDone(ImageView.this.fetcher);
                ImageView.this.loadComplete = true;
            } else if ((n2 & 8) != 0) {
                ImageView.this.loadComplete = false;
            }
            return (n2 & 0x20) == 0;
        }

        public boolean doAnimate() {
            return this.doAnimate;
        }
    }
}

