/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.BoxView;
import com.inet.html.views.ImageView;
import com.inet.html.views.layouts.Layout;
import java.awt.Dimension;
import javax.swing.text.View;

public class MinMaxControl {
    private BoxView view;
    private LengthUnit minWidth;
    private LengthUnit minHeight;
    private LengthUnit maxWidth;
    private LengthUnit maxHeight;
    private boolean hasWHConstraint;
    private boolean hasNoIntrinsicHeight = true;
    private boolean hasNoIntrinsicWidth = true;

    public MinMaxControl(BoxView boxView) {
        this.view = boxView;
        switch (boxView.getDisplay()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            default: {
                this.minWidth = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.MIN_WIDTH);
                this.minHeight = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.MIN_HEIGHT);
                this.maxWidth = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.MAX_WIDHT);
                this.maxHeight = StyleResolver.getAttributeValue(boxView.getElement(), AttributeFinder.MAX_HEIGHT);
                if (this.minWidth != null && !this.minWidth.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.minHeight != null && !this.minHeight.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.maxWidth != null && !this.maxWidth.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (this.maxHeight != null && !this.maxHeight.isAuto()) {
                    this.hasWHConstraint = true;
                }
                if (!this.hasWHConstraint) {
                    this.minHeight = null;
                    this.minWidth = null;
                    this.maxHeight = null;
                    this.maxWidth = null;
                    break;
                }
                if (!(boxView instanceof ImageView)) break;
                this.hasNoIntrinsicWidth = boxView.getWidthUnit() != null && !boxView.getWidthUnit().isAuto();
                this.hasNoIntrinsicHeight = boxView.getHeightUnit() != null && !boxView.getHeightUnit().isAuto();
            }
        }
    }

    public MinMaxControl(BoxView boxView, LengthUnit lengthUnit, LengthUnit lengthUnit2) {
        this.view = boxView;
        this.maxWidth = lengthUnit;
        this.maxHeight = lengthUnit2;
        this.hasWHConstraint = true;
        if (boxView instanceof ImageView) {
            this.hasNoIntrinsicWidth = boxView.getWidthUnit() != null && !boxView.getWidthUnit().isAuto();
            this.hasNoIntrinsicHeight = boxView.getHeightUnit() != null && !boxView.getHeightUnit().isAuto();
        }
    }

    public boolean hasWHConstraint() {
        return this.hasWHConstraint;
    }

    public Dimension getMinMaxValues(boolean bl2, int n2, int n3) {
        if (!this.hasWHConstraint) {
            return new Dimension(n2, n3);
        }
        int n4 = this.getLengthValue(this.minWidth, 0, false);
        int n5 = Math.max(this.getLengthValue(this.maxWidth, n2, false), n4);
        if (bl2) {
            if (n2 > n5) {
                n2 = n5;
            } else if (n2 < n4) {
                n2 = n4;
            }
            return new Dimension(n2, 0);
        }
        int n6 = this.getLengthValue(this.minHeight, 0, true);
        int n7 = Math.max(this.getLengthValue(this.maxHeight, n3, true), n6);
        if (n2 > n5) {
            if (n3 > n7) {
                if ((float)n5 / (float)n2 < (float)n7 / (float)n3) {
                    return new Dimension(n5, Math.max(n6, this.hasNoIntrinsicHeight ? n3 : n5 * n3 / n2));
                }
                return new Dimension(Math.max(n4, this.hasNoIntrinsicWidth ? n2 : n7 * n2 / n3), n7);
            }
            n3 = Math.max(this.hasNoIntrinsicHeight ? n3 : n5 * n3 / n2, n6);
            n2 = n5;
        } else if (n2 < n4) {
            if (n3 < n6) {
                if ((float)n4 / (float)n2 <= (float)n6 / (float)n3) {
                    return new Dimension(Math.min(n5, this.hasNoIntrinsicWidth ? n2 : (n3 > 0 ? n6 * n2 / n3 : 0)), n6);
                }
                return new Dimension(n4, Math.min(n7, this.hasNoIntrinsicHeight ? n3 : n4 * n3 / n2));
            }
            n3 = Math.min(this.hasNoIntrinsicHeight ? n3 : n6 * n3 / n2, n7);
            n2 = n4;
        } else {
            if (n3 > n7) {
                return new Dimension(Math.max(this.hasNoIntrinsicWidth ? n2 : n7 * n2 / n3, n4), n7);
            }
            if (n3 < n6) {
                return new Dimension(Math.min(this.hasNoIntrinsicWidth ? n2 : (n3 > 0 ? n6 * n2 / n3 : 0), n5), n6);
            }
        }
        return new Dimension(n2, n3);
    }

    private int getLengthValue(LengthUnit lengthUnit, int n2, boolean bl2) {
        if (lengthUnit == null || lengthUnit.isAuto() || lengthUnit.isAsterisk() || bl2 && !this.hasDefinedHeight(Layout.getHeightParent(this.view))) {
            return n2;
        }
        if (lengthUnit.isAbsolute()) {
            return Math.round(lengthUnit.getValue());
        }
        if (bl2) {
            BoxView boxView = Layout.getHeightParent(this.view);
            return Math.round(lengthUnit.calculateValue(Layout.getHeight(this.view, boxView, true), boxView));
        }
        View view = this.view.getParent();
        float f2 = view instanceof BoxView ? (float)((BoxView)view).getContentWidth() : view.getPreferredSpan(0);
        return Math.round(lengthUnit.calculateValue(f2, view));
    }

    private boolean hasDefinedHeight(BoxView boxView) {
        if (boxView != null) {
            return boxView.getHeightUnit() != null && !boxView.getHeightUnit().isAuto();
        }
        return true;
    }
}

